/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.key.indicators.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.util.DataTooLongGenerateRespUtil;
import com.biz.crm.tpm.business.key.indicators.local.entity.KeyIndicators;
import com.biz.crm.tpm.business.key.indicators.sdk.dto.KeyIndicatorsDto;
import com.biz.crm.tpm.business.key.indicators.sdk.service.KeyIndicatorsService;
import com.biz.crm.tpm.business.key.indicators.sdk.vo.KeyIndicatorsVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/keyIndicators"})
@Api(tags={"\u5173\u952e\u6307\u6807"})
public class KeyIndicatorsController {
    private static final Logger log = LoggerFactory.getLogger(KeyIndicatorsController.class);
    @Autowired
    private KeyIndicatorsService keyIndicatorsService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<KeyIndicatorsVO>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=20) Pageable pageable, @ApiParam(name="keyIndicatorsDto", value="\u5173\u952e\u6307\u6807\u4fe1\u606f") KeyIndicatorsDto keyIndicators) {
        try {
            Page page = this.keyIndicatorsService.findByConditions(pageable, keyIndicators);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"/findById"})
    public Result<KeyIndicatorsVO> findById(@RequestParam(value="id") @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            KeyIndicatorsVO keyIndicatorsVO = this.keyIndicatorsService.findById(id);
            return Result.ok((Object)keyIndicatorsVO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u627ebean")
    @GetMapping(value={"/findBeanByCondition"})
    public Result<KeyIndicatorsVO> findBeanByCondition(@RequestParam(value="beanCode") @ApiParam(name="beanCode", value="\u5173\u952e\u6307\u6807\u7f16\u7801") String beanCode, @RequestParam(value="beanTypes") @ApiParam(name="beanTypes", value="\u6307\u6807\u7c7b\u578b\u62fc\u63a5") String beanTypes) {
        try {
            return Result.ok((Object)this.keyIndicatorsService.findBeanByCondition(beanCode, beanTypes));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7bean\u540d\u79f0\u67e5\u8be2bean\u8def\u5f84")
    @GetMapping(value={"/findBeanPath"})
    public Result<KeyIndicatorsVO> findBeanPath(@RequestParam(value="beanName") @ApiParam(name="beanName", value="bean\u540d\u79f0") String beanName) {
        try {
            KeyIndicatorsVO vo = this.keyIndicatorsService.findBeanPath(beanName);
            return Result.ok((Object)vo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2bean\u540d\u79f0")
    @GetMapping(value={"/findBeanNames"})
    public Result<List<String>> findBeanName(@RequestParam(value="beanName") @ApiParam(name="beanName", value="bean\u540d\u79f0") String beanName) {
        try {
            List beanNames = this.keyIndicatorsService.findBeanName(beanName);
            return Result.ok((Object)beanNames);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<?> create(@ApiParam(name="keyIndicators", value="\u5173\u952e\u6307\u6807") @RequestBody KeyIndicatorsDto keyIndicators) {
        try {
            return Result.ok((Object)this.keyIndicatorsService.create(keyIndicators));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)DataTooLongGenerateRespUtil.generateRespStr((Exception)e, KeyIndicators.class));
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<?> update(@ApiParam(name="keyIndicators", value="\u5173\u952e\u6307\u6807") @RequestBody KeyIndicatorsDto keyIndicators) {
        try {
            this.keyIndicatorsService.update(keyIndicators);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)DataTooLongGenerateRespUtil.generateRespStr((Exception)e, KeyIndicators.class));
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PostMapping(value={"updatePos"})
    public Result<?> updatePos(@ApiParam(name="keyIndicators", value="\u5173\u952e\u6307\u6807") @RequestBody KeyIndicatorsDto keyIndicators) {
        try {
            this.keyIndicatorsService.update(keyIndicators);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)DataTooLongGenerateRespUtil.generateRespStr((Exception)e, KeyIndicators.class));
        }
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="ids") List<String> ids) {
        try {
            this.keyIndicatorsService.delete(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    @PostMapping(value={"deletePos"})
    public Result<?> deletePos(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="ids") List<String> ids) {
        try {
            this.keyIndicatorsService.delete(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enable"})
    public Result<?> enable(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestBody List<String> ids) {
        try {
            this.keyIndicatorsService.updateEnableStatus(ids, EnableStatusEnum.ENABLE.getCode());
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disable"})
    public Result<?> disable(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestBody List<String> ids) {
        try {
            this.keyIndicatorsService.updateEnableStatus(ids, EnableStatusEnum.DISABLE.getCode());
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

