/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.key.indicators.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.key.indicators.local.entity.KeyIndicators;
import com.biz.crm.tpm.business.key.indicators.local.repository.KeyIndicatorsRepository;
import com.biz.crm.tpm.business.key.indicators.sdk.dto.KeyIndicatorsDto;
import com.biz.crm.tpm.business.key.indicators.sdk.dto.KeyIndicatorsLogEventDto;
import com.biz.crm.tpm.business.key.indicators.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.key.indicators.sdk.event.log.KeyIndicatorsLogEventListener;
import com.biz.crm.tpm.business.key.indicators.sdk.service.KeyIndicatorsService;
import com.biz.crm.tpm.business.key.indicators.sdk.vo.KeyIndicatorsVO;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaCustomVariableRegister;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service(value="keyIndicatorsService")
public class KeyIndicatorsServiceImpl
implements KeyIndicatorsService {
    private static final Logger log = LoggerFactory.getLogger(KeyIndicatorsServiceImpl.class);
    @Autowired
    private KeyIndicatorsRepository keyIndicatorsRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private List<FormulaVariableRegister> formulaVariableRegisterList;
    @Autowired(required=false)
    private List<FormulaCustomVariableRegister> formulaCustomVariableRegisterList;

    public Page<KeyIndicatorsVO> findByConditions(Pageable pageable, KeyIndicatorsDto keyIndicatorsDto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)1, (int)20);
        }
        if (keyIndicatorsDto == null) {
            keyIndicatorsDto = new KeyIndicatorsDto();
        }
        if (StringUtils.isBlank((CharSequence)keyIndicatorsDto.getDelFlag())) {
            keyIndicatorsDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        if (StringUtils.isBlank((CharSequence)keyIndicatorsDto.getTenantCode())) {
            keyIndicatorsDto.setTenantCode(TenantUtils.getTenantCode());
        }
        return this.keyIndicatorsRepository.findByConditions(pageable, keyIndicatorsDto);
    }

    public List<String> findBeanName(String beanName) {
        ArrayList<String> beanList = new ArrayList<String>();
        beanList.add(beanName);
        return beanList;
    }

    public KeyIndicatorsVO findBeanByCondition(String beanCode, String beanTypes) {
        Validate.notBlank((CharSequence)beanCode, (String)"\u5173\u952e\u6307\u6807\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)beanTypes, (String)"\u6307\u6807\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<String> beanTypeList = Arrays.asList(beanTypes.split(","));
        String code = null;
        String name = null;
        Integer sort = null;
        List filterList = this.formulaVariableRegisterList.stream().filter(e -> {
            if (CollectionUtils.isEmpty((Collection)e.getFunctionStringList())) {
                return false;
            }
            for (String beanType : beanTypeList) {
                if (e.getFunctionStringList().contains(beanType)) continue;
                return false;
            }
            return StringUtils.equals((CharSequence)beanCode, (CharSequence)e.getVariableCode());
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filterList)) {
            List filterCustomList = this.formulaCustomVariableRegisterList.stream().filter(e -> {
                if (CollectionUtils.isEmpty((Collection)e.getFunctionStringList())) {
                    return false;
                }
                for (String beanType : beanTypeList) {
                    if (e.getFunctionStringList().contains(beanType)) continue;
                    return false;
                }
                return StringUtils.equals((CharSequence)beanCode, (CharSequence)e.getVariableCode());
            }).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(filterCustomList)) {
                FormulaCustomVariableRegister formulaVariableRegister = (FormulaCustomVariableRegister)filterCustomList.get(0);
                code = formulaVariableRegister.getVariableCode();
                name = formulaVariableRegister.getVariableName();
                sort = formulaVariableRegister.getSort();
            }
        } else {
            FormulaVariableRegister formulaVariableRegister = (FormulaVariableRegister)filterList.get(0);
            code = formulaVariableRegister.getVariableCode();
            name = formulaVariableRegister.getVariableName();
            sort = formulaVariableRegister.getSort();
        }
        Validate.notBlank((CharSequence)code, (String)"\u5173\u952e\u6307\u6807\u7f16\u7801[%s]\u672a\u627e\u5230\u5bf9\u5e94\u6ce8\u518c\u5668\uff01", (Object[])new Object[]{beanCode});
        KeyIndicatorsVO keyIndicatorsVO = new KeyIndicatorsVO();
        keyIndicatorsVO.setKeyIndicatorsCode(code);
        keyIndicatorsVO.setKeyIndicatorsName(name);
        keyIndicatorsVO.setSortIndex(sort);
        return keyIndicatorsVO;
    }

    public KeyIndicatorsVO findBeanPath(String beanName) {
        KeyIndicatorsVO vo = new KeyIndicatorsVO();
        vo.setBeanPath("/" + beanName);
        return vo;
    }

    public KeyIndicatorsVO findById(String id) {
        KeyIndicators keyIndicators;
        if (!StringUtils.isBlank((CharSequence)id) && (keyIndicators = this.keyIndicatorsRepository.findById(id)) != null) {
            return (KeyIndicatorsVO)this.nebulaToolkitService.copyObjectByWhiteList((Object)keyIndicators, KeyIndicatorsVO.class, HashSet.class, ArrayList.class, new String[0]);
        }
        return null;
    }

    public List<KeyIndicatorsVO> findByIds(List<String> idList) {
        List keyIndicatorsList;
        if (idList.size() > 0 && (keyIndicatorsList = this.keyIndicatorsRepository.listByIds(idList)).size() > 0) {
            return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)keyIndicatorsList, KeyIndicators.class, KeyIndicatorsVO.class, HashSet.class, ArrayList.class, new String[0]));
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public KeyIndicatorsDto create(KeyIndicatorsDto keyIndicators) {
        this.createValidate(keyIndicators);
        this.checkType(keyIndicators);
        this.checkConfigurable(keyIndicators);
        List<KeyIndicators> existList = this.keyIndicatorsRepository.findByCode(keyIndicators.getKeyIndicatorsCode(), null, null);
        if (existList.size() == 0) {
            if (StringUtils.isEmpty((CharSequence)keyIndicators.getConfigurable())) {
                keyIndicators.setConfigurable(YesOrNoEnum.NO.getCode());
            }
            keyIndicators.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            keyIndicators.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            keyIndicators.setTenantCode(TenantUtils.getTenantCode());
            KeyIndicators entity = (KeyIndicators)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)keyIndicators, KeyIndicators.class, HashSet.class, ArrayList.class, new String[0]));
            this.keyIndicatorsRepository.save((Object)entity);
            keyIndicators.setId(entity.getId());
            KeyIndicatorsLogEventDto logEventDto = new KeyIndicatorsLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(keyIndicators);
            SerializableBiConsumer & Serializable onCreate = KeyIndicatorsLogEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, KeyIndicatorsLogEventListener.class, (SerializableBiConsumer)onCreate);
        } else {
            for (KeyIndicators keyIndicator : existList) {
                Validate.isTrue((boolean)DelFlagStatusEnum.DELETE.getCode().equals(keyIndicator.getDelFlag()), (String)"\u5173\u952e\u6307\u6807\u5df2\u5b58\u5728\uff01", (Object[])new Object[0]);
                keyIndicators.setId(keyIndicator.getId());
                keyIndicators.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                keyIndicators.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                KeyIndicators newKeyIndicators = (KeyIndicators)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)keyIndicators, KeyIndicators.class, HashSet.class, ArrayList.class, new String[0]));
                this.keyIndicatorsRepository.updateById((Object)newKeyIndicators);
                KeyIndicatorsLogEventDto logEventDto = new KeyIndicatorsLogEventDto();
                KeyIndicatorsDto oldDto = (KeyIndicatorsDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)keyIndicator, KeyIndicatorsDto.class, HashSet.class, ArrayList.class, new String[0]);
                KeyIndicatorsDto newDto = (KeyIndicatorsDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)newKeyIndicators, KeyIndicatorsDto.class, HashSet.class, ArrayList.class, new String[0]);
                logEventDto.setOriginal(oldDto);
                logEventDto.setNewest(newDto);
                SerializableBiConsumer & Serializable onUpdate = KeyIndicatorsLogEventListener::onUpdate;
                this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, KeyIndicatorsLogEventListener.class, (SerializableBiConsumer)onUpdate);
            }
        }
        return keyIndicators;
    }

    @Transactional(rollbackFor={Exception.class})
    public KeyIndicatorsDto update(KeyIndicatorsDto keyIndicators) {
        this.updateValidate(keyIndicators);
        this.checkType(keyIndicators);
        this.checkConfigurable(keyIndicators);
        List<KeyIndicators> existList = this.keyIndicatorsRepository.findByCode(keyIndicators.getKeyIndicatorsCode(), DelFlagStatusEnum.NORMAL.getCode(), null);
        existList = existList.stream().filter(e -> !keyIndicators.getId().equals(e.getId())).collect(Collectors.toList());
        Validate.isTrue((existList.size() == 0 ? 1 : 0) != 0, (String)"\u5173\u952e\u6307\u6807\u5df2\u5b58\u5728\uff01", (Object[])new Object[0]);
        KeyIndicators dbKeyIndicators = (KeyIndicators)((Object)this.keyIndicatorsRepository.getById((Serializable)((Object)keyIndicators.getId())));
        Validate.notNull((Object)((Object)dbKeyIndicators), (String)"\u6839\u636e\u6307\u5b9a\u7684id\u952e\u503c\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((boolean)dbKeyIndicators.getKeyIndicatorsCode().equals(keyIndicators.getKeyIndicatorsCode()), (String)"\u5173\u952e\u6307\u6807\u7f16\u7801\u4e0d\u53ef\u4fee\u6539\uff01", (Object[])new Object[0]);
        KeyIndicators newKeyIndicators = (KeyIndicators)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)keyIndicators, KeyIndicators.class, HashSet.class, ArrayList.class, new String[0]));
        this.keyIndicatorsRepository.updateById((Object)newKeyIndicators);
        KeyIndicatorsLogEventDto logEventDto = new KeyIndicatorsLogEventDto();
        KeyIndicatorsDto oldDto = (KeyIndicatorsDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dbKeyIndicators, KeyIndicatorsDto.class, HashSet.class, ArrayList.class, new String[0]);
        KeyIndicatorsDto newDto = (KeyIndicatorsDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)newKeyIndicators, KeyIndicatorsDto.class, HashSet.class, ArrayList.class, new String[0]);
        logEventDto.setOriginal(oldDto);
        logEventDto.setNewest(newDto);
        SerializableBiConsumer & Serializable onUpdate = KeyIndicatorsLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, KeyIndicatorsLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return keyIndicators;
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<KeyIndicators> keyIndicatorsList = this.keyIndicatorsRepository.findByIds(idList);
        for (KeyIndicators keyIndicators : keyIndicatorsList) {
            keyIndicators.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
        }
        this.keyIndicatorsRepository.updateBatchById(keyIndicatorsList);
        ArrayList kiDtoList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(keyIndicatorsList, KeyIndicators.class, KeyIndicatorsDto.class, HashSet.class, ArrayList.class, new String[0]));
        SerializableBiConsumer & Serializable onDelete = KeyIndicatorsLogEventListener::onDelete;
        kiDtoList.forEach(kiDto -> {
            KeyIndicatorsLogEventDto logEventDto = new KeyIndicatorsLogEventDto();
            logEventDto.setOriginal(kiDto);
            logEventDto.setNewest(null);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, KeyIndicatorsLogEventListener.class, onDelete);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateEnableStatus(List<String> idList, String enableStatus) {
        this.updateEnableStatusValidate(idList, enableStatus);
        List<KeyIndicators> entityList = this.keyIndicatorsRepository.findByIds(idList);
        Assert.notEmpty(entityList, (String)"\u6570\u636e\u4e0d\u5b58\u5728!");
        String desc = EnableStatusEnum.getDesc((String)enableStatus);
        Assert.hasLength((String)desc, (String)"\u542f\u7981\u7528\u72b6\u6001\u4e0d\u5408\u6cd5!");
        entityList.forEach(item -> {
            if (enableStatus.equals(item.getEnableStatus())) {
                throw new IllegalArgumentException("\u6570\u636e\u5df2[" + desc + "],\u4e0d\u53ef\u91cd\u590d[" + desc + "]");
            }
        });
        ArrayList keyIndicatorsList = new ArrayList();
        idList.forEach(id -> {
            KeyIndicators keyIndicators = new KeyIndicators();
            keyIndicators.setId((String)id);
            keyIndicators.setEnableStatus(enableStatus);
            keyIndicatorsList.add(keyIndicators);
        });
        this.keyIndicatorsRepository.updateBatchById(keyIndicatorsList);
        ArrayList kiDtoList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(keyIndicatorsList, KeyIndicators.class, KeyIndicatorsDto.class, HashSet.class, ArrayList.class, new String[0]));
        if (EnableStatusEnum.ENABLE.getCode().equals(enableStatus)) {
            SerializableBiConsumer & Serializable onEnable = KeyIndicatorsLogEventListener::onEnable;
            kiDtoList.forEach(kiDto -> {
                KeyIndicatorsLogEventDto logEventDto = new KeyIndicatorsLogEventDto();
                logEventDto.setOriginal(kiDto);
                logEventDto.setNewest(null);
                this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, KeyIndicatorsLogEventListener.class, onEnable);
            });
        } else {
            SerializableBiConsumer & Serializable onDisable = KeyIndicatorsLogEventListener::onDisable;
            kiDtoList.forEach(kiDto -> {
                KeyIndicatorsLogEventDto logEventDto = new KeyIndicatorsLogEventDto();
                logEventDto.setOriginal(kiDto);
                logEventDto.setNewest(null);
                this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, KeyIndicatorsLogEventListener.class, onDisable);
            });
        }
    }

    private void updateEnableStatusValidate(List<String> idList, String enableStatus) {
        Validate.notEmpty(idList, (String)"\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)enableStatus, (String)"\u542f\u7981\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)EnableStatusEnum.contains((String)enableStatus), (String)"\u672a\u77e5\u7684\u542f\u7981\u7528\u72b6\u6001", (Object[])new Object[0]);
    }

    private void createValidate(KeyIndicatorsDto keyIndicators) {
        Validate.notNull((Object)keyIndicators, (String)"\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)keyIndicators.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)keyIndicators.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)keyIndicators.getKeyIndicatorsCode(), (String)"\u5173\u952e\u6307\u6807\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)keyIndicators.getKeyIndicatorsName(), (String)"\u5173\u952e\u6307\u6807\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)keyIndicators.getIndicatorsType(), (String)"\u6307\u6807\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String[] split = keyIndicators.getIndicatorsType().split(",");
        List<String> strings = Arrays.asList(split);
        strings.forEach(type -> Validate.notNull((Object)VariableFunctionEnum.findByCode((String)type), (String)"\u672a\u77e5\u7684\u6307\u6807\u7c7b\u578b", (Object[])new Object[0]));
    }

    private void updateValidate(KeyIndicatorsDto keyIndicators) {
        Validate.notNull((Object)keyIndicators, (String)"\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)keyIndicators.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)keyIndicators.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)keyIndicators.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)keyIndicators.getKeyIndicatorsName(), (String)"\u5173\u952e\u6307\u6807\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)keyIndicators.getIndicatorsType(), (String)"\u6307\u6807\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String[] split = keyIndicators.getIndicatorsType().split(",");
        List<String> strings = Arrays.asList(split);
        strings.forEach(type -> Validate.notNull((Object)VariableFunctionEnum.findByCode((String)type), (String)"\u672a\u77e5\u7684\u6307\u6807\u7c7b\u578b", (Object[])new Object[0]));
    }

    private void checkType(KeyIndicatorsDto keyIndicators) {
        List filterList = this.formulaVariableRegisterList.stream().filter(e -> StringUtils.equals((CharSequence)e.getVariableCode(), (CharSequence)keyIndicators.getKeyIndicatorsCode())).collect(Collectors.toList());
        Validate.isTrue((filterList.size() > 0 ? 1 : 0) != 0, (String)"\u5173\u952e\u6307\u6807\u7f16\u7801[%s]\u672a\u627e\u5230\u5bf9\u5e94\u6ce8\u518c\u5668\uff01", (Object[])new Object[]{keyIndicators.getKeyIndicatorsCode()});
        List<String> beanTypeList = Arrays.asList(keyIndicators.getIndicatorsType().split(","));
        HashSet nameSet = new HashSet();
        long count = this.formulaVariableRegisterList.stream().filter(e -> {
            if (!StringUtils.equals((CharSequence)keyIndicators.getKeyIndicatorsCode(), (CharSequence)e.getVariableCode())) {
                return false;
            }
            if (CollectionUtils.isEmpty((Collection)e.getFunctionStringList())) {
                return false;
            }
            for (String beanType : beanTypeList) {
                if (e.getFunctionStringList().contains(beanType)) continue;
                VariableFunctionEnum functionEnum = VariableFunctionEnum.findByCode((String)beanType);
                if (Objects.nonNull(functionEnum)) {
                    nameSet.add(functionEnum.getDesc());
                } else {
                    nameSet.add(beanType);
                }
                return false;
            }
            return true;
        }).count();
        Validate.isTrue((count > 0L ? 1 : 0) != 0, (String)"\u5173\u952e\u6307\u6807\u7f16\u7801[%s]\u672a\u9884\u8bbe\u6307\u6807\u7c7b\u578b[%s]\uff01", (Object[])new Object[]{keyIndicators.getKeyIndicatorsCode(), String.join((CharSequence)",", nameSet)});
    }

    private void checkConfigurable(KeyIndicatorsDto keyIndicators) {
        if (StringUtils.isEmpty((CharSequence)keyIndicators.getConfigurable())) {
            keyIndicators.setConfigurable(YesOrNoEnum.NO.getCode());
        }
        List filterList = this.formulaVariableRegisterList.stream().filter(e -> StringUtils.equals((CharSequence)e.getVariableCode(), (CharSequence)keyIndicators.getKeyIndicatorsCode())).collect(Collectors.toList());
        FormulaVariableRegister formulaVariableRegister = (FormulaVariableRegister)filterList.get(0);
        if (YesOrNoEnum.YES.getCode().equals(keyIndicators.getConfigurable())) {
            Validate.isTrue((boolean)formulaVariableRegister.isConfigurable(), (String)"\u5173\u952e\u6307\u6807\u7f16\u7801[%s]\u662f\u81ea\u5b9a\u4e49\u53d8\u91cf\uff01", (Object[])new Object[]{keyIndicators.getKeyIndicatorsCode()});
        } else {
            Validate.isTrue((formulaVariableRegister.isConfigurable() == false ? 1 : 0) != 0, (String)"\u5173\u952e\u6307\u6807\u7f16\u7801[%s]\u975e\u81ea\u5b9a\u4e49\u53d8\u91cf\uff01", (Object[])new Object[]{keyIndicators.getKeyIndicatorsCode()});
        }
    }
}

