package com.biz.crm.tpm.business.large.date.config.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.large.date.config.sdk.service.TpmProductRangeService;
import com.biz.crm.tpm.business.large.date.config.sdk.vo.TpmLargeDateConfigVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 产品范围表(TpmProductRange)相关的接口
 *
 * @author heding
 * @create 2022-12-05 17:01:38
 */
@RestController
@RequestMapping("/v1/tpmProductRange")
@Slf4j
@Api(tags = "TMP-产品范围表")
public class TpmProductRangeController {
    @Autowired
    private TpmProductRangeService tpmProductRangeService;
    /**
     * 通过产品编码查询是否大日期
     *
     * @param productCode 产品编码
     * @return 结果
     */
    @ApiOperation(value = "通过产品编码查询是否大日期")
    @GetMapping("{productCode}")
    public Result<Boolean> findByCode(@PathVariable @ApiParam(name = "productCode", value = "产品编码") String productCode) {
        try {
            Boolean result = tpmProductRangeService.findByCode(productCode);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
