package com.biz.crm.tpm.business.large.date.config.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author heding
 * @create 2022/12/5 14:21:44
 */
@ApiModel(value = "TpmLargeDateConfig", description = "TPM-大日期配置")
@TableName("tpm_large_date_config")
@Getter
@Setter
@Entity(name = "tpm_large_date_config")
@org.hibernate.annotations.Table(appliesTo = "tpm_large_date_config", comment = "TPM-大日期配置")
@Table(name = "tpm_large_date_config", indexes = {@Index(name = "tpm_large_date_config_index1", columnList = "large_date_code"),
        @Index(name = "tpm_large_date_config_index2", columnList = "business_format_code"),
        @Index(name = "tpm_large_date_config_index3", columnList = "large_date_name")})
public class TpmLargeDateConfig extends TenantFlagOpEntity {
    /**
     * 配置编码
     */
    @ApiModelProperty(name = "配置编码", notes = "配置编码")
    @Column(name = "large_date_code", nullable = false, length = 64, columnDefinition = "varchar(64) COMMENT '配置编码'")
    private String largeDateCode;
    /**
     * 配置名称
     */
    @ApiModelProperty(name = "配置名称", notes = "配置名称")
    @Column(name = "large_date_name", nullable = false, length = 64, columnDefinition = "varchar(64) COMMENT '配置名称'")
    private String largeDateName;
    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "业态[数据字典:mdm_business_format]")
    @Column(name = "business_format_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "业务单元[数据字典:mdm_business_unit]")
    @Column(name = "business_unit_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    /**
     * 规则公式
     */
    @ApiModelProperty(name = "规则公式", notes = "规则公式")
    @Column(name = "rule_formula", length = 256, columnDefinition = "VARCHAR(256) COMMENT ' 规则公式 '")
    private String ruleFormula;
    /**
     * 公式名称
     */
    @ApiModelProperty(name = "公式名称", notes = "公式名称")
    @Column(name = "formula_name", length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 公式名称 '")
    private String formulaName;
    /**
     * 产品编码集
     */
    @ApiModelProperty(name = "产品编码集", notes = "产品编码集")
    @Column(name = "code_set", length = 500, columnDefinition = "VARCHAR(500) COMMENT ' 产品编码集 '")
    private String codeSet;
    /**
     * 销售机构编码集
     */
    @ApiModelProperty(name = "销售机构编码集", notes = "销售机构编码集")
    @Column(name = "sales_org_code_set", length = 500, columnDefinition = "VARCHAR(500) COMMENT ' 销售机构编码集 '")
    private String salesOrgCodeSet;
    /**
     * 子表名称（产品/品牌/品类/品项）
     */
    @ApiModelProperty(name = "子表名称（产品/品牌/品类/品项）", notes = "子表名称（产品/品牌/品类/品项）")
    @Column(name = "sublist_name", length = 32, columnDefinition = "varchar(32) COMMENT '子表名称（产品/品牌/品类/品项）'")
    private String sublistName;
}
