package com.biz.crm.tpm.business.large.date.config.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author heding
 * @create 2022/12/5 14:21:44
 */
@ApiModel(value = "TpmProductRange", description = "TPM-产品范围")
@TableName("tpm_product_range")
@Getter
@Setter
@Entity(name = "tpm_product_range")
@org.hibernate.annotations.Table(appliesTo = "tpm_product_range", comment = "TPM-产品范围")
@Table(name = "tpm_product_range", indexes = {@Index(name = "tpm_product_range_index1", columnList = "large_date_code"),
        @Index(name = "tpm_product_range_index2", columnList = "product_code")})
public class TpmProductRange extends TenantFlagOpEntity {
    /**
     * 配置编码
     */
    @ApiModelProperty(name = "配置编码", notes = "配置编码")
    @Column(name = "large_date_code", nullable = false, length = 64, columnDefinition = "varchar(64) COMMENT '配置编码'")
    private String largeDateCode;

    /**
     * 产品编码
     */
    @ApiModelProperty(name = "产品编码", notes = "产品编码")
    @Column(name = "product_code", length = 64, columnDefinition = "varchar(64) COMMENT '产品编码'")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty(name = "产品名称", notes = "产品名称")
    @Column(name = "product_name", length = 64, columnDefinition = "varchar(64) COMMENT '产品名称'")
    private String productName;
    /**
     * 产品品牌编码
     */
    @ApiModelProperty(name = "产品品牌编码", notes = "产品品牌编码")
    @TableField(value = "product_brand_code")
    @Column(name = "product_brand_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 产品品牌编码 '")
    private String productBrandCode;
    /**
     * 产品品牌名称
     */
    @ApiModelProperty(name = "产品品牌名称", notes = "产品品牌名称")
    @Column(name = "product_brand_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 产品品牌名称 '")
    private String productBrandName;
    /**
     * 所属产品品类编码
     */
    @ApiModelProperty("所属产品品类编码")
    @Column(name = "product_category_code", length = 64, columnDefinition = "varchar(64) COMMENT '所属产品品类编码'")
    private String productCategoryCode;
    /**
     * 所属产品品类名称
     */
    @ApiModelProperty(name = "所属产品品类名称", notes = "所属产品品类名称")
    @Column(name = "product_category_name", length = 64, columnDefinition = "varchar(64) COMMENT '所属产品品类名称'")
    private String productCategoryName;
    /**
     * 产品品项编码
     */
    @ApiModelProperty("产品品项编码")
    @Column(name = "product_item_code", length = 64, columnDefinition = "varchar(64) COMMENT '产品品项编码'")
    private String productItemCode;
    /**
     * 产品品项名称
     */
    @ApiModelProperty(name = "产品品项名称", notes = "产品品项名称")
    @Column(name = "product_item_name", length = 64, columnDefinition = "varchar(64) COMMENT '产品品项名称'")
    private String productItemName;
}
