package com.biz.crm.tpm.business.large.date.config.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author heding
 * @create 2022/12/5 14:21:44
 */
@ApiModel(value = "TpmSalesOrg", description = "TPM-大日期配置")
@TableName("tpm_sales_org")
@Getter
@Setter
@Entity(name = "tpm_sales_org")
@org.hibernate.annotations.Table(appliesTo = "tpm_sales_org", comment = "TPM-销售机构")
@Table(name = "tpm_sales_org", indexes = {@Index(name = "tpm_sales_org_index1", columnList = "large_date_code")})
public class TpmSalesOrg extends TenantFlagOpEntity {
    /**
     * 配置编码
     */
    @ApiModelProperty(name = "配置编码", notes = "配置编码")
    @Column(name = "large_date_code", nullable = false, length = 64, columnDefinition = "varchar(64) COMMENT '配置编码'")
    private String largeDateCode;
    /**
     * 销售机构编码
     */
    @ApiModelProperty(name = "销售机构编码", notes = "销售机构编码")
    @TableField(value = "sales_org_code")
    @Column(name = "sales_org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 销售机构编码 '")
    private String salesOrgCode;
    /**
     * 销售机构名称
     */
    @TableField(value = "sales_org_name")
    @ApiModelProperty(name = "销售机构名称", notes = "销售机构名称")
    @Column(name = "sales_org_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT ' 销售机构名称 '")
    private String salesOrgName;
}
