package com.biz.crm.tpm.business.large.date.config.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.large.date.config.local.entity.TpmLargeDateConfig;
import com.biz.crm.tpm.business.large.date.config.sdk.dto.TpmLargeDateConfigDto;
import com.biz.crm.tpm.business.large.date.config.sdk.vo.TpmLargeDateConfigVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;


/**
 * 大日期配置表(TpmLargeDateConfig)mybatis访问层
 *
 * @author heding
 * @create 2022-12-05 18:01:44
 */
public interface TpmLargeDateConfigMapper extends BaseMapper<TpmLargeDateConfig> {

    /**
     * 分页查询数据
     *
     * @param page 分页对象
     * @param dto  查询条件实体
     * @return 所有数据
     */
    Page<TpmLargeDateConfigVo> findByConditions(@Param("page") Page<TpmLargeDateConfigVo> page, @Param("dto") TpmLargeDateConfigDto dto);

    /**
     * 数据库验重 业态+业务单元+（如果业务单元是分子公司，那么维度还有个销售机构）+产品
     *
     * @param dto 实体对象
     * @return 该维度下的所有数据
     */
    List<TpmLargeDateConfigVo> repeatValidate(@Param("dto") TpmLargeDateConfigDto dto);

    /**
     * 条件查询产品规则
     *
     * @param formulaName
     * @param enableCode
     * @return
     */
    List<TpmLargeDateConfigVo> findAllProductConfig(@Param("formulaName") String formulaName,@Param("enableCode") String enableCode);
}
