package com.biz.crm.tpm.business.large.date.config.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author ：heding
 * @create ：Created in 2022/12/06 10:27:56
 * @description：大日期配置表
 */
@Component
@Slf4j
public class TpmLargeDateConfigRegister implements DataviewRegister {
    @Override
    public String code() {
        return "tpm_large_date_config_data_view";
    }

    @Override
    public String desc() {
        return "TPM-大日期配置";
    }

    @Override
    public String buildSql() {
        return "select t.* from tpm_large_date_config t " +
                "where t.tenant_code = :tenantCode " +
                "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "'";
    }
}
