package com.biz.crm.tpm.business.large.date.config.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.large.date.config.local.entity.TpmLargeDateConfig;
import com.biz.crm.tpm.business.large.date.config.local.mapper.TpmLargeDateConfigMapper;
import com.biz.crm.tpm.business.large.date.config.sdk.dto.TpmLargeDateConfigDto;
import com.biz.crm.tpm.business.large.date.config.sdk.vo.TpmLargeDateConfigVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 大日期配置表(TpmLargeDateConfig)数据库访问层
 *
 * @author heding
 * @create 2022-12-06 14:50:12
 */
@Component
public class TpmLargeDateConfigRepository extends ServiceImpl<TpmLargeDateConfigMapper,TpmLargeDateConfig> {
    @Autowired(required = false)
    private TpmLargeDateConfigMapper tpmLargeDateConfigMapper;


    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      查询条件实体
     * @return
     */
    public Page<TpmLargeDateConfigVo> findByConditions(Pageable pageable, TpmLargeDateConfigDto dto) {
        Page<TpmLargeDateConfigVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<TpmLargeDateConfigVo> pageList = tpmLargeDateConfigMapper.findByConditions(page, dto);
        return pageList;
    }
    /**
     * 数据库验重 业态+业务单元+（如果业务单元是分子公司，那么维度还有个销售机构）+产品
     *
     * @param dto 实体对象
     */
    public List<TpmLargeDateConfigVo> repeatValidate(TpmLargeDateConfigDto dto) {
        return tpmLargeDateConfigMapper.repeatValidate(dto);
    }
    /**
     * 按条件跟新数据
     *
     * @param dto  更新条件实体
     * @return
     */
    public void updateByConditions(TpmLargeDateConfigDto dto) {
        this.lambdaUpdate()
                .eq(TenantFlagOpEntity::getTenantCode,dto.getTenantCode())
                .eq(TpmLargeDateConfig::getLargeDateCode,dto.getLargeDateCode())
                .set(TpmLargeDateConfig::getLargeDateName,dto.getLargeDateName())
                .set(TpmLargeDateConfig::getRemark,dto.getRemark())
                .set(TpmLargeDateConfig::getFormulaName,dto.getFormulaName())
                .set(TpmLargeDateConfig::getRuleFormula,dto.getRuleFormula())
                .update();
    }

    public List<TpmLargeDateConfigVo> findAllProductConfig(String formulaName, String enableCode) {
        return tpmLargeDateConfigMapper.findAllProductConfig(formulaName,enableCode);
    }
}
