package com.biz.crm.tpm.business.large.date.config.local.repository;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.large.date.config.local.entity.TpmProductRange;
import com.biz.crm.tpm.business.large.date.config.local.mapper.TpmProductRangeMapper;
import com.biz.crm.tpm.business.large.date.config.sdk.dto.TpmProductRangeDto;
import com.biz.crm.tpm.business.large.date.config.sdk.vo.TpmProductRangeVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;

/**
 * 产品范围表(TpmProductRange)数据库访问层
 *
 * @author heding
 * @create 2022-12-06 14:50:12
 */
@Component
public class TpmProductRangeRepository extends ServiceImpl<TpmProductRangeMapper, TpmProductRange> {
    @Autowired(required = false)
    private TpmProductRangeMapper tpmProductRangeMapper;


    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      查询条件实体
     * @return
     */
    public Page<TpmProductRangeVo> findByConditions(Pageable pageable, TpmProductRangeDto dto) {
        Page<TpmProductRangeVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<TpmProductRangeVo> pageList = tpmProductRangeMapper.findByConditions(page, dto);
        return pageList;
    }
    /**
     * 根据配置编码查询产品
     *
     * @param largeDateCode 配置编码
     * @return 产品信息
     */
    public List<TpmProductRange> findByListLargeDateCode(String largeDateCode) {
        if (StringUtils.isBlank(largeDateCode)) {
            return Collections.emptyList();
        }
        return this.lambdaQuery()
                .eq(TpmProductRange::getTenantCode, TenantUtils.getTenantCode())
                .eq(TpmProductRange::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmProductRange::getLargeDateCode,largeDateCode)
                .list();
    }
    /**
     * 根据配置编码删除
     *
     * @param largeDateCode 配置编码
     * @return
     */
    public void deleteByLargeDateCode(String largeDateCode) {
        if (StringUtils.isBlank(largeDateCode)) {
            return;
        }
        this.lambdaUpdate()
                .eq(TpmProductRange::getTenantCode, TenantUtils.getTenantCode())
                .eq(TpmProductRange::getLargeDateCode,largeDateCode)
                .set(TpmProductRange::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .update();
    }
    /**
     * 通过产品编码查询是否大日期
     *
     * @param productCode 产品编码
     * @return 结果
     */
    public List<TpmProductRange> findByCode(String productCode) {
        if (StringUtils.isBlank(productCode)) {
            return null;
        }
        return this.lambdaQuery()
                .eq(TpmProductRange::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmProductRange::getProductCode,productCode)
                .list();
    }
}
