package com.biz.crm.tpm.business.large.date.config.local.repository;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.large.date.config.local.entity.TpmSalesOrg;
import com.biz.crm.tpm.business.large.date.config.local.mapper.TpmSalesOrgMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;

/**
 * 销售机构表(TpmSalesOrg)数据库访问层
 *
 * @author heding
 * @create 2022-12-06 14:50:12
 */
@Component
public class TpmSalesOrgRepository extends ServiceImpl<TpmSalesOrgMapper, TpmSalesOrg> {
    @Autowired(required = false)
    private TpmSalesOrgMapper tpmSalesOrgMapper;
    /**
     * 根据配置编码查询销售机构
     *
     * @param largeDateCode 配置编码
     * @return 销售机构信息
     */
    public List<TpmSalesOrg> findByListLargeDateCode(String largeDateCode) {
        if (StringUtils.isBlank(largeDateCode)) {
            return Collections.emptyList();
        }
        return this.lambdaQuery()
                .eq(TpmSalesOrg::getTenantCode, TenantUtils.getTenantCode())
                .eq(TpmSalesOrg::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmSalesOrg::getLargeDateCode,largeDateCode)
                .list();
    }
    /**
     * 根据配置编码删除
     *
     * @param largeDateCode 配置编码
     * @return
     */
    public void deleteByLargeDateCode(String largeDateCode) {
        if (StringUtils.isBlank(largeDateCode)) {
            return;
        }
        this.lambdaUpdate()
                .eq(TpmSalesOrg::getTenantCode, TenantUtils.getTenantCode())
                .eq(TpmSalesOrg::getLargeDateCode,largeDateCode)
                .set(TpmSalesOrg::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .update();
    }
}
