package com.biz.crm.tpm.business.large.date.config.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.large.date.config.local.entity.TpmProductRange;
import com.biz.crm.tpm.business.large.date.config.local.repository.TpmProductRangeRepository;
import com.biz.crm.tpm.business.large.date.config.sdk.dto.TpmProductRangeDto;
import com.biz.crm.tpm.business.large.date.config.sdk.service.TpmProductRangeService;
import com.biz.crm.tpm.business.large.date.config.sdk.vo.TpmProductRangeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
/**
 * 产品范围(TpmProductRange)服务实现类
 *
 * @author heding
 * @create 2022-12-07 15:50:12
 */
@Service("tpmProductRangeService")
public class TpmProductRangeServiceImpl implements TpmProductRangeService {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    private TpmProductRangeRepository tpmProductRangeRepository;

    /**
     * 新增数据
     *
     * @param dto 实体对象
     * @return 新增结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void create(TpmProductRangeDto dto) {
        TpmProductRange tpmProductRange = nebulaToolkitService.copyObjectByWhiteList(dto, TpmProductRange.class, LinkedHashSet.class, ArrayList.class);
        tpmProductRangeRepository.save(tpmProductRange);

    }
    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      查询条件实
     * @return 所有数据
     */
    @Override
    public Page<TpmProductRangeVo> findByConditions(Pageable pageable, TpmProductRangeDto dto) {
        ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new TpmProductRangeDto();
        }
        return tpmProductRangeRepository.findByConditions(pageable, dto);
    }
    /**
     * 根据配置编码查询产品
     *
     * @param largeDateCode 配置编码
     * @return 产品信息
     */
    @Override
    public List<TpmProductRangeVo> findByListLargeDateCode(String largeDateCode) {
        List<TpmProductRange> list = tpmProductRangeRepository.findByListLargeDateCode(largeDateCode);
        return (List<TpmProductRangeVo>) nebulaToolkitService.copyCollectionByWhiteList(list, TpmProductRange.class,TpmProductRangeVo.class, LinkedHashSet.class, ArrayList.class);
    }
    /**
     * 根据配置编码删除
     *
     * @param largeDateCode 配置编码
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByLargeDateCode(String largeDateCode) {
        tpmProductRangeRepository.deleteByLargeDateCode(largeDateCode);
    }
    /**
     * 通过产品编码查询是否大日期
     *
     * @param productCode 产品编码
     * @return 结果
     */
    @Override
    public Boolean findByCode(String productCode) {
        Validate.notBlank(productCode,"产品编码不能为空！");
        List<TpmProductRange> tpmProductRanges = tpmProductRangeRepository.findByCode(productCode);
        if (CollectionUtils.isNotEmpty(tpmProductRanges)){
            return true;
        }
        return false;
    }

}
