package com.biz.crm.tpm.business.large.date.config.local.service.internal;

import com.biz.crm.tpm.business.large.date.config.local.entity.TpmSalesOrg;
import com.biz.crm.tpm.business.large.date.config.local.repository.TpmSalesOrgRepository;
import com.biz.crm.tpm.business.large.date.config.sdk.dto.TpmSalesOrgDto;
import com.biz.crm.tpm.business.large.date.config.sdk.service.TpmSalesOrgService;
import com.biz.crm.tpm.business.large.date.config.sdk.vo.TpmSalesOrgVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * 销售机构(TpmSalesOrg)服务实现类
 *
 * @author heding
 * @create 2022-12-07 15:50:12
 */
@Service("tpmSalesOrgService")
public class TpmSalesOrgServiceImpl implements TpmSalesOrgService {
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    private TpmSalesOrgRepository tpmSalesOrgRepository;
    /**
     * 新增数据
     *
     * @param dto 实体对象
     * @return 新增结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void create(TpmSalesOrgDto dto) {
        TpmSalesOrg tpmSalesOrg = nebulaToolkitService.copyObjectByWhiteList(dto, TpmSalesOrg.class, LinkedHashSet.class, ArrayList.class);
        tpmSalesOrgRepository.save(tpmSalesOrg);
    }
    /**
     * 根据配置编码查询销售机构
     *
     * @param largeDateCode 配置编码
     * @return 销售机构信息
     */
    @Override
    public List<TpmSalesOrgVo> findByListLargeDateCode(String largeDateCode) {
        List<TpmSalesOrg> list = tpmSalesOrgRepository.findByListLargeDateCode(largeDateCode);
        return (List<TpmSalesOrgVo>) nebulaToolkitService.copyCollectionByWhiteList(list, TpmSalesOrg.class,TpmSalesOrgVo.class, LinkedHashSet.class, ArrayList.class);
    }
    /**
     * 根据配置编码删除
     *
     * @param largeDateCode 配置编码
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByLargeDateCode(String largeDateCode) {
        tpmSalesOrgRepository.deleteByLargeDateCode(largeDateCode);
    }

}
