/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.large.date.config.local.repository;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.large.date.config.local.entity.TpmProductRange;
import com.biz.crm.tpm.business.large.date.config.local.mapper.TpmProductRangeMapper;
import com.biz.crm.tpm.business.large.date.config.sdk.dto.TpmProductRangeDto;
import com.biz.crm.tpm.business.large.date.config.sdk.vo.TpmProductRangeVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class TpmProductRangeRepository
extends ServiceImpl<TpmProductRangeMapper, TpmProductRange> {
    @Autowired(required=false)
    private TpmProductRangeMapper tpmProductRangeMapper;

    public Page<TpmProductRangeVo> findByConditions(Pageable pageable, TpmProductRangeDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<TpmProductRangeVo> pageList = this.tpmProductRangeMapper.findByConditions((Page<TpmProductRangeVo>)page, dto);
        return pageList;
    }

    public List<TpmProductRange> findByListLargeDateCode(String largeDateCode) {
        if (StringUtils.isBlank((CharSequence)largeDateCode)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TpmProductRange::getLargeDateCode, (Object)largeDateCode)).list();
    }

    public void deleteByLargeDateCode(String largeDateCode) {
        if (StringUtils.isBlank((CharSequence)largeDateCode)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(TpmProductRange::getLargeDateCode, (Object)largeDateCode)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public List<TpmProductRange> findByCode(String productCode) {
        if (StringUtils.isBlank((CharSequence)productCode)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TpmProductRange::getProductCode, (Object)productCode)).list();
    }
}

