/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.large.date.config.local.service.internal;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.large.date.config.local.entity.TpmLargeDateConfig;
import com.biz.crm.tpm.business.large.date.config.local.repository.TpmLargeDateConfigRepository;
import com.biz.crm.tpm.business.large.date.config.sdk.dto.TpmLargeDateConfigDto;
import com.biz.crm.tpm.business.large.date.config.sdk.dto.TpmProductRangeDto;
import com.biz.crm.tpm.business.large.date.config.sdk.dto.TpmSalesOrgDto;
import com.biz.crm.tpm.business.large.date.config.sdk.dto.log.TpmLargeDateConfigLogEventDto;
import com.biz.crm.tpm.business.large.date.config.sdk.event.log.TpmLargeDateConfigEventListener;
import com.biz.crm.tpm.business.large.date.config.sdk.service.TpmLargeDateConfigService;
import com.biz.crm.tpm.business.large.date.config.sdk.service.TpmProductRangeService;
import com.biz.crm.tpm.business.large.date.config.sdk.service.TpmSalesOrgService;
import com.biz.crm.tpm.business.large.date.config.sdk.vo.TpmLargeDateConfigVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tpmLargeDateConfigService")
public class TpmLargeDateConfigServiceImpl
implements TpmLargeDateConfigService {
    @Autowired(required=false)
    private TpmLargeDateConfigRepository tpmLargeDateConfigRepository;
    @Autowired(required=false)
    private TpmProductRangeService tpmProductRangeService;
    @Autowired(required=false)
    private TpmSalesOrgService tpmSalesOrgService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;

    public TpmLargeDateConfigVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        TpmLargeDateConfig tpmLargeDateConfig = (TpmLargeDateConfig)((Object)this.tpmLargeDateConfigRepository.getById((Serializable)((Object)id)));
        if (ObjectUtils.isEmpty((Object)((Object)tpmLargeDateConfig))) {
            return null;
        }
        TpmLargeDateConfigVo tpmLargeDateConfigVo = (TpmLargeDateConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)tpmLargeDateConfig, TpmLargeDateConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List productRangeVoList = this.tpmProductRangeService.findByListLargeDateCode(tpmLargeDateConfigVo.getLargeDateCode());
        List tpmSalesOrgVoList = this.tpmSalesOrgService.findByListLargeDateCode(tpmLargeDateConfigVo.getLargeDateCode());
        tpmLargeDateConfigVo.setProductRangeVoList(productRangeVoList);
        tpmLargeDateConfigVo.setSalesOrgVoList(tpmSalesOrgVoList);
        return tpmLargeDateConfigVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List businessPolicyList1 = this.tpmLargeDateConfigRepository.listByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)businessPolicyList1) ? 1 : 0) != 0, (String)"\u8981\u5220\u9664\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList tpmLargeDateConfigList = new ArrayList();
        businessPolicyList1.forEach(item -> {
            TpmLargeDateConfig tpmLargeDateConfig = new TpmLargeDateConfig();
            tpmLargeDateConfig.setId(item.getId());
            tpmLargeDateConfig.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            tpmLargeDateConfigList.add(tpmLargeDateConfig);
            String largeDateCode = item.getLargeDateCode();
            if ("DY00000009,DY000000029b32b88e9cbcd172885134c371fca513,\u5206\u5b50\u516c\u53f8".contains(item.getBusinessUnitCode())) {
                this.tpmSalesOrgService.deleteByLargeDateCode(largeDateCode);
            }
            this.tpmProductRangeService.deleteByLargeDateCode(largeDateCode);
            TpmLargeDateConfigLogEventDto logEventDto = new TpmLargeDateConfigLogEventDto();
            TpmLargeDateConfigVo oldVo = (TpmLargeDateConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, TpmLargeDateConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            logEventDto.setOriginal(oldVo);
            TpmLargeDateConfigDto tpmLargeDateConfigDto = (TpmLargeDateConfigDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, TpmLargeDateConfigDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            tpmLargeDateConfigDto.setDelFlag(tpmLargeDateConfig.getDelFlag());
            logEventDto.setNewest(tpmLargeDateConfigDto);
            SerializableBiConsumer & Serializable onDelete = TpmLargeDateConfigEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, TpmLargeDateConfigEventListener.class, (SerializableBiConsumer)onDelete);
        });
        this.tpmLargeDateConfigRepository.updateBatchById(tpmLargeDateConfigList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(TpmLargeDateConfigDto dto) {
        this.createValidate(dto);
        List productRangeDtoList = dto.getProductRangeDtoList();
        List salesOrgDtoList = dto.getSalesOrgDtoList();
        boolean salesOrgResult = CollectionUtils.isNotEmpty((Collection)salesOrgDtoList);
        boolean result = CollectionUtils.isNotEmpty((Collection)productRangeDtoList);
        String tenantCode = TenantUtils.getTenantCode();
        String oldCode = this.repeatValidate(productRangeDtoList, salesOrgDtoList, salesOrgResult, dto);
        if (result && StringUtils.isNotBlank((CharSequence)oldCode)) {
            dto.setTenantCode(tenantCode);
            dto.setLargeDateCode(oldCode);
            this.tpmLargeDateConfigRepository.updateByConditions(dto);
            return;
        }
        String delCode = DelFlagStatusEnum.NORMAL.getCode();
        String enableCode = EnableStatusEnum.ENABLE.getCode();
        dto.setDelFlag(delCode);
        dto.setTenantCode(tenantCode);
        dto.setEnableStatus(enableCode);
        String code = (String)this.generateCodeService.generateCode("LDC", 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
        dto.setLargeDateCode(code);
        if (result) {
            String codeSet = this.saveProductData(code, productRangeDtoList, tenantCode, delCode, enableCode);
            dto.setCodeSet(codeSet);
        }
        if (salesOrgResult) {
            String salesOrgCodeSet = this.saveSalesData(code, salesOrgDtoList, tenantCode, delCode, enableCode);
            dto.setSalesOrgCodeSet(salesOrgCodeSet);
        }
        TpmLargeDateConfig tpmLargeDateConfig = (TpmLargeDateConfig)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmLargeDateConfig.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        TpmLargeDateConfigLogEventDto logEventDto = new TpmLargeDateConfigLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onCreate = TpmLargeDateConfigEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, TpmLargeDateConfigEventListener.class, (SerializableBiConsumer)onCreate);
        this.tpmLargeDateConfigRepository.save((Object)tpmLargeDateConfig);
    }

    private String saveSalesData(String code, List<TpmSalesOrgDto> salesOrgDtoList, String tenantCode, String delCode, String enableCode) {
        String salesOrgCodeSet = "";
        for (TpmSalesOrgDto tpmSalesOrgDto : salesOrgDtoList) {
            salesOrgCodeSet = StringUtils.join((Object[])new String[]{salesOrgCodeSet, " ", tpmSalesOrgDto.getSalesOrgCode()});
            tpmSalesOrgDto.setLargeDateCode(code);
            tpmSalesOrgDto.setDelFlag(delCode);
            tpmSalesOrgDto.setEnableStatus(enableCode);
            tpmSalesOrgDto.setTenantCode(tenantCode);
            tpmSalesOrgDto.setId(null);
            this.tpmSalesOrgService.create(tpmSalesOrgDto);
        }
        return salesOrgCodeSet;
    }

    private String saveProductData(String code, List<TpmProductRangeDto> productRangeDtoList, String tenantCode, String delCode, String enableCode) {
        String codeSet = "";
        for (TpmProductRangeDto tpmProductRangeDto : productRangeDtoList) {
            Validate.notBlank((CharSequence)tpmProductRangeDto.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            codeSet = StringUtils.join((Object[])new String[]{codeSet, " ", tpmProductRangeDto.getProductCode()});
            tpmProductRangeDto.setLargeDateCode(code);
            tpmProductRangeDto.setDelFlag(delCode);
            tpmProductRangeDto.setEnableStatus(enableCode);
            tpmProductRangeDto.setTenantCode(tenantCode);
            tpmProductRangeDto.setId(null);
            this.tpmProductRangeService.create(tpmProductRangeDto);
        }
        return codeSet;
    }

    public Page<TpmLargeDateConfigVo> findByConditions(Pageable pageable, TpmLargeDateConfigDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new TpmLargeDateConfigDto();
        }
        return this.tpmLargeDateConfigRepository.findByConditions(pageable, dto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(TpmLargeDateConfigDto dto) {
        this.updateValidate(dto);
        TpmLargeDateConfigVo oldVo = this.findById(dto.getId());
        String tenantCode = dto.getTenantCode();
        String delCode = DelFlagStatusEnum.NORMAL.getCode();
        String enableCode = EnableStatusEnum.ENABLE.getCode();
        String code = dto.getLargeDateCode();
        List productRangeDtoList = dto.getProductRangeDtoList();
        List salesOrgDtoList = dto.getSalesOrgDtoList();
        boolean salesOrgResult = CollectionUtils.isNotEmpty((Collection)salesOrgDtoList);
        boolean result = CollectionUtils.isNotEmpty((Collection)productRangeDtoList);
        if (result) {
            this.tpmProductRangeService.deleteByLargeDateCode(code);
            String codeSet = this.saveProductData(code, productRangeDtoList, tenantCode, delCode, enableCode);
            dto.setCodeSet(codeSet);
        }
        if (salesOrgResult) {
            this.tpmSalesOrgService.deleteByLargeDateCode(code);
            String salesOrgCodeSet = this.saveSalesData(code, salesOrgDtoList, tenantCode, delCode, enableCode);
            dto.setSalesOrgCodeSet(salesOrgCodeSet);
        }
        TpmLargeDateConfig tpmLargeDateConfig = (TpmLargeDateConfig)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmLargeDateConfig.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.tpmLargeDateConfigRepository.saveOrUpdate((Object)tpmLargeDateConfig);
        TpmLargeDateConfigLogEventDto logEventDto = new TpmLargeDateConfigLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onUpdate = TpmLargeDateConfigEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, TpmLargeDateConfigEventListener.class, (SerializableBiConsumer)onUpdate);
    }

    @Transactional(rollbackFor={Exception.class})
    public void enable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List tpmLargeDateConfigList = this.tpmLargeDateConfigRepository.listByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)tpmLargeDateConfigList) ? 1 : 0) != 0, (String)"\u542f\u7528\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList activityContractConfigList = new ArrayList();
        tpmLargeDateConfigList.forEach(item -> {
            TpmLargeDateConfig tpmLargeDateConfig = new TpmLargeDateConfig();
            tpmLargeDateConfig.setId(item.getId());
            tpmLargeDateConfig.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            activityContractConfigList.add(tpmLargeDateConfig);
            TpmLargeDateConfigLogEventDto logEventDto = new TpmLargeDateConfigLogEventDto();
            TpmLargeDateConfigVo oldVo = (TpmLargeDateConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, TpmLargeDateConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            logEventDto.setOriginal(oldVo);
            TpmLargeDateConfigDto tpmLargeDateConfigDto = (TpmLargeDateConfigDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, TpmLargeDateConfigDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            tpmLargeDateConfigDto.setEnableStatus(tpmLargeDateConfig.getEnableStatus());
            logEventDto.setNewest(tpmLargeDateConfigDto);
            SerializableBiConsumer & Serializable onEnable = TpmLargeDateConfigEventListener::onEnable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, TpmLargeDateConfigEventListener.class, (SerializableBiConsumer)onEnable);
        });
        this.tpmLargeDateConfigRepository.updateBatchById(activityContractConfigList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void disable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List tpmLargeDateConfigList = this.tpmLargeDateConfigRepository.listByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)tpmLargeDateConfigList) ? 1 : 0) != 0, (String)"\u7981\u7528\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList activityContractConfigList = new ArrayList();
        tpmLargeDateConfigList.forEach(item -> {
            TpmLargeDateConfig tpmLargeDateConfig = new TpmLargeDateConfig();
            tpmLargeDateConfig.setId(item.getId());
            tpmLargeDateConfig.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            activityContractConfigList.add(tpmLargeDateConfig);
            TpmLargeDateConfigLogEventDto logEventDto = new TpmLargeDateConfigLogEventDto();
            TpmLargeDateConfigVo oldVo = (TpmLargeDateConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, TpmLargeDateConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            logEventDto.setOriginal(oldVo);
            TpmLargeDateConfigDto tpmLargeDateConfigDto = (TpmLargeDateConfigDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, TpmLargeDateConfigDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            tpmLargeDateConfigDto.setEnableStatus(tpmLargeDateConfig.getEnableStatus());
            logEventDto.setNewest(tpmLargeDateConfigDto);
            SerializableBiConsumer & Serializable onDisable = TpmLargeDateConfigEventListener::onDisable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, TpmLargeDateConfigEventListener.class, (SerializableBiConsumer)onDisable);
        });
        this.tpmLargeDateConfigRepository.updateBatchById(activityContractConfigList);
    }

    public Map<String, List<TpmLargeDateConfigVo>> findAllProductConfig() {
        List<TpmLargeDateConfigVo> list = this.tpmLargeDateConfigRepository.findAllProductConfig("\u4fdd\u8d28\u671f\u5269\u4f59\u5929\u6570", EnableStatusEnum.ENABLE.getCode());
        if (CollectionUtils.isNotEmpty(list)) {
            ArrayList largeDateConfigVos = new ArrayList();
            String lessThan = "<";
            list.forEach(l -> {
                String formulaName = l.getFormulaName();
                if (StringUtils.isNotBlank((CharSequence)formulaName) && formulaName.contains(lessThan)) {
                    largeDateConfigVos.add(l);
                }
            });
            if (CollectionUtils.isNotEmpty(largeDateConfigVos) && largeDateConfigVos.size() > 0) {
                return largeDateConfigVos.stream().collect(Collectors.groupingBy(l -> l.getBusinessFormatCode() + l.getBusinessUnitCode()));
            }
        }
        return null;
    }

    private void createValidate(TpmLargeDateConfigDto dto) {
        Validate.notNull((Object)dto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.setId(null);
        Validate.notBlank((CharSequence)dto.getLargeDateName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u914d\u7f6e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if ("DY00000009,DY000000029b32b88e9cbcd172885134c371fca513,\u5206\u5b50\u516c\u53f8".contains(dto.getBusinessUnitCode())) {
            Validate.notNull((Object)dto.getSalesOrgDtoList(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9500\u552e\u673a\u6784\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
    }

    private void updateValidate(TpmLargeDateConfigDto dto) {
        Validate.notNull((Object)dto, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTenantCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getLargeDateCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u914d\u7f6e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getLargeDateName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u914d\u7f6e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if ("DY00000009,DY000000029b32b88e9cbcd172885134c371fca513,\u5206\u5b50\u516c\u53f8".contains(dto.getBusinessUnitCode())) {
            Validate.notNull((Object)dto.getSalesOrgDtoList(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u9500\u552e\u673a\u6784\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
    }

    private String repeatValidate(List<TpmProductRangeDto> productRangeDtoList, List<TpmSalesOrgDto> salesOrgDtoList, boolean salesOrgResult, TpmLargeDateConfigDto dto) {
        List<TpmLargeDateConfigVo> tpmLargeDateConfigVos = this.tpmLargeDateConfigRepository.repeatValidate(dto);
        if (CollectionUtils.isNotEmpty(tpmLargeDateConfigVos)) {
            String codeSet = "";
            for (TpmProductRangeDto tpmProductRangeDto : productRangeDtoList) {
                codeSet = StringUtils.join((Object[])new String[]{codeSet, " ", tpmProductRangeDto.getProductCode()});
            }
            for (TpmLargeDateConfigVo tpmLargeDateConfigVo : tpmLargeDateConfigVos) {
                if (!tpmLargeDateConfigVo.getCodeSet().equals(codeSet)) continue;
                String largeDateCode = tpmLargeDateConfigVo.getLargeDateCode();
                if (salesOrgResult) {
                    String salesOrgCodeSet = "";
                    for (TpmSalesOrgDto tpmSalesOrgDto : salesOrgDtoList) {
                        salesOrgCodeSet = StringUtils.join((Object[])new String[]{salesOrgCodeSet, " ", tpmSalesOrgDto.getSalesOrgCode()});
                    }
                    String sales = tpmLargeDateConfigVo.getSalesOrgCodeSet();
                    return salesOrgCodeSet.equals(sales) ? largeDateCode : null;
                }
                return largeDateCode;
            }
        }
        return null;
    }
}

