/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.large.date.config.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.large.date.config.local.entity.TpmProductRange;
import com.biz.crm.tpm.business.large.date.config.local.repository.TpmProductRangeRepository;
import com.biz.crm.tpm.business.large.date.config.sdk.dto.TpmProductRangeDto;
import com.biz.crm.tpm.business.large.date.config.sdk.service.TpmProductRangeService;
import com.biz.crm.tpm.business.large.date.config.sdk.vo.TpmProductRangeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tpmProductRangeService")
public class TpmProductRangeServiceImpl
implements TpmProductRangeService {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private TpmProductRangeRepository tpmProductRangeRepository;

    @Transactional(rollbackFor={Exception.class})
    public void create(TpmProductRangeDto dto) {
        TpmProductRange tpmProductRange = (TpmProductRange)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmProductRange.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.tpmProductRangeRepository.save((Object)tpmProductRange);
    }

    public Page<TpmProductRangeVo> findByConditions(Pageable pageable, TpmProductRangeDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new TpmProductRangeDto();
        }
        return this.tpmProductRangeRepository.findByConditions(pageable, dto);
    }

    public List<TpmProductRangeVo> findByListLargeDateCode(String largeDateCode) {
        List<TpmProductRange> list = this.tpmProductRangeRepository.findByListLargeDateCode(largeDateCode);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, TpmProductRange.class, TpmProductRangeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByLargeDateCode(String largeDateCode) {
        this.tpmProductRangeRepository.deleteByLargeDateCode(largeDateCode);
    }

    public Boolean findByCode(String productCode) {
        Validate.notBlank((CharSequence)productCode, (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<TpmProductRange> tpmProductRanges = this.tpmProductRangeRepository.findByCode(productCode);
        if (CollectionUtils.isNotEmpty(tpmProductRanges)) {
            return true;
        }
        return false;
    }
}

