package com.biz.crm.tpm.business.large.date.config.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.util.List;

/**
 * @author heding
 * @create 2022/12/06 17:21:44
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "大日期配置dto")
public class TpmLargeDateConfigDto extends TenantFlagOpDto {
    /**
     * 配置编码
     */
    @ApiModelProperty(name = "配置编码",notes = "配置编码")
    private String largeDateCode;
    /**
     * 配置名称
     */
    @ApiModelProperty(name = "配置名称",notes = "配置名称")
    private String largeDateName;
    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "业务单元[数据字典:mdm_business_unit]")
    private String businessUnitCode;
    /**
     * 销售机构
     */
    @ApiModelProperty(name = "销售机构",notes = "销售机构")
    private List<TpmSalesOrgDto> salesOrgDtoList;
    /**
     * 规则公式
     */
    @ApiModelProperty(name = "规则公式",notes = "规则公式")
    private String ruleFormula;
    /**
     * 公式名称
     */
    @ApiModelProperty(name = "公式名称",notes = "公式名称")
    private String formulaName;
    /**
     * 产品范围
     */
    @ApiModelProperty(name = "产品范围",notes = "产品范围")
    private List<TpmProductRangeDto> productRangeDtoList;
    /**
     * 产品编码集
     */
    @ApiModelProperty(name = "产品编码集",notes = "产品编码集")
    private String codeSet;
    /**
     * 销售机构编码集
     */
    @ApiModelProperty(name = "销售机构编码集",notes = "销售机构编码集")
    private String salesOrgCodeSet;
    /**
     * 子表名称（产品/品牌/品类/品项）
     */
    @ApiModelProperty(name = "子表名称（产品/品牌/品类/品项）", notes = "子表名称（产品/品牌/品类/品项）")
    private String sublistName;

}