package com.biz.crm.tpm.business.large.date.config.sdk.dto;


import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * @author heding
 * @create 2022/12/06 17:21:44
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "产品范围dto")
public class TpmProductRangeDto extends TenantFlagOpDto {
    /**
     * 配置编码
     */
    @ApiModelProperty(name = "配置编码",notes = "配置编码")
    private String largeDateCode;
    /**
     * 产品编码
     */
    @ApiModelProperty(name = "产品编码", notes = "产品编码")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty(name = "产品名称", notes = "产品名称")
    private String productName;
    /**
     * 产品品牌编码
     */
    @ApiModelProperty(name = "产品品牌编码", notes = "产品品牌编码")
    private String productBrandCode;
    /**
     * 产品品牌名称
     */
    @ApiModelProperty(name = "产品品牌名称", notes = "产品品牌名称")
    private String productBrandName;
    /**
     * 所属产品品类编码
     */
    @ApiModelProperty("所属产品品类编码")
    private String productCategoryCode;
    /**
     * 所属产品品类名称
     */
    @ApiModelProperty(name = "所属产品品类名称", notes = "所属产品品类名称")
    private String productCategoryName;
    /**
     * 产品品项编码
     */
    @ApiModelProperty("产品品项编码")
    private String productItemCode;
    /**
     * 产品品项名称
     */
    @ApiModelProperty(name = "产品品项名称", notes = "产品品项名称")
    private String productItemName;

}
