package com.biz.crm.tpm.business.large.date.config.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.large.date.config.sdk.dto.TpmLargeDateConfigDto;
import com.biz.crm.tpm.business.large.date.config.sdk.vo.TpmLargeDateConfigVo;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Map;

/**
 * 大日期配置(TpmLargeDateConfig)表服务接口
 *
 * @author heding
 * @create 2022/12/05 17:29:44
 */
public interface TpmLargeDateConfigService {
    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    TpmLargeDateConfigVo findById(String id);

    /**
     * 删除数据
     *
     * @param idList 主键集合
     * @return 删除结果
     */
    void delete(List<String> idList);

    /**
     * 新增数据
     *
     * @param dto 实体对象
     * @return 新增结果
     */
    void create(TpmLargeDateConfigDto dto);

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      查询条件实体
     * @return 所有数据
     */
    Page<TpmLargeDateConfigVo> findByConditions(Pageable pageable, TpmLargeDateConfigDto dto);

    /**
     * 编辑数据
     *
     * @param dto 实体对象
     * @return 编辑结果
     */
    void update(TpmLargeDateConfigDto dto);

    /**
     * 启用
     *
     * @param idList 主键集合
     * @return 启用结果
     */
    void enable(List<String> idList);

    /**
     * 禁用
     *
     * @param idList 主键集合
     * @return 禁用结果
     */
    void disable(List<String> idList);

    /**
     * 查询产品大日期配置信息
     *
     * @return
     */
    Map<String, List<TpmLargeDateConfigVo>> findAllProductConfig();
}
