package com.biz.crm.tpm.business.large.date.config.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.large.date.config.sdk.dto.TpmProductRangeDto;
import com.biz.crm.tpm.business.large.date.config.sdk.vo.TpmProductRangeVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 产品范围(TpmProductRange)表服务接口
 *
 * @author heding
 * @create 2022/12/05 17:29:44
 */
public interface TpmProductRangeService {
    /**
     * 新增数据
     *
     * @param dto 实体对象
     * @return 新增结果
     */
    void create(TpmProductRangeDto dto);

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      查询条件实体
     * @return 所有数据
     */
    Page<TpmProductRangeVo> findByConditions(Pageable pageable, TpmProductRangeDto dto);


    /**
     * 根据配置编码查询产品
     *
     * @param largeDateCode 配置编码
     * @return 产品信息
     */
    List<TpmProductRangeVo> findByListLargeDateCode(String largeDateCode);
    /**
     * 根据配置编码删除
     *
     * @param largeDateCode 配置编码
     * @return
     */
    void deleteByLargeDateCode(String largeDateCode);
    /**
     * 通过产品编码查询是否大日期
     *
     * @param productCode 产品编码
     * @return 结果
     */
    Boolean findByCode(String productCode);
}
