package com.biz.crm.tpm.business.large.date.config.sdk.service;

import com.biz.crm.tpm.business.large.date.config.sdk.dto.TpmSalesOrgDto;
import com.biz.crm.tpm.business.large.date.config.sdk.vo.TpmSalesOrgVo;

import java.util.List;

/**
 * 销售机构(TpmSalesOrg)表服务接口
 *
 * @author heding
 * @create 2022/12/05 17:29:44
 */
public interface TpmSalesOrgService {
    /**
     * 新增数据
     *
     * @param dto 实体对象
     * @return 新增结果
     */
    void create(TpmSalesOrgDto dto);
    /**
     * 根据配置编码查询销售机构
     *
     * @param largeDateCode 配置编码
     * @return 销售机构信息
     */
    List<TpmSalesOrgVo> findByListLargeDateCode(String largeDateCode);
    /**
     * 根据配置编码删除
     *
     * @param largeDateCode 配置编码
     * @return
     */
    void deleteByLargeDateCode(String largeDateCode);
}
