package com.biz.crm.tpm.business.marketing.strategy.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.marketing.strategy.feign.feign.internal.MarketingStrategyFeignImpl;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyOutDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyVo;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @ClassName MarketingStrategyFeign
 * @Description
 * @Author: jiangyin
 * @Date 2023/5/16
 */
@FeignClient(
        name = "${tpm.feign-client.name:crm-tpm}",
        path = "crm-tpm",
        fallbackFactory = MarketingStrategyFeignImpl.class)
public interface MarketingStrategyFeign {

    @PostMapping("/v1/marketingStrategy/saveSingleMarketingStrategyNoCache")
    Result<MarketingStrategyOutDto> create(MarketingStrategyOutDto dto);

    @PostMapping("/v1/marketingStrategy/saveSingleMarketingStrategyNoCachePos")
    Result<MarketingStrategyOutDto> update(MarketingStrategyOutDto dto);

    @GetMapping("/v1/marketingStrategy/findById")
    Result<MarketingStrategyVo> findById(@RequestParam("id") String id);

    @PostMapping("/v1/marketingStrategy/deleteForPost")
    Result<?> delete(@RequestBody List<String> ids);
}
