package com.biz.crm.tpm.business.marketing.strategy.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.marketing.strategy.feign.feign.MarketingStrategyFeign;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyOutDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @ClassName MarketingStrategyFeignImpl
 * @Description
 * @Author: jiangyin
 * @Date 2023/5/16
 */
@Component
@Slf4j
public class MarketingStrategyFeignImpl implements FallbackFactory<MarketingStrategyFeign> {
    @Override
    public MarketingStrategyFeign create(Throwable cause) {
        log.error("营销策略进入熔断");
        return new MarketingStrategyFeign(){

            @Override
            public Result<MarketingStrategyOutDto> create(MarketingStrategyOutDto dto) {
                throw new UnsupportedOperationException("新增营销策略进入熔断");
            }

            @Override
            public Result<MarketingStrategyOutDto> update(MarketingStrategyOutDto dto) {
                throw new UnsupportedOperationException("更改营销策略进入熔断");
            }

            @Override
            public Result<MarketingStrategyVo> findById(String id) {
                throw new UnsupportedOperationException("查询营销策略详情进入熔断");
            }

            @Override
            public Result<?> delete(List<String> ids) {
                throw new UnsupportedOperationException("关闭营销策略进入熔断");
            }
        };
    }
}
