package com.biz.crm.tpm.business.marketing.strategy.feign.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.marketing.strategy.feign.feign.MarketingStrategyFeign;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyOutDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.service.MarketingStrategySdkService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @ClassName MarketingStrategySdkServiceImpl
 * @Description
 * @Author: jiangyin
 * @Date 2023/5/16
 */
@Service
public class MarketingStrategySdkServiceImpl implements MarketingStrategySdkService {

    @Autowired(required = false)
    private MarketingStrategyFeign marketingStrategyFeign;

    @Override
    public Page<MarketingStrategyVo> findByConditions(Pageable pageable, MarketingStrategyDto dto) {
        return null;
    }

    @Override
    public MarketingStrategyOutDto create(MarketingStrategyOutDto dto) {
        Result<MarketingStrategyOutDto> result = marketingStrategyFeign.create(dto);
        if (!result.isSuccess()) {
            throw new UnsupportedOperationException("新增营销策略失败：" + result.getMessage());
        }
        return result.getResult();
    }

    @Override
    public MarketingStrategyOutDto update(MarketingStrategyOutDto dto) {
        Result<MarketingStrategyOutDto> result = marketingStrategyFeign.update(dto);
        if (!result.isSuccess()) {
            throw new UnsupportedOperationException("更改营销策略失败：" + result.getMessage());
        }
        return result.getResult();
    }

    @Override
    public MarketingStrategyVo findById(String id) {
        Result<MarketingStrategyVo> result = marketingStrategyFeign.findById(id);
        if (!result.isSuccess()) {
            throw new UnsupportedOperationException("查询营销策略详情失败：" + result.getMessage());
        }
        return result.getResult();
    }

    @Override
    public void delete(List<String> ids) {
        Result<?> result = marketingStrategyFeign.delete(ids);
        if (!result.isSuccess()) {
            throw new UnsupportedOperationException("关闭营销策略失败：" + result.getMessage());
        }
    }
}
