/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.marketing.strategy.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.util.DataTooLongGenerateRespUtil;
import com.biz.crm.tpm.business.marketing.strategy.local.dto.MarketingStrategyApproveDto;
import com.biz.crm.tpm.business.marketing.strategy.local.dto.MarketingStrategyApproveSubmitDto;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategy;
import com.biz.crm.tpm.business.marketing.strategy.local.service.MarketingStrategyBudgetService;
import com.biz.crm.tpm.business.marketing.strategy.local.service.MarketingStrategyService;
import com.biz.crm.tpm.business.marketing.strategy.local.vo.MarketingStrategyApproveInfoVo;
import com.biz.crm.tpm.business.marketing.strategy.local.vo.MarketingStrategyApproveProcessInfoVo;
import com.biz.crm.tpm.business.marketing.strategy.local.vo.MarketingStrategyBudgetSumVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyOutDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.service.MarketingStrategyLockSdkService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyItemVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDto;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/marketingStrategy"})
@Api(tags={"\u8425\u9500\u7b56\u7565"})
public class MarketingStrategyController {
    private static final Logger log = LoggerFactory.getLogger(MarketingStrategyController.class);
    @Autowired(required=false)
    private MarketingStrategyService marketingStrategyService;
    @Autowired(required=false)
    private MarketingStrategyBudgetService marketingStrategyBudgetService;
    @Autowired(required=false)
    private MarketingStrategyLockSdkService marketingStrategyLockSdkService;

    @ApiOperation(value="\u7b56\u7565\u65b0\u589e\u4fdd\u5b58")
    @PostMapping(value={"saveSingleMarketingStrategyNoCache"})
    public Result<MarketingStrategyOutDto> saveSingleMarketingStrategyNoCache(@ApiParam(name="MarketingStrategyDto", value="\u5355\u7b56\u7565\u8868\u5934") @RequestBody MarketingStrategyOutDto dto) {
        try {
            dto.setId(null);
            return Result.ok((Object)this.marketingStrategyService.saveSingleMarketingStrategyNoCache(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)DataTooLongGenerateRespUtil.generateRespStr((Exception)e, MarketingStrategy.class));
        }
    }

    @ApiOperation(value="\u7b56\u7565\u65b0\u589e\u4fdd\u5b58-\u80fd\u529b\u4e2d\u5fc3")
    @PatchMapping(value={"saveSingleMarketingStrategyNoCache"})
    public Result<MarketingStrategyOutDto> updateSingleMarketingStrategyNoCache(@ApiParam(name="MarketingStrategyDto", value="\u5355\u7b56\u7565\u8868\u5934") @RequestBody MarketingStrategyOutDto dto) {
        try {
            return Result.ok((Object)this.marketingStrategyService.saveSingleMarketingStrategyNoCache(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)DataTooLongGenerateRespUtil.generateRespStr((Exception)e, MarketingStrategy.class));
        }
    }

    @ApiOperation(value="\u7b56\u7565\u65b0\u589e\u4fdd\u5b58-\u80fd\u529b\u4e2d\u5fc3")
    @PostMapping(value={"saveSingleMarketingStrategyNoCachePos"})
    public Result<MarketingStrategyOutDto> updateSingleMarketingStrategyNoCachePos(@ApiParam(name="MarketingStrategyDto", value="\u5355\u7b56\u7565\u8868\u5934") @RequestBody MarketingStrategyOutDto dto) {
        try {
            return Result.ok((Object)this.marketingStrategyService.saveSingleMarketingStrategyNoCache(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)DataTooLongGenerateRespUtil.generateRespStr((Exception)e, MarketingStrategy.class));
        }
    }

    @ApiOperation(value="\u7b56\u7565\u65b0\u589e\u4fdd\u5b58")
    @PostMapping(value={"saveSingleMarketingStrategy"})
    public Result saveSingleMarketingStrategy(@ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="MarketingStrategyDto", value="\u5355\u7b56\u7565\u8868\u5934") @RequestBody MarketingStrategyDto dto) {
        try {
            dto.setId(null);
            this.marketingStrategyService.saveSingleMarketingStrategy(dto, cacheKey);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7b56\u7565\u7f16\u8f91")
    @PatchMapping(value={"saveSingleMarketingStrategy"})
    public Result updateSingleMarketingStrategy(@ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="MarketingStrategyDto", value="\u5355\u7b56\u7565\u8868\u5934") @RequestBody MarketingStrategyDto dto) {
        try {
            if (StringUtils.isEmpty((CharSequence)dto.getId())) {
                throw new RuntimeException("\u7f16\u8f91\u7b56\u7565\u53c2\u6570\u6709\u8bef");
            }
            this.marketingStrategyService.saveSingleMarketingStrategy(dto, cacheKey);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7id\u83b7\u53d6\u8425\u9500\u7b56\u7565\u6570\u636e")
    @GetMapping(value={"findById"})
    public Result<MarketingStrategyVo> findById(@ApiParam(value="id") @RequestParam String id) {
        try {
            MarketingStrategyVo vo = this.marketingStrategyService.findById(id);
            return Result.ok((Object)vo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u7b56\u7565")
    @DeleteMapping(value={"delete"})
    public Result<?> deleteMarketingStrategy(@ApiParam(value="\u7b56\u7565id\u96c6\u5408") @RequestParam List<String> ids) {
        try {
            this.marketingStrategyService.deleteMarketingStrategy(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u7b56\u7565-\u80fd\u529b\u4e2d\u5fc3")
    @PostMapping(value={"deleteForPost"})
    public Result<?> deleteForPost(@RequestBody List<String> ids) {
        try {
            this.marketingStrategyService.deleteMarketingStrategy(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u63d0\u4ea4\u7b56\u7565\u4fe1\u606f")
    @PostMapping(value={"findApproveInfoList"})
    public Result<List<MarketingStrategyApproveInfoVo>> findApproveInfoList(@ApiParam(value="\u63d0\u4ea4\u6d41\u7a0b\uff0c\u6309\u4e1a\u6001\uff0c\u4e1a\u52a1\u5355\u5143\u3001\u5f52\u5c5e\u90e8\u95e8\u3001\u7b56\u7565\u7c7b\u578b\u3001\u7b56\u7565\u5e74\u5ea6\u63d0\u4ea4") @RequestBody MarketingStrategyApproveDto dto) {
        try {
            List<MarketingStrategyApproveInfoVo> list = this.marketingStrategyService.findApproveInfoList(dto);
            return Result.ok(list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u7f16\u53f7\u83b7\u53d6\u5df2\u7ecf\u63d0\u4ea4\u7684\u7b56\u7565\u4fe1\u606f")
    @PostMapping(value={"findApproveProcessInfo"})
    public Result<MarketingStrategyApproveProcessInfoVo> findApproveProcessInfo(@ApiParam(value="\u6d41\u7a0b\u7f16\u53f7") @RequestParam String processNo) {
        try {
            MarketingStrategyApproveProcessInfoVo processInfoVo = this.marketingStrategyService.findApproveProcessInfo(processNo);
            return Result.ok((Object)processInfoVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u7f16\u53f7\u83b7\u53d6\u5df2\u7ecf\u63d0\u4ea4\u7684\u7b56\u7565\u4fe1\u606f-\u6c47\u603b\u7248")
    @GetMapping(value={"findApproveProcessSumInfo"})
    public Result<List<MarketingStrategyBudgetSumVo>> findApproveProcessSumInfo(@ApiParam(value="\u6d41\u7a0b\u7f16\u53f7") @RequestParam String processNo) {
        try {
            List<MarketingStrategyBudgetSumVo> processInfoVo = this.marketingStrategyService.findApproveProcessSumInfo(processNo);
            return Result.ok(processInfoVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u7f16\u53f7\u83b7\u53d6\u5df2\u7ecf\u63d0\u4ea4\u7684\u7b56\u7565\u4fe1\u606f")
    @PostMapping(value={"findApproveProcessInfoByBody"})
    public Result<MarketingStrategyApproveProcessInfoVo> findApproveProcessInfoByBody(@ApiParam(value="\u6d41\u7a0b\u7f16\u53f7") @RequestBody MarketingStrategyDto dto) {
        try {
            MarketingStrategyApproveProcessInfoVo processInfoVo = this.marketingStrategyService.findApproveProcessInfo(dto.getProcessNo());
            return Result.ok((Object)processInfoVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u7f16\u53f7\u83b7\u53d6\u5df2\u7ecf\u63d0\u4ea4\u7684\u7b56\u7565\u660e\u7ec6\u4fe1\u606f")
    @GetMapping(value={"findApproveProcessItemPage"})
    public Result<Page<MarketingStrategyItemVo>> findApproveInfoItemList(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(value="\u63d0\u4ea4\u6d41\u7a0b\uff0c\u6309\u4e1a\u6001\uff0c\u4e1a\u52a1\u5355\u5143\u3001\u5f52\u5c5e\u90e8\u95e8\u3001\u7b56\u7565\u7c7b\u578b\u3001\u7b56\u7565\u5e74\u5ea6\u63d0\u4ea4") @RequestBody MarketingStrategyApproveDto dto) {
        try {
            Page<MarketingStrategyItemVo> list = this.marketingStrategyService.findApproveProcessItemPage(pageable, dto);
            return Result.ok(list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u7f16\u53f7\u83b7\u53d6\u5df2\u7ecf\u63d0\u4ea4\u7684\u7b56\u7565\u660e\u7ec6\u4fe1\u606f")
    @GetMapping(value={"findApprovedProcessItemPage"})
    public Result<Page<MarketingStrategyItemVo>> findApprovedProcessItemPage(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(value="\u6d41\u7a0b\u5bf9\u8c61") MarketingStrategyDto dto) {
        try {
            Page<MarketingStrategyItemVo> page = this.marketingStrategyService.findApproveProcessItemPage(pageable, dto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u63d0\u4ea4\u6d41\u7a0b\uff0c\u6309\u4e1a\u6001\uff0c\u4e1a\u52a1\u5355\u5143\u3001\u5f52\u5c5e\u90e8\u95e8\u3001\u7b56\u7565\u7c7b\u578b\u3001\u7b56\u7565\u5e74\u5ea6\u63d0\u4ea4")
    @PostMapping(value={"submitApproval"})
    public Result submitApproval(@ApiParam(value="\u63d0\u4ea4\u6d41\u7a0b\uff0c\u6309\u4e1a\u6001\uff0c\u4e1a\u52a1\u5355\u5143\u3001\u5f52\u5c5e\u90e8\u95e8\u3001\u7b56\u7565\u7c7b\u578b\u3001\u7b56\u7565\u5e74\u5ea6\u63d0\u4ea4") @RequestBody MarketingStrategyApproveSubmitDto dto) {
        List<String> codeList = null;
        try {
            codeList = this.marketingStrategyService.findToApprovalCodeList(dto);
            Assert.notEmpty(codeList, (String)"\u6ca1\u6709\u5f85\u63d0\u4ea4\u7684\u6570\u636e\uff01");
            this.marketingStrategyService.submitApproval(codeList, dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u53ef\u4ee5\u9009\u62e9\u7684\u6708\u5ea6\u9884\u7b97")
    @GetMapping(value={"findMonthBudgetByConditions"})
    public Result<Page<MonthBudgetVo>> findMonthBudgetByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="MonthBudgetDto", value="\u6708\u5ea6\u9884\u7b97\u4fe1\u606f") MonthBudgetDto dto) {
        try {
            Page<MonthBudgetVo> page = this.marketingStrategyService.findMonthBudgetByConditions(pageable, dto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u53ef\u4ee5\u9009\u62e9\u7684\u6708\u5ea6\u9884\u7b97")
    @GetMapping(value={"findYearBudgetByConditions"})
    public Result<Page<YearBudgetVo>> findYearBudgetByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="YearBudgetDto", value="\u5e74\u5ea6\u9884\u7b97\u4fe1\u606f") YearBudgetDto dto) {
        try {
            Page<YearBudgetVo> page = this.marketingStrategyService.findYearBudgetByConditions(pageable, dto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u8425\u9500\u7b56\u7565\u5360\u7528\u6708\u5ea6\u9884\u7b97\u91d1\u989d")
    @PostMapping(value={"useMonthBudgetByStrategyCodeList"})
    public Result useMonthBudgetByStrategyCodeList(@RequestBody List<String> strategyCodeList) {
        boolean lockSuccess = false;
        try {
            Assert.notEmpty(strategyCodeList, (String)"\u8bf7\u9009\u62e9\u6570\u636e!");
            lockSuccess = this.marketingStrategyLockSdkService.lock(strategyCodeList, TimeUnit.MINUTES, 3);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            this.marketingStrategyBudgetService.useMonthBudgetByCodeList(strategyCodeList);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.marketingStrategyLockSdkService.unlock(strategyCodeList);
            }
        }
    }
}

