/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.marketing.strategy.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.mn.common.page.cache.controller.MnPageCacheController;
import com.biz.crm.tpm.business.activities.template.config.sdk.dto.ActivitiesTemplateConfigSearchDto;
import com.biz.crm.tpm.business.activities.template.config.sdk.enums.ActivitiesTemplateConfigTypeEnum;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormSelectDto;
import com.biz.crm.tpm.business.activity.type.sdk.dto.ActivityTypeSelectDto;
import com.biz.crm.tpm.business.marketing.strategy.local.service.MarketingStrategyItemService;
import com.biz.crm.tpm.business.marketing.strategy.local.vo.MarketingStrategyBudgetSumVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.pojo.MarketingStrategyItemScope;
import com.biz.crm.tpm.business.marketing.strategy.sdk.service.MarketingStrategyLockSdkService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyItemVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/marketingStrategyItem"})
@Api(tags={"\u8425\u9500\u7b56\u7565\u660e\u7ec6"})
public class MarketingStrategyItemController
extends MnPageCacheController<MarketingStrategyItemVo, MarketingStrategyItemDto> {
    private static final Logger log = LoggerFactory.getLogger(MarketingStrategyItemController.class);
    @Autowired(required=false)
    private MarketingStrategyItemService marketingStrategyItemService;
    @Autowired(required=false)
    private ActivitiesTemplateSdkService activitiesTemplateSdkService;
    @Autowired
    private MarketingStrategyLockSdkService marketingStrategyLockSdkService;

    @ApiOperation(value="\u67e5\u8be2\u7b56\u7565\u660e\u7ec6")
    @GetMapping(value={"findByConditions"})
    public Result<Page<MarketingStrategyItemVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="MarketingStrategyItemDto", value="\u67e5\u8be2\u5b9e\u4f53") MarketingStrategyItemDto dto) {
        try {
            Page<MarketingStrategyItemVo> page = this.marketingStrategyItemService.findByConditions(pageable, dto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u591a\u7b56\u7565\u65b0\u589e\u6a21\u677f")
    @GetMapping(value={"getMutiStrategyColumnConfig"})
    public Result<ActivitiesTemplateConfigVo> getMutiStrategyColumnConfig(@ApiParam(name="dto", value="\u67e5\u8be2\u5b9e\u4f53") ActivitiesTemplateConfigSearchDto dto) {
        String configCode = dto.getConfigCode();
        if (StringUtils.isEmpty((CharSequence)configCode)) {
            this.initColumnConfigSearchParam(dto);
            dto.setStrategyFormType("2");
            Page result = this.activitiesTemplateSdkService.findByConditions(null, dto);
            List records = result.getRecords();
            if (!CollectionUtils.isEmpty((Collection)records)) {
                configCode = ((ActivitiesTemplateConfigVo)records.get(0)).getConfigCode();
            }
        }
        if (StringUtils.isEmpty((CharSequence)configCode)) {
            throw new RuntimeException("\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u6a21\u677f\uff01");
        }
        return this.getActivitiesTemplateConfigVoResult(configCode);
    }

    @ApiOperation(value="\u83b7\u53d6\u5355\u7b56\u7565\u65b0\u589e\u660e\u7ec6\u6a21\u677f")
    @GetMapping(value={"getSingleStrategyColumnConfig"})
    public Result<ActivitiesTemplateConfigVo> getSingleStrategyColumnConfig(@ApiParam(name="dto", value="\u67e5\u8be2\u5b9e\u4f53") ActivitiesTemplateConfigSearchDto dto) {
        String configCode = dto.getConfigCode();
        if (StringUtils.isEmpty((CharSequence)configCode)) {
            this.initColumnConfigSearchParam(dto);
            dto.setStrategyFormType("1");
            Page result = this.activitiesTemplateSdkService.findByConditions(null, dto);
            List records = result.getRecords();
            if (!CollectionUtils.isEmpty((Collection)records)) {
                configCode = ((ActivitiesTemplateConfigVo)records.get(0)).getConfigCode();
            }
        }
        if (StringUtils.isEmpty((CharSequence)configCode)) {
            throw new RuntimeException("\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u6a21\u677f\uff01");
        }
        return this.getActivitiesTemplateConfigVoResult(configCode);
    }

    private void initColumnConfigSearchParam(ActivitiesTemplateConfigSearchDto dto) {
        dto.setType(ActivitiesTemplateConfigTypeEnum.STRATEGY.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getStrategyTypeCode(), (String)"\u7b56\u7565\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (BusinessUnitEnum.isDefaultBusinessUnit((String)dto.getBusinessUnitCode())) {
            dto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
        }
    }

    private Result<ActivitiesTemplateConfigVo> getActivitiesTemplateConfigVoResult(String configCode) {
        try {
            ActivitiesTemplateConfigVo configVo = this.activitiesTemplateSdkService.findByCode(configCode);
            return Result.ok((Object)configVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d3b\u52a8\u7c7b\u578b\u4e0b\u62c9")
    @PostMapping(value={"findActivityTypeSelectList"})
    public Result<List<CommonSelectVo>> findActivityTypeSelectList(@ApiParam(value="\u6d3b\u52a8\u7c7b\u578bdto") @RequestBody ActivityTypeSelectDto dto) {
        try {
            List<CommonSelectVo> list = this.marketingStrategyItemService.findActivityTypeSelectList(dto);
            return Result.ok(list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d3b\u52a8\u5f62\u5f0f\u4e0b\u62c9")
    @PostMapping(value={"findActivityFormSelectList"})
    public Result<List<CommonSelectVo>> findActivityFormSelectList(@ApiParam(value="\u6d3b\u52a8\u5f62\u5f0fdto") @RequestBody ActivityFormSelectDto dto) {
        try {
            List<CommonSelectVo> list = this.marketingStrategyItemService.findActivityFormSelectList(dto);
            return Result.ok(list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u9884\u7b97\u6c47\u603b\u4fe1\u606f")
    @PostMapping(value={"findMarketingStrategyBudgetCacheSumList"})
    public Result<List<MarketingStrategyBudgetSumVo>> findMarketingStrategyBudgetCacheSumList(@ApiParam(name="businessUnitCode", value="\u4e1a\u52a1\u5355\u5143") @RequestParam String businessUnitCode, @ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey) {
        try {
            List<MarketingStrategyBudgetSumVo> list = this.marketingStrategyItemService.findMarketingStrategyBudgetCacheSumList(businessUnitCode, cacheKey);
            return Result.ok(list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5206\u644a\u5230\u8303\u56f4\u4e0a\u7684\u4fe1\u606f")
    @PostMapping(value={"findShareScopeList"})
    public Result<List<MarketingStrategyItemScope>> findShareScopeList(@ApiParam(name="dto", value="\u67e5\u8be2\u5b9e\u4f53") @RequestBody MarketingStrategyItemDto dto) {
        try {
            List<MarketingStrategyItemScope> list = this.marketingStrategyItemService.findShareScopeList(dto);
            return Result.ok(list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u8425\u9500\u7b56\u7565\u660e\u7ec6\u5173\u95ed")
    @PostMapping(value={"closeMarketingStrategyItem"})
    public Result<?> closeMarketingStrategyItem(@ApiParam(name="ids", value="\u5173\u95ed\u8425\u9500\u7b56\u7565\u660e\u7ec6") @RequestBody List<String> ids) {
        boolean lockSuccess = false;
        try {
            lockSuccess = this.marketingStrategyLockSdkService.lock(ids, TimeUnit.HOURS, 1);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            this.marketingStrategyItemService.closeMarketingStrategyItem(ids);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.marketingStrategyLockSdkService.unlock(ids);
            }
        }
    }
}

