/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.marketing.strategy.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.marketing.strategy.local.service.MarketingStrategyItemService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketStrategyContentExportVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class MarketStrategyContentExportProcess
implements ExportProcess<MarketStrategyContentExportVo> {
    @Autowired(required=false)
    private MarketingStrategyItemService itemService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private MarketingStrategyItemService marketingStrategyItemService;
    @Autowired(required=false)
    private CustomerRetailerVoService customerRetailerVoService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Integer getTotal(Map<String, Object> params) {
        Validate.notNull((Object)params.get("cacheKey"), (String)"\u7f13\u5b58\u952e\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        Integer total = this.itemService.getTotal((String)params.get("cacheKey"));
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return total;
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        Validate.notNull((Object)params.get("cacheKey"), (String)"\u7f13\u5b58\u952e\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        String cacheKey = (String)params.get("cacheKey");
        PageRequest pageable = PageRequest.of((int)(vo.getPageNo() + 1), (int)this.getPageSize());
        MarketingStrategyItemDto itemDto = new MarketingStrategyItemDto();
        Page cachePage = this.marketingStrategyItemService.findCachePageList((Pageable)pageable, itemDto, cacheKey);
        if (cachePage.getSize() == 0L) {
            return new JSONArray();
        }
        Collection exportsVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)cachePage.getRecords(), MarketingStrategyItemVo.class, MarketStrategyContentExportVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.adjustData(exportsVos);
        return JSON.parseArray((String)JSON.toJSONString((Object)exportsVos));
    }

    public Class<MarketStrategyContentExportVo> findCrmExcelVoClass() {
        return MarketStrategyContentExportVo.class;
    }

    public String getBusinessCode() {
        return "TPM_MARKET_STRATEGY_CONTENT_EXPORT";
    }

    public String getBusinessName() {
        return "\u8425\u9500\u7b56\u7565\u5185\u5bb9\u5bfc\u51fa";
    }

    private void adjustData(Collection<MarketStrategyContentExportVo> data) {
        Map sysMap = this.customerRetailerVoService.getAllRetailerCode();
        Map feeMap = this.dictToolkitService.findMapByDictTypeCode("tpm_fee_belong_us");
        for (MarketStrategyContentExportVo vo : data) {
            if (StringUtils.isNotBlank((CharSequence)vo.getSystemCode())) {
                vo.setSystemCode(sysMap.getOrDefault(vo.getSystemCode(), vo.getSystemCode()));
            }
            if (!StringUtils.isNotBlank((CharSequence)vo.getFeeBelongCode())) continue;
            vo.setFeeBelongCode(feeMap.getOrDefault(vo.getFeeBelongCode(), vo.getFeeBelongCode()));
        }
    }
}

