/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.marketing.strategy.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.marketing.strategy.local.service.MarketingStrategyItemService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketStrategyItemExportVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class MarketStrategyItemExportProcess
implements ExportProcess<MarketStrategyItemExportVo> {
    @Autowired(required=false)
    private MarketingStrategyItemService itemService;
    @Autowired(required=false)
    private CustomerRetailerVoService customerRetailerVoService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Integer getTotal(Map<String, Object> params) {
        MarketingStrategyItemDto marketingStrategyItemDto = this.convertParams(params);
        marketingStrategyItemDto.setTenantCode(TenantUtils.getTenantCode());
        Integer total = this.itemService.itemExportGetTotal(marketingStrategyItemDto);
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return total;
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        MarketingStrategyItemDto marketingStrategyItemDto = this.convertParams(params);
        marketingStrategyItemDto.setTenantCode(TenantUtils.getTenantCode());
        PageRequest pageable = PageRequest.of((int)(vo.getPageNo() + 1), (int)this.getPageSize());
        Page<MarketStrategyItemExportVo> page = this.itemService.itemExportGetDate((Pageable)pageable, marketingStrategyItemDto);
        if (page.getSize() == 0L || CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return new JSONArray();
        }
        List records = page.getRecords();
        this.adjustData(records);
        return JSON.parseArray((String)JSON.toJSONString((Object)records));
    }

    private void adjustData(List<MarketStrategyItemExportVo> dataList) {
        Map sysMap = this.customerRetailerVoService.getAllRetailerCode();
        Map feeMap = this.dictToolkitService.findMapByDictTypeCode("tpm_fee_belong_us");
        Map typeMap = this.dictToolkitService.findMapByDictTypeCode("tpm_marketing_strategy_type");
        for (MarketStrategyItemExportVo vo : dataList) {
            if (StringUtils.isNotBlank((CharSequence)vo.getSystemCode())) {
                vo.setSystemCode(sysMap.getOrDefault(vo.getSystemCode(), vo.getSystemCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getFeeBelongCode())) {
                vo.setFeeBelongCode(feeMap.getOrDefault(vo.getFeeBelongCode(), vo.getFeeBelongCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getStrategyType())) {
                vo.setStrategyType(typeMap.getOrDefault(vo.getStrategyType(), vo.getStrategyType()));
            }
            if (!StringUtils.isNotBlank((CharSequence)vo.getProcessStatus())) continue;
            String processStatus = ProcessStatusEnum.getStatusNameByKey((String)vo.getProcessStatus());
            vo.setProcessStatus(processStatus);
        }
    }

    public String getBusinessCode() {
        return "TPM_MARKET_STRATEGY_ITEM_EXPORT";
    }

    public String getBusinessName() {
        return "\u8425\u9500\u7b56\u7565\u660e\u7ec6\u5bfc\u51fa";
    }

    private MarketingStrategyItemDto convertParams(Map<String, Object> params) {
        Map<String, Object> map = params.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), Map.Entry::getValue));
        MarketingStrategyItemDto dto = (MarketingStrategyItemDto)JSON.parseObject((String)JSON.toJSONString(map), MarketingStrategyItemDto.class);
        return dto;
    }
}

