/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.marketing.strategy.local.imports;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.sales.org.sdk.dto.SalesOrgRangeDto;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.terminal.channel.sdk.service.MdmTerminalChannelVoService;
import com.biz.crm.mdm.business.terminal.channel.sdk.vo.MdmTerminalChannelVo;
import com.biz.crm.mn.common.base.util.DateStringDealUtil;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.marketing.strategy.local.imports.vo.MarketingStrategyItemDY00000008ImportVo;
import com.biz.crm.tpm.business.marketing.strategy.local.service.MarketingStrategyService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.MonthBudgetGroupEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MarketingStrategyDY00000008ImportsProcess
implements ImportProcess<MarketingStrategyItemDY00000008ImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MarketingStrategyDY00000008ImportsProcess.class);
    @Autowired
    private MarketingStrategyService marketingStrategyService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private ActivityTypeService activityTypeService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private MdmTerminalChannelVoService terminalChannelVoService;
    @Autowired(required=false)
    private ProductBrandService productBrandService;
    private static final String yesOrNo = "yesOrNo";

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, MarketingStrategyItemDY00000008ImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap errorMap = Maps.newHashMap();
        HashMap errorListMap = Maps.newHashMap();
        try {
            ArrayList importVos = Lists.newArrayList(data.values());
            ArrayList dictCodeList = Lists.newArrayList();
            dictCodeList.add("mdm_business_format");
            dictCodeList.add("mdm_business_unit");
            dictCodeList.add("tpm_marketing_strategy_type");
            dictCodeList.add(yesOrNo);
            Map dictMap = this.dictDataVoService.findByDictTypeCodeList((List)dictCodeList);
            Map<String, Map<String, String>> dictMapMap = dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> ((List)item.getValue()).stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode, (o, n) -> n)), (o, n) -> n));
            List businessFormatList = (List)dictMap.get("mdm_business_format");
            Map<String, String> businessFormatMap = businessFormatList.stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode, (o, n) -> n));
            List businessUnitList = (List)dictMap.get("mdm_business_unit");
            Map<String, String> businessUnitMap = businessUnitList.stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode, (o, n) -> n));
            List strategyTypeList = (List)dictMap.get("tpm_marketing_strategy_type");
            Map<String, String> strategyTypeMap = strategyTypeList.stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode, (o, n) -> n));
            HashSet orgCodeSet = Sets.newHashSet();
            HashSet activityTypeCodeSet = Sets.newHashSet();
            HashSet activityFormCodeSet = Sets.newHashSet();
            HashSet monthBudgetCodeSet = Sets.newHashSet();
            HashSet terminalChannelSet = Sets.newHashSet();
            HashSet productBrandCodeSet = Sets.newHashSet();
            HashSet salesOrgCodeSet = Sets.newHashSet();
            HashSet salesInstitutionCodeSet = Sets.newHashSet();
            int key = 0;
            for (MarketingStrategyItemDY00000008ImportVo importVo : importVos) {
                String businessFormatCode;
                List errorList = errorListMap.computeIfAbsent(key, k -> Lists.newArrayList());
                if (StringUtils.isEmpty((CharSequence)importVo.getBusinessFormatCode())) {
                    errorList.add("\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((CharSequence)(businessFormatCode = businessFormatMap.get(importVo.getBusinessFormatCode()))) && StringUtils.isEmpty((CharSequence)importVo.getBusinessFormatCode())) {
                    errorList.add("\u4e1a\u6001[" + importVo.getBusinessFormatCode() + "]\u6709\u8bef");
                }
                if (StringUtils.isEmpty((CharSequence)importVo.getBusinessUnitCode())) {
                    errorList.add("\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((CharSequence)importVo.getStrategyType())) {
                    errorList.add("\u7b56\u7565\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((CharSequence)importVo.getStrategyOrgCode())) {
                    errorList.add("\u533a\u57df\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((CharSequence)importVo.getSalesInstitutionCode())) {
                    errorList.add("\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((CharSequence)importVo.getChannelCode())) {
                    errorList.add("\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getAttrOrgCode())) {
                    orgCodeSet.add(importVo.getAttrOrgCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getStrategyOrgCode())) {
                    salesOrgCodeSet.add(importVo.getStrategyOrgCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getChannelCode()) && StringUtils.isNotEmpty((CharSequence)businessFormatCode) && StringUtils.isNotEmpty((CharSequence)importVo.getSalesInstitutionCode())) {
                    salesInstitutionCodeSet.add(importVo.getChannelCode() + businessFormatCode + importVo.getSalesInstitutionCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getActivityTypeCode())) {
                    activityTypeCodeSet.addAll(Arrays.asList(importVo.getActivityTypeCode().split(",")));
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getActivityFormCode())) {
                    activityFormCodeSet.addAll(Arrays.asList(importVo.getActivityFormCode().split(",")));
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getMonthBudgetCode())) {
                    monthBudgetCodeSet.add(importVo.getMonthBudgetCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getFirstChannelCode())) {
                    terminalChannelSet.addAll(Arrays.asList(importVo.getFirstChannelCode().split(",")));
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getSecondChannelCode())) {
                    terminalChannelSet.addAll(Arrays.asList(importVo.getSecondChannelCode().split(",")));
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getProductBrandCode())) {
                    productBrandCodeSet.add(importVo.getProductBrandCode());
                }
                ++key;
            }
            Map<Object, Object> orgMap = Maps.newHashMap();
            Map salesOrgMap = Maps.newHashMap();
            Map<Object, Object> activityTypeMap = Maps.newHashMap();
            Map activityFormMap = Maps.newHashMap();
            Map<Object, Object> monthBudgetMap = Maps.newHashMap();
            Map<Object, Object> terminalChannelMap = Maps.newHashMap();
            Map<Object, Object> productBrandMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty((Collection)orgCodeSet)) {
                List orgList = this.orgVoService.findByOrgCodes((List)Lists.newArrayList((Iterable)orgCodeSet));
                orgMap = orgList.stream().collect(Collectors.toMap(OrgVo::getOrgCode, OrgVo::getOrgName));
            }
            if (!CollectionUtils.isEmpty((Collection)salesOrgCodeSet)) {
                SalesOrgRangeDto rangeDto = new SalesOrgRangeDto();
                rangeDto.setErpCodes(new ArrayList(salesOrgCodeSet));
                rangeDto.setSalesInstitutionCodes(new ArrayList(salesInstitutionCodeSet));
                salesOrgMap = this.salesOrgVoService.findMapBySalesOrgErpCodesAndInsCodes(rangeDto);
            }
            if (!CollectionUtils.isEmpty((Collection)activityTypeCodeSet)) {
                List activityTypeList = this.activityTypeService.findByCodes((List)Lists.newArrayList((Iterable)activityTypeCodeSet));
                activityTypeMap = activityTypeList.stream().collect(Collectors.toMap(ActivityTypeVo::getActivityTypeCode, ActivityTypeVo::getActivityTypeName));
            }
            if (!CollectionUtils.isEmpty((Collection)activityFormCodeSet)) {
                ArrayList activityFormCodeList = Lists.newArrayList((Iterable)activityFormCodeSet);
                Iterator activityFormCodeListBag = Lists.newArrayList();
                activityFormCodeListBag.add(activityFormCodeList);
                activityFormMap = this.activityFormService.findFormByCodes((List)((Object)activityFormCodeListBag));
            }
            if (!CollectionUtils.isEmpty((Collection)monthBudgetCodeSet)) {
                List monthBudgetVos = this.monthBudgetService.listByCodes((List)Lists.newArrayList((Iterable)monthBudgetCodeSet));
                monthBudgetMap = monthBudgetVos.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity()));
            }
            if (!CollectionUtils.isEmpty((Collection)terminalChannelSet)) {
                List mdmTerminalChannelVos = this.terminalChannelVoService.listByCodes((List)Lists.newArrayList((Iterable)terminalChannelSet));
                terminalChannelMap = mdmTerminalChannelVos.stream().collect(Collectors.toMap(MdmTerminalChannelVo::getTerminalChannelCode, MdmTerminalChannelVo::getTerminalChannelName));
            }
            if (!CollectionUtils.isEmpty((Collection)productBrandCodeSet)) {
                List productBrandVos = this.productBrandService.listByCodes((List)Lists.newArrayList((Iterable)productBrandCodeSet));
                productBrandMap = productBrandVos.stream().collect(Collectors.toMap(ProductBrandVo::getProductBrandCode, ProductBrandVo::getProductBrandName));
            }
            ArrayList dtos = Lists.newArrayList();
            key = 0;
            for (MarketingStrategyItemDY00000008ImportVo importVo : importVos) {
                MarketingStrategyItemDto item2;
                List errorList;
                block71: {
                    String terminalChannelName;
                    LinkedList<String> allNames;
                    String[] codes;
                    block70: {
                        block69: {
                            block68: {
                                errorList = errorListMap.computeIfAbsent(key, k -> Lists.newArrayList());
                                item2 = (MarketingStrategyItemDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)importVo, MarketingStrategyItemDto.class, HashSet.class, ArrayList.class, new String[0]);
                                String businessFormatCode = businessFormatMap.get(importVo.getBusinessFormatCode());
                                if (StringUtils.isEmpty((CharSequence)businessFormatCode)) {
                                    errorList.add("\u4e1a\u6001[" + importVo.getBusinessFormatCode() + "]\u6709\u8bef");
                                } else {
                                    item2.setBusinessFormatCode(businessFormatCode);
                                }
                                String businessUnitCode = businessUnitMap.get(importVo.getBusinessUnitCode());
                                if (StringUtils.isEmpty((CharSequence)businessUnitCode)) {
                                    errorList.add("\u4e1a\u52a1\u5355\u5143[" + importVo.getBusinessUnitCode() + "]\u6709\u8bef");
                                } else {
                                    item2.setBusinessUnitCode(businessUnitCode);
                                }
                                String strategyType = strategyTypeMap.get(importVo.getStrategyType());
                                if (StringUtils.isEmpty((CharSequence)strategyType)) {
                                    errorList.add("\u7b56\u7565\u7c7b\u578b[" + importVo.getStrategyType() + "]\u6709\u8bef");
                                } else {
                                    item2.setStrategyType(strategyType);
                                }
                                this.validateAndConvertDictData(dictMapMap, yesOrNo, importVo.getIsCrossMonth(), arg_0 -> ((MarketingStrategyItemDto)item2).setIsCrossMonth(arg_0), "\u662f\u5426\u8de8\u6708\u7b56\u7565", errorList);
                                this.validateDateStrAndSet(importVo.getBeginDateStr(), "\u65b0\u589e\u65f6\uff0c\u7b56\u7565\u660e\u7ec6\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", true, "yyyy-MM-dd", arg_0 -> ((MarketingStrategyItemDto)item2).setBeginDate(arg_0), errorList);
                                this.validateDateStrAndSet(importVo.getEndDateStr(), "\u65b0\u589e\u65f6\uff0c\u7b56\u7565\u660e\u7ec6\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", true, "yyyy-MM-dd", arg_0 -> ((MarketingStrategyItemDto)item2).setEndDate(arg_0), errorList);
                                if (StringUtils.isNotEmpty((CharSequence)importVo.getAttrOrgCode())) {
                                    String attrOrgName = (String)orgMap.get(importVo.getAttrOrgCode());
                                    if (StringUtils.isEmpty((CharSequence)attrOrgName)) {
                                        errorList.add("\u5f52\u5c5e\u90e8\u95e8[" + importVo.getAttrOrgCode() + "]\u6709\u8bef");
                                    } else {
                                        item2.setAttrOrgName(attrOrgName);
                                    }
                                }
                                if (StringUtils.isNotEmpty((CharSequence)importVo.getStrategyOrgCode())) {
                                    Map voMap = (Map)salesOrgMap.get(importVo.getChannelCode() + businessFormatCode + importVo.getSalesInstitutionCode());
                                    if (null == voMap) {
                                        errorList.add("\u5206\u9500\u6e20\u9053[" + importVo.getChannelCode() + "]\u9500\u552e\u7ec4\u7ec7[" + importVo.getSalesInstitutionCode() + "]\u672a\u5339\u914d");
                                    } else if (voMap.isEmpty()) {
                                        errorList.add("\u533a\u57df[" + importVo.getStrategyOrgCode() + "]\u6709\u8bef");
                                    } else {
                                        SalesOrgVo orgVo = (SalesOrgVo)voMap.get(importVo.getStrategyOrgCode());
                                        if (Objects.isNull(orgVo)) {
                                            errorList.add("\u533a\u57df[" + importVo.getStrategyOrgCode() + "]\u6709\u8bef");
                                        } else {
                                            item2.setStrategyOrgName(orgVo.getSalesOrgName());
                                            item2.setStrategyOrgCode(orgVo.getSalesOrgCode());
                                            item2.setStrategyOrgErpCode(orgVo.getErpCode());
                                        }
                                    }
                                }
                                if (StringUtils.isNotEmpty((CharSequence)importVo.getActivityTypeCode())) {
                                    codes = importVo.getActivityTypeCode().split(",");
                                    allNames = new LinkedList<String>();
                                    for (String code : codes) {
                                        String activityTypeName = (String)activityTypeMap.get(code);
                                        if (StringUtils.isEmpty((CharSequence)activityTypeName)) {
                                            errorList.add("\u6d3b\u52a8\u5206\u7c7b[" + code + "]\u6709\u8bef");
                                            break block68;
                                        }
                                        allNames.add(activityTypeName);
                                    }
                                    item2.setActivityTypeName(String.join((CharSequence)",", allNames));
                                }
                            }
                            if (StringUtils.isNotEmpty((CharSequence)importVo.getActivityFormCode())) {
                                codes = importVo.getActivityFormCode().split(",");
                                allNames = new LinkedList();
                                for (String code : codes) {
                                    String activityFormName = (String)activityFormMap.get(code);
                                    if (StringUtils.isEmpty((CharSequence)activityFormName)) {
                                        errorList.add("\u6d3b\u52a8\u5f62\u5f0f[" + code + "]\u6709\u8bef");
                                        break block69;
                                    }
                                    allNames.add(activityFormName);
                                }
                                item2.setActivityFormName(String.join((CharSequence)",", allNames));
                            }
                        }
                        if (StringUtils.isNotEmpty((CharSequence)importVo.getMonthBudgetCode())) {
                            MonthBudgetVo monthBudgetVo = (MonthBudgetVo)monthBudgetMap.get(importVo.getMonthBudgetCode());
                            if (null == monthBudgetVo) {
                                errorList.add("\u6708\u5ea6\u9884\u7b97[" + importVo.getMonthBudgetCode() + "]\u6709\u8bef");
                            } else if (!MonthBudgetGroupEnum.organization.getCode().equals(monthBudgetVo.getGroupCode())) {
                                errorList.add("\u6708\u5ea6\u9884\u7b97[" + monthBudgetVo.getMonthBudgetCode() + "],\u5fc5\u987b\u4e3a\u90e8\u95e8\u5206\u7ec4");
                            } else {
                                item2.setBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                                item2.setBudgetItemName(monthBudgetVo.getBudgetItemName());
                                item2.setFeeBelongCode(monthBudgetVo.getFeeBelongCode());
                                item2.setStrategyYearMonth(monthBudgetVo.getYearMonthLy());
                            }
                        }
                        if (StringUtils.isNotEmpty((CharSequence)importVo.getFirstChannelCode())) {
                            codes = importVo.getFirstChannelCode().split(",");
                            allNames = new LinkedList();
                            for (String code : codes) {
                                terminalChannelName = (String)terminalChannelMap.get(code);
                                if (StringUtils.isEmpty((CharSequence)terminalChannelName)) {
                                    errorList.add("\u4e00\u7ea7\u6e20\u9053[" + importVo.getFirstChannelCode() + "]\u6709\u8bef");
                                    break block70;
                                }
                                allNames.add(terminalChannelName);
                            }
                            item2.setFirstChannelName(String.join((CharSequence)",", allNames));
                        }
                    }
                    if (StringUtils.isNotEmpty((CharSequence)importVo.getSecondChannelCode())) {
                        codes = importVo.getSecondChannelCode().split(",");
                        allNames = new LinkedList();
                        for (String code : codes) {
                            terminalChannelName = (String)terminalChannelMap.get(code);
                            if (StringUtils.isEmpty((CharSequence)terminalChannelName)) {
                                errorList.add("\u4e8c\u7ea7\u6e20\u9053[" + importVo.getSecondChannelCode() + "]\u6709\u8bef");
                                break block71;
                            }
                            allNames.add(terminalChannelName);
                        }
                        item2.setSecondChannelName(String.join((CharSequence)",", allNames));
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getProductBrandCode())) {
                    String brandName = (String)productBrandMap.get(importVo.getProductBrandCode());
                    if (StringUtils.isEmpty((CharSequence)brandName)) {
                        errorList.add("\u54c1\u724c[" + importVo.getProductBrandCode() + "]\u6709\u8bef");
                    } else {
                        item2.setProductBrandName(brandName);
                    }
                }
                item2.setId(UUID.randomUUID().toString().replace("-", ""));
                item2.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                item2.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                dtos.add(item2);
            }
            if (errorListMap.size() > 0) {
                log.error("===========================\u65b9\u6848\u5bfc\u5165\uff0c\u9519\u8bef\u4fe1\u606f" + JSON.toJSONString((Object)errorListMap));
                for (Map.Entry entry : errorListMap.entrySet()) {
                    List value = (List)entry.getValue();
                    if (value.size() <= 0) continue;
                    errorMap.put(entry.getKey(), String.join((CharSequence)",", value));
                }
            }
            if (errorMap.size() == 0) {
                Map<String, List<MarketingStrategyItemDto>> strategyMap = dtos.stream().collect(Collectors.groupingBy(item -> item.getBusinessFormatCode() + item.getBusinessUnitCode() + item.getStrategyType()));
                for (Map.Entry<String, List<MarketingStrategyItemDto>> entry : strategyMap.entrySet()) {
                    List<MarketingStrategyItemDto> value = entry.getValue();
                    MarketingStrategyItemDto firstData = value.get(0);
                    MarketingStrategyDto marketingStrategyDto = new MarketingStrategyDto();
                    marketingStrategyDto.setBusinessFormatCode(firstData.getBusinessFormatCode());
                    marketingStrategyDto.setBusinessUnitCode(firstData.getBusinessUnitCode());
                    marketingStrategyDto.setStrategyType(firstData.getStrategyType());
                    this.marketingStrategyService.saveMutiMarketingStrategy(marketingStrategyDto, value);
                }
            }
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            String errorMsg = e.getMessage();
            if (StringUtils.isEmpty((CharSequence)e.getMessage())) {
                errorMsg = "\u6570\u636e\u5904\u7406\u5931\u8d25\uff01";
            }
            throw new IllegalArgumentException(errorMsg);
        }
        return errorMap;
    }

    public void validateAndConvertDictData(Map<String, Map<String, String>> dictMap, String dictTypeCode, String dictValue, Consumer<String> setMethod, String desc, List<String> errorList) {
        try {
            this.validateAndConvertDictData(dictMap, dictTypeCode, dictValue, setMethod, desc);
        }
        catch (RuntimeException e) {
            errorList.add(e.getMessage());
        }
    }

    private void validateDateStrAndSet(String str, String desc, boolean required, String pattern, Consumer<Date> setMethod, List<String> errorList) {
        try {
            DateStringDealUtil.validateDateStrAndSet((String)str, (String)desc, (boolean)required, (String)pattern, setMethod);
        }
        catch (RuntimeException e) {
            errorList.add(e.getMessage());
        }
    }

    public void validateAndConvertDictData(Map<String, Map<String, String>> dictMap, String dictTypeCode, String dictValue, Consumer<String> setMethod, String desc) {
        if (StringUtils.isEmpty((CharSequence)dictValue)) {
            return;
        }
        Map<String, String> dictDataMap = dictMap.get(dictTypeCode);
        String dictCode = dictDataMap.get(dictValue);
        if (StringUtils.isEmpty((CharSequence)dictCode)) {
            throw new RuntimeException(desc + "[" + dictValue + "]\u6709\u8bef");
        }
        setMethod.accept(dictCode);
    }

    public Class<MarketingStrategyItemDY00000008ImportVo> findCrmExcelVoClass() {
        return MarketingStrategyItemDY00000008ImportVo.class;
    }

    public String getTemplateCode() {
        return "TPM_MARKETING_STRATEGY_IMPORT_DY00000008";
    }

    public String getTemplateName() {
        return "TPM-\u8425\u9500\u7b56\u7565\u5bfc\u5165-\u4e3b\u4f53";
    }

    public String getBusinessCode() {
        return "TPM_MARKETING_STRATEGY_IMPORT";
    }

    public String getBusinessName() {
        return "TPM-\u8425\u9500\u7b56\u7565\u5bfc\u5165";
    }
}

