/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.marketing.strategy.local.imports;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.terminal.channel.sdk.service.MdmTerminalChannelVoService;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.marketing.strategy.local.imports.vo.MarketingStrategyItemDY00000010ImportVo;
import com.biz.crm.tpm.business.marketing.strategy.local.service.MarketingStrategyService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MarketingStrategyDY00000010ImportsProcess
implements ImportProcess<MarketingStrategyItemDY00000010ImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MarketingStrategyDY00000010ImportsProcess.class);
    @Autowired
    private MarketingStrategyService marketingStrategyService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private ActivityTypeService activityTypeService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private MdmTerminalChannelVoService terminalChannelVoService;
    @Autowired(required=false)
    private ProductBrandService productBrandService;

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, MarketingStrategyItemDY00000010ImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        try {
            List salesOrgList;
            ArrayList importVos = Lists.newArrayList(data.values());
            ArrayList dictCodeList = Lists.newArrayList();
            dictCodeList.add("mdm_business_format");
            dictCodeList.add("mdm_business_unit");
            dictCodeList.add("tpm_marketing_strategy_type");
            dictCodeList.add("MDM_CUSTOMIZE_ORG");
            dictCodeList.add("firstChannelName");
            dictCodeList.add("secondChannelCode");
            Map dictMap = this.dictDataVoService.findByDictTypeCodeList((List)dictCodeList);
            Map<String, Map<String, String>> dictMapMap = dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> ((List)item.getValue()).stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode, (o, n) -> n)), (o, n) -> n));
            HashSet orgCodeSet = Sets.newHashSet();
            HashSet activityTypeCodeSet = Sets.newHashSet();
            HashSet activityFormCodeSet = Sets.newHashSet();
            HashSet monthBudgetCodeSet = Sets.newHashSet();
            HashSet terminalChannelSet = Sets.newHashSet();
            HashSet productBrandCodeSet = Sets.newHashSet();
            HashSet salesOrgCodeSet = Sets.newHashSet();
            for (MarketingStrategyItemDY00000010ImportVo importVo : importVos) {
                Validate.notBlank((CharSequence)importVo.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)importVo.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)importVo.getStrategyType(), (String)"\u7b56\u7565\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                if (StringUtils.isNotEmpty((CharSequence)importVo.getAttrOrgCode())) {
                    orgCodeSet.add(importVo.getAttrOrgCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getActivityTypeCode())) {
                    activityTypeCodeSet.addAll(Arrays.asList(importVo.getActivityTypeCode().split(",")));
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getActivityFormCode())) {
                    activityFormCodeSet.addAll(Arrays.asList(importVo.getActivityFormCode().split(",")));
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getHeadMonthBudgetCode())) {
                    monthBudgetCodeSet.add(importVo.getHeadMonthBudgetCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getRegionAutomaticMonthBudgetCode())) {
                    monthBudgetCodeSet.add(importVo.getRegionAutomaticMonthBudgetCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getRegionReferendumMonthBudgetCode())) {
                    monthBudgetCodeSet.add(importVo.getRegionReferendumMonthBudgetCode());
                }
                if (!StringUtils.isNotEmpty((CharSequence)importVo.getProductBrandCode())) continue;
                productBrandCodeSet.add(importVo.getProductBrandCode());
            }
            Map<Object, Object> orgMap = Maps.newHashMap();
            Map<Object, Object> salesOrgMap = Maps.newHashMap();
            Map<Object, Object> activityTypeMap = Maps.newHashMap();
            Map activityFormMap = Maps.newHashMap();
            Map<Object, Object> monthBudgetMap = Maps.newHashMap();
            HashMap terminalChannelMap = Maps.newHashMap();
            Map<Object, Object> productBrandMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty((Collection)orgCodeSet)) {
                List orgList = this.orgVoService.findByOrgCodes((List)Lists.newArrayList((Iterable)orgCodeSet));
                orgMap = orgList.stream().collect(Collectors.toMap(OrgVo::getOrgCode, OrgVo::getOrgName));
            }
            if (!CollectionUtils.isEmpty((Collection)salesOrgCodeSet) && !CollectionUtils.isEmpty((Collection)(salesOrgList = this.salesOrgVoService.findBySalesOrgCodes((List)Lists.newArrayList((Iterable)salesOrgCodeSet))))) {
                salesOrgMap = salesOrgList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, SalesOrgVo::getSalesOrgName));
            }
            if (!CollectionUtils.isEmpty((Collection)activityTypeCodeSet)) {
                List activityTypeList = this.activityTypeService.findByCodes((List)Lists.newArrayList((Iterable)activityTypeCodeSet));
                activityTypeMap = activityTypeList.stream().collect(Collectors.toMap(ActivityTypeVo::getActivityTypeCode, ActivityTypeVo::getActivityTypeName));
            }
            if (!CollectionUtils.isEmpty((Collection)activityFormCodeSet)) {
                ArrayList activityFormCodeList = Lists.newArrayList((Iterable)activityFormCodeSet);
                ArrayList activityFormCodeListBag = Lists.newArrayList();
                activityFormCodeListBag.add(activityFormCodeList);
                activityFormMap = this.activityFormService.findFormByCodes((List)activityFormCodeListBag);
            }
            if (!CollectionUtils.isEmpty((Collection)monthBudgetCodeSet)) {
                List monthBudgetVos = this.monthBudgetService.listByCodes((List)Lists.newArrayList((Iterable)monthBudgetCodeSet));
                monthBudgetMap = monthBudgetVos.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity()));
            }
            if (!CollectionUtils.isEmpty((Collection)productBrandCodeSet)) {
                List productBrandVos = this.productBrandService.listByCodes((List)Lists.newArrayList((Iterable)productBrandCodeSet));
                productBrandMap = productBrandVos.stream().collect(Collectors.toMap(ProductBrandVo::getProductBrandCode, ProductBrandVo::getProductBrandName, (o, n) -> n));
            }
            ArrayList dtos = Lists.newArrayList();
            for (MarketingStrategyItemDY00000010ImportVo importVo : importVos) {
                MarketingStrategyBudgetDto budgetDto;
                MonthBudgetVo monthBudgetVo;
                LinkedList<String> allNames;
                String[] codes;
                MarketingStrategyItemDto item2 = (MarketingStrategyItemDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)importVo, MarketingStrategyItemDto.class, HashSet.class, ArrayList.class, new String[0]);
                this.validateAndConvertDictData(dictMapMap, "mdm_business_format", importVo.getBusinessFormatCode(), arg_0 -> ((MarketingStrategyItemDto)item2).setBusinessFormatCode(arg_0), "\u4e1a\u6001");
                this.validateAndConvertDictData(dictMapMap, "mdm_business_unit", importVo.getBusinessUnitCode(), arg_0 -> ((MarketingStrategyItemDto)item2).setBusinessUnitCode(arg_0), "\u4e1a\u52a1\u5355\u5143");
                this.validateAndConvertDictData(dictMapMap, "tpm_marketing_strategy_type", importVo.getStrategyType(), arg_0 -> ((MarketingStrategyItemDto)item2).setStrategyType(arg_0), "\u7b56\u7565\u7c7b\u578b");
                this.validateAndConvertDictData(dictMapMap, "MDM_CUSTOMIZE_ORG", importVo.getRegion(), arg_0 -> ((MarketingStrategyItemDto)item2).setRegion(arg_0), "\u533a\u57df");
                this.validateAndConvertDictData(dictMapMap, "firstChannelName", importVo.getFirstChannelName(), arg_0 -> ((MarketingStrategyItemDto)item2).setFirstChannelCode(arg_0), "\u4e00\u7ea7\u6e20\u9053\u540d\u79f0");
                this.validateAndConvertDictData(dictMapMap, "secondChannelCode", importVo.getSecondChannelName(), arg_0 -> ((MarketingStrategyItemDto)item2).setSecondChannelCode(arg_0), "\u4e8c\u7ea7\u6e20\u9053\u540d\u79f0");
                if (StringUtils.isNotEmpty((CharSequence)importVo.getAttrOrgCode())) {
                    String attrOrgName = (String)orgMap.get(importVo.getAttrOrgCode());
                    if (StringUtils.isEmpty((CharSequence)attrOrgName)) {
                        throw new RuntimeException("\u5f52\u5c5e\u90e8\u95e8[" + importVo.getAttrOrgCode() + "]\u6709\u8bef");
                    }
                    item2.setAttrOrgName(attrOrgName);
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getActivityTypeCode())) {
                    codes = importVo.getActivityTypeCode().split(",");
                    allNames = new LinkedList<String>();
                    for (String code : codes) {
                        String activityTypeName = (String)activityTypeMap.get(code);
                        if (StringUtils.isEmpty((CharSequence)activityTypeName)) {
                            throw new RuntimeException("\u6d3b\u52a8\u5206\u7c7b[" + code + "]\u6709\u8bef");
                        }
                        allNames.add(activityTypeName);
                    }
                    item2.setActivityTypeName(String.join((CharSequence)",", allNames));
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getActivityFormCode())) {
                    codes = importVo.getActivityFormCode().split(",");
                    allNames = new LinkedList();
                    for (String code : codes) {
                        String activityFormName = (String)activityFormMap.get(code);
                        if (StringUtils.isEmpty((CharSequence)activityFormName)) {
                            throw new RuntimeException("\u6d3b\u52a8\u5f62\u5f0f[" + code + "]\u6709\u8bef");
                        }
                        allNames.add(activityFormName);
                    }
                    item2.setActivityFormName(String.join((CharSequence)",", allNames));
                }
                ArrayList budgetShares = Lists.newArrayList();
                item2.setBudgetShares((List)budgetShares);
                if (StringUtils.isNotEmpty((CharSequence)importVo.getHeadMonthBudgetCode())) {
                    monthBudgetVo = (MonthBudgetVo)monthBudgetMap.get(importVo.getHeadMonthBudgetCode());
                    if (null == monthBudgetVo) {
                        throw new RuntimeException("\u6708\u5ea6\u9884\u7b97[" + importVo.getHeadMonthBudgetCode() + "]\u6709\u8bef");
                    }
                    item2.setHeadBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                    item2.setHeadBudgetItemName(monthBudgetVo.getBudgetItemCode());
                    item2.setFeeBelongCode(monthBudgetVo.getFeeBelongCode());
                    item2.setStrategyYearMonth(monthBudgetVo.getYearMonthLy());
                    budgetDto = new MarketingStrategyBudgetDto();
                    BeanUtils.copyProperties((Object)monthBudgetVo, (Object)budgetDto);
                    try {
                        budgetDto.setUseAmountStr(importVo.getHeadFeeAmountStr());
                        budgetDto.setUseAmount(new BigDecimal(importVo.getHeadFeeAmountStr()));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("\u603b\u90e8\u8d39\u7528\u683c\u5f0f\u6709\u8bef!");
                    }
                    budgetShares.add(budgetDto);
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getRegionReferendumMonthBudgetCode())) {
                    monthBudgetVo = (MonthBudgetVo)monthBudgetMap.get(importVo.getRegionReferendumMonthBudgetCode());
                    if (null == monthBudgetVo) {
                        throw new RuntimeException("\u6708\u5ea6\u9884\u7b97[" + importVo.getRegionReferendumMonthBudgetCode() + "]\u6709\u8bef");
                    }
                    item2.setRegionReferendumBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                    item2.setRegionReferendumBudgetItemName(monthBudgetVo.getBudgetItemCode());
                    item2.setFeeBelongCode(monthBudgetVo.getFeeBelongCode());
                    item2.setStrategyYearMonth(monthBudgetVo.getYearMonthLy());
                    budgetDto = new MarketingStrategyBudgetDto();
                    BeanUtils.copyProperties((Object)monthBudgetVo, (Object)budgetDto);
                    try {
                        budgetDto.setUseAmountStr(importVo.getRegionReferendumFeeAmountStr());
                        budgetDto.setUseAmount(new BigDecimal(importVo.getRegionReferendumFeeAmountStr()));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("\u516c\u6295\u8d39\u7528\u683c\u5f0f\u6709\u8bef!");
                    }
                    budgetShares.add(budgetDto);
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getRegionAutomaticMonthBudgetCode())) {
                    monthBudgetVo = (MonthBudgetVo)monthBudgetMap.get(importVo.getRegionAutomaticMonthBudgetCode());
                    if (null == monthBudgetVo) {
                        throw new RuntimeException("\u6708\u5ea6\u9884\u7b97[" + importVo.getRegionAutomaticMonthBudgetCode() + "]\u6709\u8bef");
                    }
                    item2.setRegionAutomaticBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                    item2.setRegionAutomaticBudgetItemName(monthBudgetVo.getBudgetItemCode());
                    item2.setFeeBelongCode(monthBudgetVo.getFeeBelongCode());
                    item2.setStrategyYearMonth(monthBudgetVo.getYearMonthLy());
                    budgetDto = new MarketingStrategyBudgetDto();
                    BeanUtils.copyProperties((Object)monthBudgetVo, (Object)budgetDto);
                    try {
                        budgetDto.setUseAmountStr(importVo.getRegionAutomaticFeeAmountStr());
                        budgetDto.setUseAmount(new BigDecimal(importVo.getRegionAutomaticFeeAmountStr()));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("\u516c\u6295\u8d39\u7528\u683c\u5f0f\u6709\u8bef!");
                    }
                    budgetShares.add(budgetDto);
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getProductBrandCode())) {
                    String brandName = (String)productBrandMap.get(importVo.getProductBrandCode());
                    if (StringUtils.isEmpty((CharSequence)brandName)) {
                        throw new RuntimeException("\u54c1\u724c[" + importVo.getProductBrandCode() + "]\u6709\u8bef");
                    }
                    item2.setProductBrandName(brandName);
                }
                dtos.add(item2);
            }
            Map<String, List<MarketingStrategyItemDto>> strategyMap = dtos.stream().collect(Collectors.groupingBy(item -> item.getBusinessFormatCode() + item.getBusinessUnitCode() + item.getStrategyType()));
            for (Map.Entry<String, List<MarketingStrategyItemDto>> entry : strategyMap.entrySet()) {
                List<MarketingStrategyItemDto> value = entry.getValue();
                MarketingStrategyItemDto firstData = value.get(0);
                MarketingStrategyDto marketingStrategyDto = new MarketingStrategyDto();
                marketingStrategyDto.setBusinessFormatCode(firstData.getBusinessFormatCode());
                marketingStrategyDto.setBusinessUnitCode(firstData.getBusinessUnitCode());
                marketingStrategyDto.setStrategyType(firstData.getStrategyType());
                this.marketingStrategyService.saveMutiMarketingStrategy(marketingStrategyDto, value);
            }
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            String errorMsg = e.getMessage();
            if (StringUtils.isEmpty((CharSequence)e.getMessage())) {
                errorMsg = "\u6570\u636e\u5904\u7406\u5931\u8d25\uff01";
            }
            throw new IllegalArgumentException(errorMsg);
        }
        return null;
    }

    public void validateAndConvertDictData(Map<String, Map<String, String>> dictMap, String dictTypeCode, String dictValue, Consumer<String> setMethod, String desc) {
        if (StringUtils.isEmpty((CharSequence)dictValue)) {
            return;
        }
        Map<String, String> dictDataMap = dictMap.get(dictTypeCode);
        String dictCode = dictDataMap.get(dictValue);
        if (StringUtils.isEmpty((CharSequence)dictCode)) {
            throw new RuntimeException(desc + "[" + dictValue + "]\u6709\u8bef");
        }
        setMethod.accept(dictCode);
    }

    public Class<MarketingStrategyItemDY00000010ImportVo> findCrmExcelVoClass() {
        return MarketingStrategyItemDY00000010ImportVo.class;
    }

    public String getTemplateCode() {
        return "TPM_MARKETING_STRATEGY_IMPORT_DY00000010";
    }

    public String getTemplateName() {
        return "TPM-\u8425\u9500\u7b56\u7565\u5bfc\u5165-\u5782\u76f4";
    }

    public String getBusinessCode() {
        return "TPM_MARKETING_STRATEGY_IMPORT";
    }

    public String getBusinessName() {
        return "TPM-\u8425\u9500\u7b56\u7565\u5bfc\u5165";
    }
}

