/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.marketing.strategy.local.imports;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.product.level.sdk.enums.ProductLevelEnum;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.marketing.strategy.local.imports.vo.MarketingStrategyDy00000010ItemImportVo;
import com.biz.crm.tpm.business.marketing.strategy.local.service.MarketingStrategyItemService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.year.budget.sdk.service.YearBudgetSdkService;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MarketingStrategyDY00000010ItemImportProcess
implements ImportProcess<MarketingStrategyDy00000010ItemImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MarketingStrategyDY00000010ItemImportProcess.class);
    @Autowired
    private MarketingStrategyItemService marketingStrategyItemService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private ActivityTypeService activityTypeService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private YearBudgetSdkService yearBudgetSdkService;
    @Autowired(required=false)
    private ProductBrandService productBrandService;
    @Autowired(required=false)
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private CustomerRetailerVoService customerRetailerVoService;

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, MarketingStrategyDy00000010ItemImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Object businessFormatCodeObj = params.get("businessFormatCode");
        if (null == businessFormatCodeObj) {
            throw new RuntimeException("\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String businessFormatCode = String.valueOf(businessFormatCodeObj);
        Object businessUnitCodeObj = params.get("businessUnitCode");
        if (null == businessUnitCodeObj) {
            throw new RuntimeException("\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String cacheKey = String.valueOf(params.get("cacheKey"));
        HashMap errorMap = Maps.newHashMap();
        HashMap errorListMap = Maps.newHashMap();
        try {
            List customerRetailerVos;
            List salesOrgList;
            ArrayList dictCodeList = Lists.newArrayList();
            dictCodeList.add("MDM_CUSTOMIZE_ORG");
            Map dictMap = this.dictDataVoService.findByDictTypeCodeList((List)dictCodeList);
            Map<String, Map<String, String>> dictMapMap = dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> ((List)item.getValue()).stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode, (o, n) -> n)), (o, n) -> n));
            HashSet productBrandCodeSet = Sets.newHashSet();
            HashSet productLevelCodeSet = Sets.newHashSet();
            HashSet productCodeSet = Sets.newHashSet();
            HashSet salesOrgCodeSet = Sets.newHashSet();
            HashSet activityTypeCodeSet = Sets.newHashSet();
            HashSet activityFormCodeSet = Sets.newHashSet();
            HashSet monthBudgetCodeSet = Sets.newHashSet();
            HashSet customerRetailerNameSet = Sets.newHashSet();
            for (Map.Entry<Integer, MarketingStrategyDy00000010ItemImportVo> entry : data.entrySet()) {
                int key = entry.getKey();
                MarketingStrategyDy00000010ItemImportVo importVo = entry.getValue();
                List errorList = errorListMap.computeIfAbsent(key, k -> Lists.newArrayList());
                if (StringUtils.isNotEmpty((CharSequence)importVo.getStrategyOrgErpCode())) {
                    if (StringUtils.isEmpty((CharSequence)importVo.getDistributionChannelCode())) {
                        errorList.add("\u5bfc\u5165\u9500\u552e\u7ec4\u7ec7\u65f6\u5206\u9500\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    String salesOrgCode = importVo.getDistributionChannelCode() + businessFormatCode + importVo.getStrategyOrgErpCode();
                    salesOrgCodeSet.add(salesOrgCode);
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getActivityTypeCode())) {
                    activityTypeCodeSet.addAll(Arrays.asList(importVo.getActivityTypeCode().split(",")));
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getActivityFormCode())) {
                    activityFormCodeSet.addAll(Arrays.asList(importVo.getActivityFormCode().split(",")));
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getMonthBudgetCode())) {
                    monthBudgetCodeSet.add(importVo.getMonthBudgetCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getProductBrandCode())) {
                    productBrandCodeSet.add(importVo.getProductBrandCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getProductCode())) {
                    productCodeSet.add(importVo.getProductCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getProductItemCode())) {
                    productLevelCodeSet.add(importVo.getProductItemCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getProductCategoryCode())) {
                    productLevelCodeSet.add(importVo.getProductCategoryCode());
                }
                if (!StringUtils.isNotEmpty((CharSequence)importVo.getSystemName())) continue;
                customerRetailerNameSet.addAll(Arrays.asList(importVo.getSystemName().replace("\uff0c", ",").split(",")));
            }
            Map<Object, Object> salesOrgMap = Maps.newHashMap();
            Map<Object, Object> activityTypeMap = Maps.newHashMap();
            Map activityFormMap = Maps.newHashMap();
            Map<Object, Object> monthBudgetMap = Maps.newHashMap();
            Map<Object, Object> productBrandMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty((Collection)salesOrgCodeSet) && !CollectionUtils.isEmpty((Collection)(salesOrgList = this.salesOrgVoService.findBySalesOrgCodes((List)Lists.newArrayList((Iterable)salesOrgCodeSet))))) {
                salesOrgMap = salesOrgList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity(), (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty((Collection)activityTypeCodeSet)) {
                List activityTypeList = this.activityTypeService.findByCodes((List)Lists.newArrayList((Iterable)activityTypeCodeSet));
                activityTypeMap = activityTypeList.stream().collect(Collectors.toMap(ActivityTypeVo::getActivityTypeCode, ActivityTypeVo::getActivityTypeName));
            }
            if (!CollectionUtils.isEmpty((Collection)activityFormCodeSet)) {
                ArrayList activityFormCodeList = Lists.newArrayList((Iterable)activityFormCodeSet);
                ArrayList activityFormCodeListBag = Lists.newArrayList();
                activityFormCodeListBag.add(activityFormCodeList);
                activityFormMap = this.activityFormService.findFormByCodes((List)activityFormCodeListBag);
            }
            if (!CollectionUtils.isEmpty((Collection)monthBudgetCodeSet)) {
                List yearBudgetCodes = this.yearBudgetSdkService.findByYearBudgetCodes((List)Lists.newArrayList((Iterable)monthBudgetCodeSet));
                monthBudgetMap = yearBudgetCodes.stream().collect(Collectors.toMap(YearBudgetVo::getYearBudgetCode, Function.identity()));
            }
            if (!CollectionUtils.isEmpty((Collection)productBrandCodeSet)) {
                List productBrandVos = this.productBrandService.listByCodes((List)Lists.newArrayList((Iterable)productBrandCodeSet));
                productBrandMap = productBrandVos.stream().collect(Collectors.toMap(ProductBrandVo::getProductBrandCode, ProductBrandVo::getProductBrandName, (o, n) -> n));
            }
            Map<Object, Object> productCategoryMap = Maps.newHashMap();
            Map<Object, Object> productItemMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty((Collection)productLevelCodeSet)) {
                List productLevelVos = this.productLevelVoSdkService.findListByBusinessFormatAndCodes(businessFormatCode, (List)Lists.newArrayList((Iterable)productLevelCodeSet));
                List productCategoryList = productLevelVos.stream().filter(item -> ProductLevelEnum.category.equals((Object)item.getProductLevelType())).collect(Collectors.toList());
                productCategoryMap = productCategoryList.stream().collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, ProductLevelVo::getProductLevelName, (o, n) -> n));
                List productItemList = productLevelVos.stream().filter(item -> ProductLevelEnum.items.equals((Object)item.getProductLevelType())).collect(Collectors.toList());
                productItemMap = productItemList.stream().collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, ProductLevelVo::getProductLevelName, (o, n) -> n));
            }
            Map<Object, Object> productMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty((Collection)productCodeSet)) {
                List productVos = this.productVoService.findByCodes((List)Lists.newArrayList((Iterable)productCodeSet));
                productMap = productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity(), (o, n) -> n));
            }
            Map<Object, Object> systemMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty((Collection)customerRetailerNameSet) && !CollectionUtils.isEmpty((Collection)(customerRetailerVos = this.customerRetailerVoService.findByNames((List)Lists.newArrayList((Iterable)customerRetailerNameSet))))) {
                systemMap = customerRetailerVos.stream().collect(Collectors.toMap(CustomerRetailerVo::getCustomerRetailerName, CustomerRetailerVo::getCustomerRetailerCode, (o, n) -> n));
            }
            ArrayList dtos = Lists.newArrayList();
            for (Map.Entry<Integer, MarketingStrategyDy00000010ItemImportVo> entry : data.entrySet()) {
                String systemName;
                String productLevelName;
                LinkedList<String> allNames;
                String[] codes;
                int key = entry.getKey();
                List errorList = errorListMap.computeIfAbsent(key, k -> Lists.newArrayList());
                MarketingStrategyDy00000010ItemImportVo importVo = entry.getValue();
                MarketingStrategyItemDto item2 = (MarketingStrategyItemDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)importVo, MarketingStrategyItemDto.class, HashSet.class, ArrayList.class, new String[0]);
                this.validateAndConvertDictData(dictMapMap, "MDM_CUSTOMIZE_ORG", importVo.getRegionName(), arg_0 -> ((MarketingStrategyItemDto)item2).setRegion(arg_0), "\u533a\u57df");
                if (StringUtils.isNotEmpty((CharSequence)importVo.getStrategyOrgErpCode())) {
                    String salesOrgCode = importVo.getDistributionChannelCode() + businessFormatCode + importVo.getStrategyOrgErpCode();
                    SalesOrgVo salesOrgVo = (SalesOrgVo)salesOrgMap.get(salesOrgCode);
                    if (Objects.isNull(salesOrgVo)) {
                        errorList.add("\u9500\u552e\u7ec4\u7ec7[" + importVo.getStrategyOrgErpCode() + "]\u6709\u8bef");
                    }
                    item2.setStrategyOrgCode(salesOrgCode);
                    item2.setStrategyOrgName(salesOrgVo.getSalesOrgName());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getActivityTypeCode())) {
                    codes = importVo.getActivityTypeCode().split(",");
                    allNames = new LinkedList<String>();
                    for (String code : codes) {
                        String activityTypeName = (String)activityTypeMap.get(code);
                        if (StringUtils.isEmpty((CharSequence)activityTypeName)) {
                            throw new RuntimeException("\u6d3b\u52a8\u5206\u7c7b[" + code + "]\u6709\u8bef");
                        }
                        allNames.add(activityTypeName);
                    }
                    item2.setActivityTypeName(String.join((CharSequence)",", allNames));
                    item2.setActivityType(item2.getActivityTypeCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getActivityFormCode())) {
                    codes = importVo.getActivityFormCode().split(",");
                    allNames = new LinkedList();
                    for (String code : codes) {
                        String activityFormName = (String)activityFormMap.get(code);
                        if (StringUtils.isEmpty((CharSequence)activityFormName)) {
                            throw new RuntimeException("\u6d3b\u52a8\u5f62\u5f0f[" + code + "]\u6709\u8bef");
                        }
                        allNames.add(activityFormName);
                    }
                    item2.setActivityFormName(String.join((CharSequence)",", allNames));
                    item2.setActivityForm(item2.getActivityForm());
                }
                ArrayList budgetShares = Lists.newArrayList();
                item2.setBudgetShares((List)budgetShares);
                if (StringUtils.isNotEmpty((CharSequence)importVo.getMonthBudgetCode())) {
                    YearBudgetVo monthBudgetVo = (YearBudgetVo)monthBudgetMap.get(importVo.getMonthBudgetCode());
                    if (null == monthBudgetVo) {
                        throw new RuntimeException("\u5e74\u5ea6\u9884\u7b97[" + importVo.getMonthBudgetCode() + "]\u6709\u8bef");
                    }
                    item2.setMonthBudgetCode(importVo.getMonthBudgetCode());
                    item2.setBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                    item2.setBudgetItemName(monthBudgetVo.getBudgetItemCode());
                    item2.setFeeBelongCode(monthBudgetVo.getFeeBelongCode());
                    MarketingStrategyBudgetDto budgetDto = new MarketingStrategyBudgetDto();
                    BeanUtils.copyProperties((Object)monthBudgetVo, (Object)budgetDto);
                    budgetDto.setMonthBudgetCode(importVo.getMonthBudgetCode());
                    try {
                        budgetDto.setUseAmountStr(importVo.getFeeAmountStr());
                        budgetDto.setUseAmount(new BigDecimal(importVo.getFeeAmountStr()));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("\u8d39\u7528\u683c\u5f0f\u6709\u8bef!");
                    }
                    budgetShares.add(budgetDto);
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getProductBrandCode())) {
                    String brandName = (String)productBrandMap.get(importVo.getProductBrandCode());
                    if (StringUtils.isEmpty((CharSequence)brandName)) {
                        throw new RuntimeException("\u54c1\u724c[" + importVo.getProductBrandCode() + "]\u6709\u8bef");
                    }
                    item2.setProductBrandName(brandName);
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getProductCategoryCode())) {
                    productLevelName = (String)productCategoryMap.get(importVo.getProductCategoryCode());
                    if (StringUtils.isEmpty((CharSequence)productLevelName)) {
                        errorList.add("\u54c1\u7c7b[" + importVo.getProductCategoryCode() + "]\u6709\u8bef");
                    }
                    item2.setProductCategoryName(productLevelName);
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getProductItemCode())) {
                    productLevelName = (String)productItemMap.get(importVo.getProductItemCode());
                    if (StringUtils.isEmpty((CharSequence)productLevelName)) {
                        errorList.add("\u54c1\u9879[" + importVo.getProductItemCode() + "]\u6709\u8bef");
                    }
                    item2.setProductItemName(productLevelName);
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getProductCode())) {
                    ProductVo productVo = (ProductVo)productMap.get(importVo.getProductCode());
                    if (null == productVo) {
                        errorList.add("\u4ea7\u54c1\u7f16\u7801[" + importVo.getProductCode() + "]\u6709\u8bef");
                    } else {
                        item2.setProductName(productVo.getProductName());
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)(systemName = importVo.getSystemName()))) {
                    systemName = systemName.replace("\uff0c", ",");
                    String[] form = systemName.split(",");
                    ArrayList<String> customerRetailerCodeList = new ArrayList<String>();
                    for (String s : form) {
                        String code = (String)systemMap.get(s);
                        if (StringUtils.isEmpty((CharSequence)code)) {
                            errorList.add("\u96f6\u552e\u5546\u7f16\u7801[" + s + "]\u6709\u8bef");
                        }
                        customerRetailerCodeList.add(code);
                    }
                    String customerRetailerCode = null;
                    if (!CollectionUtils.isEmpty(customerRetailerCodeList)) {
                        customerRetailerCode = String.join((CharSequence)",", customerRetailerCodeList);
                    } else {
                        errorList.add("\u96f6\u552e\u5546\u540d\u79f0[" + importVo.getSystemName() + "]\u6709\u8bef");
                    }
                    item2.setSystemCode(customerRetailerCode);
                }
                item2.setId(UUID.randomUUID().toString().replace("-", ""));
                item2.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                item2.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                BigDecimal costEffectivenessRatio = BigDecimal.ZERO;
                BigDecimal feeAmount = BigDecimal.ZERO;
                if (StringUtils.isNotEmpty((CharSequence)item2.getFeeAmountStr())) {
                    feeAmount = new BigDecimal(item2.getFeeAmountStr());
                }
                if (null != item2.getSalesGoalAmount() && BigDecimal.ZERO.compareTo(item2.getSalesGoalAmount()) != 0) {
                    costEffectivenessRatio = feeAmount.divide(item2.getSalesGoalAmount(), 4, RoundingMode.HALF_UP);
                }
                item2.setCostEffectivenessRatio(costEffectivenessRatio);
                dtos.add(item2);
            }
            if (errorListMap.size() > 0) {
                for (Map.Entry<Integer, MarketingStrategyDy00000010ItemImportVo> entry : errorListMap.entrySet()) {
                    List value = (List)((Object)entry.getValue());
                    if (value.size() <= 0) continue;
                    errorMap.put(entry.getKey(), String.join((CharSequence)" | ", value));
                }
            }
            if (errorMap.size() == 0 && !CollectionUtils.isEmpty((Collection)dtos)) {
                this.marketingStrategyItemService.saveListCache(cacheKey, dtos);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            String errorMsg = e.getMessage();
            if (StringUtils.isEmpty((CharSequence)e.getMessage())) {
                errorMsg = "\u6570\u636e\u5904\u7406\u5931\u8d25\uff01";
            }
            throw new IllegalArgumentException(errorMsg);
        }
        return errorMap;
    }

    public void validateAndConvertDictData(Map<String, Map<String, String>> dictMap, String dictTypeCode, String dictValue, Consumer<String> setMethod, String desc) {
        if (StringUtils.isEmpty((CharSequence)dictValue)) {
            return;
        }
        Map<String, String> dictDataMap = dictMap.get(dictTypeCode);
        String dictCode = dictDataMap.get(dictValue);
        if (StringUtils.isEmpty((CharSequence)dictCode)) {
            throw new RuntimeException(desc + "[" + dictValue + "]\u6709\u8bef");
        }
        setMethod.accept(dictCode);
    }

    public Class<MarketingStrategyDy00000010ItemImportVo> findCrmExcelVoClass() {
        return MarketingStrategyDy00000010ItemImportVo.class;
    }

    public String getTemplateCode() {
        return "TPM_MARKETING_STRATEGY_DY00000010_ITEM_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u5782\u76f4\u8425\u9500\u7b56\u7565\u660e\u7ec6\u5bfc\u5165";
    }
}

