/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.marketing.strategy.local.modify.consumer;

import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.service.MarketingStrategyItemModifyService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.enums.MarketingStrategyModifyMqTagEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@RocketMQMessageListener(topic="TPM_MARKETING_STRATEGY_MODIFY_PROCESS_PASS_TOPIC${rocketmq.environment}", selectorExpression="TPM_MARKETING_STRATEGY_MODIFY_PASS_UPDATE_ORIGIN", consumerGroup="TPM_MARKETING_STRATEGY_MODIFY_PASS_UPDATE_ORIGIN${rocketmq.environment}", consumeMode=ConsumeMode.CONCURRENTLY, messageModel=MessageModel.CLUSTERING)
public class MarketingStrategyModifyPassUpdatePlanConsumer
extends AbstractRocketMqConsumer {
    private static final Logger log = LoggerFactory.getLogger(MarketingStrategyModifyPassUpdatePlanConsumer.class);
    @Autowired
    private MarketingStrategyItemModifyService marketingStrategyItemModifyService;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;

    protected Object handleMessage(MqMessageVo message) {
        log.info(MarketingStrategyModifyMqTagEnum.PASS_UPDATE_ORIGIN.getName() + " order mq message received  : {}", (Object)message);
        if (Objects.isNull(message) || StringUtils.isEmpty((CharSequence)message.getMsgBody())) {
            return "\u6d88\u606f\u4e3a\u7a7a!";
        }
        try {
            String businessNo = message.getMsgBody();
            this.marketingStrategyItemModifyService.doUpdatePlanData(businessNo);
            this.passPushMq(businessNo);
        }
        catch (Exception e) {
            log.error(MarketingStrategyModifyMqTagEnum.PASS_UPDATE_ORIGIN.getName() + "\u5904\u7406\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return "\u6d88\u8d39\u5931\u8d25." + e.getMessage();
        }
        return "\u6d88\u8d39\u6210\u529f.";
    }

    private void passPushMq(String businessNo) {
        if (StringUtils.isEmpty((CharSequence)businessNo)) {
            return;
        }
        ArrayList pushTagList = Lists.newArrayList();
        for (MarketingStrategyModifyMqTagEnum mqTagEnum : MarketingStrategyModifyMqTagEnum.values()) {
            if (!MarketingStrategyModifyMqTagEnum.PushType.after_update_origin.equals((Object)mqTagEnum.getPushType())) continue;
            pushTagList.add(mqTagEnum);
        }
        if (CollectionUtils.isEmpty((Collection)pushTagList)) {
            return;
        }
        for (MarketingStrategyModifyMqTagEnum mqTagEnum : pushTagList) {
            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setMsgBody(businessNo);
            mqMessageVo.setTopic("TPM_MARKETING_STRATEGY_MODIFY_PROCESS_PASS_TOPIC" + RocketMqUtil.mqEnvironment());
            mqMessageVo.setTag(mqTagEnum.getCode());
            this.rocketMqProducer.sendMqMsg(mqMessageVo);
        }
    }
}

