/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.marketing.strategy.local.modify.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.page.cache.controller.MnPageCacheController;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.service.MarketingStrategyItemModifyService;
import com.biz.crm.tpm.business.marketing.strategy.local.vo.MarketingStrategyBudgetSumVo;
import com.biz.crm.tpm.business.marketing.strategy.local.vo.MarketingStrategyModifyFieldValue;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyItemModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyModifyAdjustBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyToModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.vo.MarketingStrategyItemModifyVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.vo.MarketingStrategyModifyAdjustBudgetVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/marketingStrategyItemModify"})
@Api(tags={"\u8425\u9500\u7b56\u7565\u660e\u7ec6\u53d8\u66f4\u63a5\u53e3"})
public class MarketingStrategyItemModifyController
extends MnPageCacheController<MarketingStrategyItemModifyVo, MarketingStrategyItemModifyDto> {
    private static final Logger log = LoggerFactory.getLogger(MarketingStrategyItemModifyController.class);
    @Autowired(required=false)
    private MarketingStrategyItemModifyService marketingStrategyItemModifyService;

    @ApiOperation(value="\u83b7\u53d6\u5f85\u8c03\u6574\u7684\u8425\u9500\u7b56\u7565\u660e\u7ec6\u6570\u636e")
    @PostMapping(value={"initToModifyList"})
    public Result<Page<MarketingStrategyItemModifyVo>> initToModifyList(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody MarketingStrategyToModifyDto dto) {
        try {
            this.marketingStrategyItemModifyService.initToModifyList(cacheKey, dto);
            Page page = this.marketingStrategyItemModifyService.findCachePageList(pageable, null, cacheKey);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u9884\u7b97\u6c47\u603b\u4fe1\u606f")
    @PostMapping(value={"findBudgetCacheSumList"})
    public Result<List<MarketingStrategyBudgetSumVo>> findBudgetCacheSumList(@ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey) {
        try {
            List<MarketingStrategyBudgetSumVo> list = this.marketingStrategyItemModifyService.findBudgetCacheSumList(cacheKey);
            return Result.ok(list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u660e\u7ec6\u884c\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findItemByConditions"})
    public Result<Page<MarketingStrategyItemModifyVo>> findItemByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u67e5\u8be2\u5b9e\u4f53") MarketingStrategyItemModifyDto dto) {
        try {
            Validate.notBlank((CharSequence)dto.getModifyBusinessCode(), (String)"\u7b56\u7565\u53d8\u66f4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Page<MarketingStrategyItemModifyVo> page = this.marketingStrategyItemModifyService.findByConditions(pageable, dto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7b56\u7565\u8c03\u6574\u524d\u6570\u636e\u67e5\u8be2")
    @PostMapping(value={"findItemBeforeModifyList"})
    public Result<Page<MarketingStrategyItemModifyVo>> findItemBeforeModifyList(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u67e5\u8be2\u5b9e\u4f53") MarketingStrategyItemModifyDto dto) {
        try {
            Validate.notBlank((CharSequence)dto.getModifyBusinessCode(), (String)"\u7b56\u7565\u53d8\u66f4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Page<MarketingStrategyItemModifyVo> page = this.marketingStrategyItemModifyService.findItemBeforeModifyList(pageable, dto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7b56\u7565\u8c03\u6574\u524d\u6570\u636e\u67e5\u8be2")
    @PostMapping(value={"findItemModifyLFieldValueList"})
    public Result<Page<MarketingStrategyModifyFieldValue>> findItemModifyLFieldValueList(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u67e5\u8be2\u5b9e\u4f53") MarketingStrategyItemModifyDto dto) {
        try {
            Validate.notBlank((CharSequence)dto.getModifyBusinessCode(), (String)"\u7b56\u7565\u53d8\u66f4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Page<MarketingStrategyModifyFieldValue> page = this.marketingStrategyItemModifyService.findItemModifyLFieldValueList(pageable, dto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7b56\u7565\u8c03\u6574\u524d\u6570\u636e\u67e5\u8be2")
    @PostMapping(value={"findItemModifyLFieldValueListByProcessNo"})
    public Result<List<MarketingStrategyModifyFieldValue>> findItemModifyLFieldValueListByProcessNo(@ApiParam(value="\u6d41\u7a0b\u7f16\u53f7") @RequestParam String processNo) {
        try {
            List<MarketingStrategyModifyFieldValue> list = this.marketingStrategyItemModifyService.findItemModifyLFieldValueListByProcessNo(processNo);
            return Result.ok(list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7b56\u7565\u8c03\u6574\u524d\u6570\u636e\u67e5\u8be2")
    @PostMapping(value={"findAdjustBudgetListByModifyCode"})
    public Result<List<MarketingStrategyModifyAdjustBudgetVo>> findAdjustBudgetListByModifyCode(@ApiParam(name="dto", value="\u67e5\u8be2\u5b9e\u4f53") MarketingStrategyModifyAdjustBudgetDto dto) {
        try {
            List<Object> list = Lists.newArrayList();
            if (StringUtils.isNotEmpty((CharSequence)dto.getModifyBusinessCode())) {
                list = this.marketingStrategyItemModifyService.findAdjustBudgetVoListByModifyCode(dto.getModifyBusinessCode());
            } else if (StringUtils.isNotEmpty((CharSequence)dto.getProcessNo())) {
                list = this.marketingStrategyItemModifyService.findAdjustBudgetVoListByProcessNo(dto.getProcessNo());
            } else {
                throw new RuntimeException("\u53c2\u6570\u6709\u8bef\uff01");
            }
            return Result.ok((Object)list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6267\u884c\u53d8\u66f4")
    @PostMapping(value={"/doUpdatePlanData"})
    public Result doUpdatePlanData(@RequestParam String modifyCode) {
        try {
            this.marketingStrategyItemModifyService.doUpdatePlanData(modifyCode);
            return Result.ok((String)"\u63d0\u4ea4\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

