/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.marketing.strategy.local.modify.listener;

import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.service.MarketingStrategyModifyService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.enums.MarketingStrategyModifyMqTagEnum;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MarketingStrategyModifyCompleteListener
implements ProcessCompleteListener {
    private static final Logger log = LoggerFactory.getLogger(MarketingStrategyModifyCompleteListener.class);
    @Autowired(required=false)
    private MarketingStrategyModifyService marketingStrategyModifyService;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;

    public String getBusinessCode() {
        return "marketing_strategy_modify";
    }

    public void onProcessComplete(ProcessStatusDto dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getBusinessNo())) {
            return;
        }
        String processStatus = dto.getProcessStatus();
        Validate.notEmpty((CharSequence)dto.getProcessNo(), (String)"\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            this.marketingStrategyModifyService.processPass(dto);
            this.passPushMq(dto.getProcessNo(), dto.getBusinessNo());
        }
        if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus) || ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            this.marketingStrategyModifyService.processRejectAndRecover(dto);
        }
    }

    private void passPushMq(String processNo, String businessNo) {
        if (StringUtils.isEmpty((CharSequence)businessNo)) {
            return;
        }
        ArrayList pushTagList = Lists.newArrayList();
        for (MarketingStrategyModifyMqTagEnum mqTagEnum : MarketingStrategyModifyMqTagEnum.values()) {
            if (!MarketingStrategyModifyMqTagEnum.PushType.code.equals((Object)mqTagEnum.getPushType())) continue;
            pushTagList.add(mqTagEnum);
        }
        if (CollectionUtils.isEmpty((Collection)pushTagList)) {
            return;
        }
        for (MarketingStrategyModifyMqTagEnum mqTagEnum : pushTagList) {
            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setMsgBody(businessNo);
            mqMessageVo.setTopic("TPM_MARKETING_STRATEGY_MODIFY_PROCESS_PASS_TOPIC" + RocketMqUtil.mqEnvironment());
            mqMessageVo.setTag(mqTagEnum.getCode());
            this.rocketMqProducer.sendMqMsg(mqMessageVo);
        }
    }
}

