/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.marketing.strategy.local.modify.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.entity.MarketingStrategyBudgetModify;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.mapper.MarketingStrategyBudgetModifyMapper;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyBudgetModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyItemModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MarketingStrategyBudgetModifyRepository
extends ServiceImpl<MarketingStrategyBudgetModifyMapper, MarketingStrategyBudgetModify> {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public void fillVoListProperties(List<MarketingStrategyBudgetVo> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(MarketingStrategyBudgetVo.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        for (MarketingStrategyBudgetVo item : voList) {
            this.fillVoProperties(item, propertyMap);
        }
    }

    public void fillVoProperties(MarketingStrategyBudgetVo item) {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(MarketingStrategyBudgetVo.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        this.fillVoProperties(item, propertyMap);
    }

    public void fillVoProperties(MarketingStrategyBudgetVo item, Map<String, PropertyDescriptor> propertyMap) {
        if (null == item) {
            return;
        }
        ObjectConvertStringUtil.fillObjectStrProperties((Object)item, MarketingStrategyBudgetVo.class, propertyMap);
        BigDecimal useAmount = Optional.ofNullable(item.getUseAmount()).orElse(BigDecimal.ZERO);
        BigDecimal usedAmount = Optional.ofNullable(item.getUsedAmount()).orElse(BigDecimal.ZERO);
        item.setUsedAmount(usedAmount);
        item.setUsableAmount(useAmount.subtract(usedAmount));
    }

    public List<MarketingStrategyBudgetModifyDto> findDtoListByModifyBusinessCode(String modifyBusinessCode) {
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isBlank((CharSequence)modifyBusinessCode)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(MarketingStrategyBudgetModify.class).eq(MarketingStrategyBudgetModify::getModifyBusinessCode, (Object)modifyBusinessCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        List list = this.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        List dtoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, MarketingStrategyBudgetModify.class, MarketingStrategyBudgetModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
        return dtoList;
    }

    public List<MarketingStrategyBudgetModifyDto> listByStrategyItem(MarketingStrategyItemModifyDto dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getModifyBusinessCode())) {
            return null;
        }
        return ((MarketingStrategyBudgetModifyMapper)this.baseMapper).listDtoList(dto);
    }

    public List<MarketingStrategyBudgetModifyDto> listByModifyBusinessCode(String modifyBusinessCode) {
        if (StringUtils.isEmpty((CharSequence)modifyBusinessCode)) {
            return null;
        }
        MarketingStrategyItemModifyDto itemDto = new MarketingStrategyItemModifyDto();
        itemDto.setModifyBusinessCode(modifyBusinessCode);
        return this.listByStrategyItem(itemDto);
    }

    public List<MarketingStrategyBudgetModify> listByModifyBusinessCodeList(List<String> modifyBusinessCodeList) {
        if (CollectionUtils.isEmpty(modifyBusinessCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MarketingStrategyBudgetModify::getModifyBusinessCode, modifyBusinessCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void deleteByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(UuidEntity::getId, ids);
        this.update((Wrapper)updateWrapper);
    }

    public void deleteByModifyBusinessCodes(List<String> modifyBusinessCodeList) {
        if (CollectionUtils.isEmpty(modifyBusinessCodeList)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.in(MarketingStrategyBudgetModify::getModifyBusinessCode, modifyBusinessCodeList);
        updateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        this.remove((Wrapper)updateWrapper);
    }
}

