/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.marketing.strategy.local.modify.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.util.NumberStringDealUtil;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.entity.MarketingStrategyItemModify;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.mapper.MarketingStrategyItemModifyMapper;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.repository.MarketingStrategyBudgetModifyRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.repository.MarketingStrategyItemRepository;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyBudgetModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyItemModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyToModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.vo.MarketingStrategyItemModifyVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.pojo.MarketingStrategyBudgetBase;
import com.biz.crm.tpm.business.marketing.strategy.sdk.pojo.MarketingStrategyItemBase;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MarketingStrategyItemModifyRepository
extends ServiceImpl<MarketingStrategyItemModifyMapper, MarketingStrategyItemModify> {
    @Autowired(required=false)
    private MarketingStrategyItemModifyMapper marketingStrategyItemModifyMapper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private MarketingStrategyBudgetModifyRepository marketingStrategyBudgetModifyRepository;
    @Autowired(required=false)
    private MarketingStrategyItemRepository marketingStrategyItemRepository;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    public List<MarketingStrategyItemModifyDto> findToModifyList(MarketingStrategyToModifyDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<MarketingStrategyItemModifyDto> toModifyList = this.marketingStrategyItemModifyMapper.findToModifyList(dto);
        for (MarketingStrategyItemModifyDto marketingStrategyItemModifyDto : toModifyList) {
            marketingStrategyItemModifyDto.setId(UUID.randomUUID().toString().replace("-", ""));
        }
        this.fillDtoListProperties(toModifyList);
        return toModifyList;
    }

    public List<MarketingStrategyItemModifyDto> findDtoListByModifyCode(String strategyCode) {
        if (StringUtils.isBlank((CharSequence)strategyCode)) {
            return null;
        }
        List<MarketingStrategyItemModify> list = this.findListByModifyCode(strategyCode);
        List dtoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, MarketingStrategyItemModify.class, MarketingStrategyItemModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.fillDtoListProperties(dtoList);
        return dtoList;
    }

    public List<MarketingStrategyItemModify> findListByModifyCode(String modifyCode) {
        if (StringUtils.isBlank((CharSequence)modifyCode)) {
            return null;
        }
        MarketingStrategyItemModifyDto dto = new MarketingStrategyItemModifyDto();
        dto.setModifyBusinessCode(modifyCode);
        return this.findList(dto);
    }

    public List<MarketingStrategyItemModifyDto> findListByModifyBusinessCode(String modifyBusinessCode) {
        if (StringUtils.isBlank((CharSequence)modifyBusinessCode)) {
            return null;
        }
        return this.marketingStrategyItemModifyMapper.findListByModifyBusinessCode(modifyBusinessCode);
    }

    public List<MarketingStrategyItemModify> findList(MarketingStrategyItemModifyDto dto) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(MarketingStrategyItemModify.class).eq(StringUtils.isNotBlank((CharSequence)dto.getModifyBusinessCode()), MarketingStrategyItemModify::getModifyBusinessCode, (Object)dto.getModifyBusinessCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        return this.list((Wrapper)wrapper);
    }

    public void deleteByIds(ArrayList<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(UuidEntity::getId, ids);
        updateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        this.remove((Wrapper)updateWrapper);
    }

    public void deleteByModifyCodes(List<String> modifyCodes) {
        if (CollectionUtils.isEmpty(modifyCodes)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(MarketingStrategyItemModify::getModifyBusinessCode, modifyCodes);
        updateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        this.update((Wrapper)updateWrapper);
    }

    public Page<MarketingStrategyItemModifyVo> findByConditions(Pageable pageable, MarketingStrategyItemModifyDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<MarketingStrategyItemModifyVo> pageList = this.marketingStrategyItemModifyMapper.findByConditions((Page<MarketingStrategyItemModifyVo>)page, dto);
        this.fillVoListProperties(pageList.getRecords());
        return pageList;
    }

    public Page<MarketingStrategyItemModifyVo> findItemBeforeModifyList(Pageable pageable, MarketingStrategyItemModifyDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<MarketingStrategyItemModifyVo> pageList = this.marketingStrategyItemModifyMapper.findItemBeforeModifyList((Page<MarketingStrategyItemModifyVo>)page, dto);
        this.fillVoListProperties(pageList.getRecords());
        return pageList;
    }

    public List<MarketingStrategyItemModifyDto> findDtoAndAttachList(MarketingStrategyItemModifyDto dto) {
        List<MarketingStrategyItemModifyDto> dtoList = this.findDtoListByModifyCode(dto.getModifyBusinessCode());
        if (CollectionUtils.isEmpty(dtoList)) {
            return Lists.newArrayList();
        }
        List<MarketingStrategyBudgetModifyDto> budgetList = this.marketingStrategyBudgetModifyRepository.listByModifyBusinessCode(dto.getModifyBusinessCode());
        if (!CollectionUtils.isEmpty(budgetList)) {
            this.convertMonthBudgetProperty(budgetList);
            for (MarketingStrategyBudgetModifyDto budgetDto : budgetList) {
                NumberStringDealUtil.setStringIfNotNull((Object)budgetDto.getUseAmount(), arg_0 -> ((MarketingStrategyBudgetModifyDto)budgetDto).setUseAmountStr(arg_0));
                BigDecimal afterFreezeAmount = Optional.ofNullable(budgetDto.getAfterFreezeAmount()).orElse(BigDecimal.ZERO);
                BigDecimal usedStrategyAmount = Optional.ofNullable(budgetDto.getUsedStrategyAmount()).orElse(BigDecimal.ZERO);
                BigDecimal usableStrategyAmount = afterFreezeAmount.subtract(usedStrategyAmount);
                budgetDto.setUsableStrategyAmount(usableStrategyAmount);
            }
            Map<String, List<MarketingStrategyBudgetModifyDto>> budgetMap = budgetList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getStrategyItemCode())).collect(Collectors.groupingBy(MarketingStrategyBudgetBase::getStrategyItemCode));
            for (MarketingStrategyItemModifyDto marketingStrategyItemDto : dtoList) {
                if (!budgetMap.containsKey(marketingStrategyItemDto.getStrategyItemCode())) continue;
                marketingStrategyItemDto.setBudgetShares(budgetMap.get(marketingStrategyItemDto.getStrategyItemCode()));
            }
        }
        return dtoList;
    }

    public void convertMonthBudgetProperty(List<MarketingStrategyBudgetModifyDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<Object, Object> feeSourceMap = Maps.newHashMap();
        if (null != this.dictDataVoService) {
            try {
                List feeSourceList = this.dictDataVoService.findByDictTypeCode("tpm_fee_belong_us");
                if (!CollectionUtils.isEmpty((Collection)feeSourceList)) {
                    feeSourceMap = feeSourceList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (o, n) -> o));
                }
            }
            catch (Exception e) {
                this.log.error("\u8d39\u7528\u5f52\u53e3\u6570\u636e\u5b57\u5178\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        for (MarketingStrategyBudgetModifyDto vo : list) {
            if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)vo.getFeeBelongCode())) continue;
            vo.setFeeSourceName(feeSourceMap.getOrDefault(vo.getFeeBelongCode(), vo.getFeeBelongCode()));
        }
    }

    public void fillVoListProperties(List<MarketingStrategyItemModifyVo> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        List strategyItemCodeList = voList.stream().map(MarketingStrategyItemBase::getStrategyItemCode).collect(Collectors.toList());
        MarketingStrategyItemDto itemSearchDto = new MarketingStrategyItemDto();
        itemSearchDto.setStrategyItemCodeList(strategyItemCodeList);
        List<MarketingStrategyItemDto> itemDtoList = this.marketingStrategyItemRepository.findDtoAndAttachList(itemSearchDto);
        Map originMap = itemDtoList.stream().collect(Collectors.toMap(MarketingStrategyItemBase::getStrategyItemCode, Function.identity(), (o, n) -> n));
        for (MarketingStrategyItemModifyVo modifyItemDto : voList) {
            MarketingStrategyItemModify modifyItem = (MarketingStrategyItemModify)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)modifyItemDto, MarketingStrategyItemModify.class, HashSet.class, ArrayList.class, new String[0]));
            MarketingStrategyItemDto originItem = (MarketingStrategyItemDto)originMap.get(modifyItem.getStrategyItemCode());
            BeanUtils.copyProperties((Object)originItem, (Object)modifyItemDto);
            BeanUtils.copyProperties((Object)((Object)modifyItem), (Object)modifyItemDto);
        }
        for (MarketingStrategyItemModifyVo item : voList) {
            this.fillVoProperties(item);
        }
    }

    public void fillVoProperties(MarketingStrategyItemModifyVo item) {
        if (null == item) {
            return;
        }
        ObjectConvertStringUtil.fillObjectStrProperties((Object)item, MarketingStrategyItemModifyVo.class);
        item.setActivityType(item.getActivityTypeCode());
        item.setActivityForm(item.getActivityFormCode());
    }

    public void fillDtoListProperties(List<? extends MarketingStrategyItemModifyDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        List strategyItemCodeList = dtoList.stream().map(MarketingStrategyItemBase::getStrategyItemCode).collect(Collectors.toList());
        MarketingStrategyItemDto itemSearchDto = new MarketingStrategyItemDto();
        itemSearchDto.setStrategyItemCodeList(strategyItemCodeList);
        List<MarketingStrategyItemDto> itemDtoList = this.marketingStrategyItemRepository.findDtoAndAttachList(itemSearchDto);
        Map originMap = itemDtoList.stream().collect(Collectors.toMap(MarketingStrategyItemBase::getStrategyItemCode, Function.identity(), (o, n) -> n));
        for (MarketingStrategyItemModifyDto marketingStrategyItemModifyDto : dtoList) {
            String attrOrgCode = marketingStrategyItemModifyDto.getAttrOrgCode();
            String attrOrgName = marketingStrategyItemModifyDto.getAttrOrgName();
            MarketingStrategyItemModify modifyItem = (MarketingStrategyItemModify)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)marketingStrategyItemModifyDto, MarketingStrategyItemModify.class, HashSet.class, ArrayList.class, new String[0]));
            MarketingStrategyItemDto originItem = (MarketingStrategyItemDto)originMap.get(modifyItem.getStrategyItemCode());
            BeanUtils.copyProperties((Object)originItem, (Object)marketingStrategyItemModifyDto);
            BeanUtils.copyProperties((Object)((Object)modifyItem), (Object)marketingStrategyItemModifyDto);
            marketingStrategyItemModifyDto.setAttrOrgCode(attrOrgCode);
            marketingStrategyItemModifyDto.setAttrOrgName(attrOrgName);
        }
        for (MarketingStrategyItemModifyDto marketingStrategyItemModifyDto : dtoList) {
            this.fillDtoProperties(marketingStrategyItemModifyDto);
        }
    }

    public void fillDtoProperties(MarketingStrategyItemModifyDto item) {
        if (null == item) {
            return;
        }
        ObjectConvertStringUtil.fillObjectStrProperties((Object)item, MarketingStrategyItemModifyDto.class);
        item.setActivityType(item.getActivityTypeCode());
        item.setActivityForm(item.getActivityFormCode());
    }
}

