/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.marketing.strategy.local.modify.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.entity.MarketingStrategyModifyAdjustBudget;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.mapper.MarketingStrategyModifyAdjustBudgetMapper;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyModifyAdjustBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.vo.MarketingStrategyModifyAdjustBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MarketingStrategyModifyAdjustBudgetRepository
extends ServiceImpl<MarketingStrategyModifyAdjustBudgetMapper, MarketingStrategyModifyAdjustBudget> {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public List<MarketingStrategyModifyAdjustBudgetDto> findDtoListByModifyCode(String strategyCode) {
        if (StringUtils.isBlank((CharSequence)strategyCode)) {
            return null;
        }
        List<MarketingStrategyModifyAdjustBudget> list = this.findListByModifyCode(strategyCode);
        List dtoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, MarketingStrategyModifyAdjustBudget.class, MarketingStrategyModifyAdjustBudgetDto.class, HashSet.class, ArrayList.class, new String[0]);
        return dtoList;
    }

    public List<MarketingStrategyModifyAdjustBudgetVo> findVoListByModifyCode(String strategyCode) {
        if (StringUtils.isBlank((CharSequence)strategyCode)) {
            return null;
        }
        List<MarketingStrategyModifyAdjustBudget> list = this.findListByModifyCode(strategyCode);
        List dtoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, MarketingStrategyModifyAdjustBudget.class, MarketingStrategyModifyAdjustBudgetVo.class, HashSet.class, ArrayList.class, new String[0]);
        return dtoList;
    }

    public List<MarketingStrategyModifyAdjustBudgetVo> findVoListByModifyCodeList(List<String> strategyCodeList) {
        if (CollectionUtils.isEmpty(strategyCodeList)) {
            return null;
        }
        List<MarketingStrategyModifyAdjustBudget> list = this.findListByModifyCodeList(strategyCodeList);
        List dtoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, MarketingStrategyModifyAdjustBudget.class, MarketingStrategyModifyAdjustBudgetVo.class, HashSet.class, ArrayList.class, new String[0]);
        return dtoList;
    }

    public List<MarketingStrategyModifyAdjustBudget> findListByModifyCode(String modifyCode) {
        if (StringUtils.isBlank((CharSequence)modifyCode)) {
            return null;
        }
        MarketingStrategyModifyAdjustBudgetDto dto = new MarketingStrategyModifyAdjustBudgetDto();
        dto.setModifyBusinessCode(modifyCode);
        return this.findList(dto);
    }

    public List<MarketingStrategyModifyAdjustBudget> findListByModifyCodeList(List<String> modifyCodeList) {
        if (CollectionUtils.isEmpty(modifyCodeList)) {
            return null;
        }
        MarketingStrategyModifyAdjustBudgetDto dto = new MarketingStrategyModifyAdjustBudgetDto();
        dto.setModifyBusinessCodeList(modifyCodeList);
        return this.findList(dto);
    }

    public List<MarketingStrategyModifyAdjustBudget> findList(MarketingStrategyModifyAdjustBudgetDto dto) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(MarketingStrategyModifyAdjustBudget.class).eq(StringUtils.isNotBlank((CharSequence)dto.getModifyBusinessCode()), MarketingStrategyModifyAdjustBudget::getModifyBusinessCode, (Object)dto.getModifyBusinessCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        if (!CollectionUtils.isEmpty((Collection)dto.getModifyBusinessCodeList())) {
            wrapper.in(MarketingStrategyModifyAdjustBudget::getModifyBusinessCode, (Collection)dto.getModifyBusinessCodeList());
        }
        return this.list((Wrapper)wrapper);
    }

    public void deleteByModifyBusinessCodes(ArrayList<String> modifyBusinessCodeList) {
        if (CollectionUtils.isEmpty(modifyBusinessCodeList)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.in(MarketingStrategyModifyAdjustBudget::getModifyBusinessCode, modifyBusinessCodeList);
        updateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        this.remove((Wrapper)updateWrapper);
    }
}

