/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.marketing.strategy.local.modify.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.entity.MarketingStrategyBudgetModify;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.entity.MarketingStrategyModify;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.repository.MarketingStrategyBudgetModifyRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.service.MarketingStrategyBudgetModifyService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyBudgetModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyItemModifyDto;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MarketingStrategyBudgetModifyServiceImpl
implements MarketingStrategyBudgetModifyService {
    @Autowired(required=false)
    private MarketingStrategyBudgetModifyRepository marketingStrategyBudgetModifyRepository;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveMarketingStrategyBudgetList(MarketingStrategyModify entity, boolean update, List<MarketingStrategyItemModifyDto> itemDtoList) {
        if (update) {
            this.marketingStrategyBudgetModifyRepository.deleteByModifyBusinessCodes(Lists.newArrayList((Object[])new String[]{entity.getModifyBusinessCode()}));
        }
        ArrayList list = Lists.newArrayList();
        for (MarketingStrategyItemModifyDto itemDto : itemDtoList) {
            ArrayList budgetList = Lists.newArrayList();
            List budgetShares = itemDto.getBudgetShares();
            if (!CollectionUtils.isEmpty((Collection)budgetShares)) {
                Collection budgetShareEntityList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)budgetShares, MarketingStrategyBudgetModifyDto.class, MarketingStrategyBudgetModify.class, HashSet.class, ArrayList.class, new String[0]);
                for (MarketingStrategyBudgetModify monthBudget : budgetShareEntityList) {
                    monthBudget.setModifyBusinessCode(entity.getModifyBusinessCode());
                    monthBudget.setStrategyCode(itemDto.getStrategyCode());
                    monthBudget.setStrategyItemCode(itemDto.getStrategyItemCode());
                }
                budgetList.addAll(budgetShareEntityList);
            }
            list.addAll(budgetList);
        }
        ArrayList saveList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        for (MarketingStrategyBudgetModify item : list) {
            String key = item.getStrategyItemCode() + item.getMonthBudgetCode();
            item.setModifyBusinessCode(entity.getModifyBusinessCode());
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item.setTenantCode(entity.getTenantCode());
            item.setId(null);
            saveList.add(item);
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            this.marketingStrategyBudgetModifyRepository.saveBatch(saveList);
        }
    }

    @Override
    public void deleteByModifyBusinessCodes(List<String> modifyBusinessCodeList) {
        this.marketingStrategyBudgetModifyRepository.deleteByModifyBusinessCodes(modifyBusinessCodeList);
    }
}

