/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.marketing.strategy.local.modify.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateStringDealUtil;
import com.biz.crm.mn.common.base.util.NumberStringDealUtil;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategyBudget;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategyItem;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.entity.MarketingStrategyBudgetModify;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.entity.MarketingStrategyItemModify;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.entity.MarketingStrategyModify;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.entity.MarketingStrategyModifyAdjustBudget;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.repository.MarketingStrategyBudgetModifyRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.repository.MarketingStrategyItemModifyRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.repository.MarketingStrategyModifyAdjustBudgetRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.service.MarketingStrategyItemModifyService;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.service.internal.MarketingStrategyModifyPageCacheHelper;
import com.biz.crm.tpm.business.marketing.strategy.local.repository.MarketingStrategyBudgetRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.repository.MarketingStrategyItemRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.repository.MarketingStrategyRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.vo.MarketingStrategyBudgetSumVo;
import com.biz.crm.tpm.business.marketing.strategy.local.vo.MarketingStrategyModifyFieldValue;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyBudgetModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyItemModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyModifyAdjustBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyToModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.vo.MarketingStrategyItemModifyVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.vo.MarketingStrategyModifyAdjustBudgetVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.pojo.MarketingStrategyBudgetBase;
import com.biz.crm.tpm.business.marketing.strategy.sdk.pojo.MarketingStrategyItemBase;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessMappingDto;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MarketingStrategyItemModifyServiceImpl
extends MnPageCacheServiceImpl<MarketingStrategyItemModifyVo, MarketingStrategyItemModifyDto>
implements MarketingStrategyItemModifyService {
    private static final Logger log = LoggerFactory.getLogger(MarketingStrategyItemModifyServiceImpl.class);
    @Autowired(required=false)
    private MarketingStrategyItemModifyRepository marketingStrategyItemModifyRepository;
    @Autowired(required=false)
    private MarketingStrategyItemRepository marketingStrategyItemRepository;
    @Autowired(required=false)
    private MarketingStrategyRepository marketingStrategyRepository;
    @Autowired(required=false)
    private MarketingStrategyBudgetRepository marketingStrategyBudgetRepository;
    @Autowired(required=false)
    private MarketingStrategyBudgetModifyRepository marketingStrategyBudgetModifyRepository;
    @Autowired(required=false)
    private MarketingStrategyModifyAdjustBudgetRepository marketingStrategyModifyAdjustBudgetRepository;
    @Autowired(required=false)
    private MarketingStrategyModifyPageCacheHelper pageCacheHelper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private BudgetItemService budgetItemService;
    @Autowired(required=false)
    private ProcessBusinessMappingService processBusinessMappingService;

    @Override
    public Page<MarketingStrategyItemModifyVo> findByConditions(Pageable pageable, MarketingStrategyItemModifyDto dto) {
        return this.marketingStrategyItemModifyRepository.findByConditions(pageable, dto);
    }

    @Override
    public void deleteByModifyCodes(List<String> modifyCodes) {
        if (CollectionUtils.isEmpty(modifyCodes)) {
            return;
        }
        this.marketingStrategyItemModifyRepository.deleteByModifyCodes(modifyCodes);
    }

    @Override
    public Page<MarketingStrategyItemModifyVo> findItemBeforeModifyList(Pageable pageable, MarketingStrategyItemModifyDto dto) {
        return this.marketingStrategyItemModifyRepository.findItemBeforeModifyList(pageable, dto);
    }

    @Override
    public void saveMarketingStrategyModifyItemList(MarketingStrategyModify entity, boolean update, List<MarketingStrategyItemModifyDto> itemList) {
        this.saveMarketingStrategyModifyItemList(entity, update, itemList, true);
    }

    @Override
    public void saveMarketingStrategyModifyItemList(MarketingStrategyModify entity, boolean update, List<MarketingStrategyItemModifyDto> itemList, boolean validate) {
        if (validate) {
            MarketingStrategyModifyDto dto = new MarketingStrategyModifyDto();
            dto.setBusinessUnitCode(entity.getBusinessUnitCode());
            this.createValidateList(dto, itemList);
        }
        this.backupInitVersionData(itemList);
        List marketingStrategyItems = (List)this.nebulaToolkitService.copyCollectionByBlankList(itemList, MarketingStrategyItemModifyDto.class, MarketingStrategyItemModify.class, HashSet.class, ArrayList.class, new String[0]);
        Map<Object, Object> oldMap = Maps.newHashMap();
        if (update) {
            List<MarketingStrategyItemModify> oldList = this.marketingStrategyItemModifyRepository.findListByModifyCode(entity.getModifyBusinessCode());
            oldMap = oldList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
        }
        ArrayList saveList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        for (MarketingStrategyItemModify item : marketingStrategyItems) {
            if (oldMap.containsKey(item.getId())) {
                updateList.add(item);
                oldMap.remove(item.getId());
                continue;
            }
            item.setModifyBusinessCode(entity.getModifyBusinessCode());
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item.setTenantCode(entity.getTenantCode());
            item.setId(null);
            saveList.add(item);
        }
        if (oldMap.size() > 0) {
            this.marketingStrategyItemModifyRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            this.marketingStrategyItemModifyRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty((Collection)updateList)) {
            this.marketingStrategyItemModifyRepository.updateBatchById(updateList);
        }
    }

    private void backupInitVersionData(List<MarketingStrategyItemModifyDto> itemList) {
        List itemCodeList = itemList.stream().map(MarketingStrategyItemBase::getStrategyItemCode).collect(Collectors.toList());
        List noModifyList = this.marketingStrategyItemRepository.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(MarketingStrategyItem::getStrategyItemCode, itemCodeList)).and(w -> {
            w.eq(MarketingStrategyItem::getHasModify, (Object)BooleanEnum.FALSE.getCapital());
            w.or();
            w.isNull(MarketingStrategyItem::getHasModify);
        }));
        if (CollectionUtils.isEmpty((Collection)noModifyList)) {
            return;
        }
        List entityList = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)noModifyList, MarketingStrategyItem.class, MarketingStrategyItemModify.class, HashSet.class, ArrayList.class, new String[0]);
        this.marketingStrategyItemModifyRepository.saveBatch(entityList);
        List noModifyCodeList = noModifyList.stream().map(MarketingStrategyItem::getStrategyItemCode).collect(Collectors.toList());
        this.marketingStrategyItemRepository.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(MarketingStrategyItem::getHasModify, (Object)BooleanEnum.TRUE.getCapital())).in(MarketingStrategyItem::getStrategyItemCode, noModifyCodeList));
        List budgetList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.marketingStrategyBudgetRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(MarketingStrategyBudget::getStrategyItemCode, noModifyCodeList)).list();
        if (!CollectionUtils.isEmpty((Collection)budgetList)) {
            List budgetModifyList = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)budgetList, MarketingStrategyBudget.class, MarketingStrategyBudgetModify.class, HashSet.class, ArrayList.class, new String[0]);
            this.marketingStrategyBudgetModifyRepository.saveBatch(budgetModifyList);
        }
    }

    @Override
    public void createValidateList(MarketingStrategyModifyDto dto, List<MarketingStrategyItemModifyDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        for (MarketingStrategyItemModifyDto item : dtoList) {
            this.createValidate(item);
        }
        if (!BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
            for (MarketingStrategyItemModifyDto item : dtoList) {
                DateStringDealUtil.validateDateStrAndSet((String)item.getBeginDateStr(), (String)"\u65b0\u589e\u65f6\uff0c\u7b56\u7565\u660e\u7ec6\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (boolean)true, (String)"yyyy-MM-dd", arg_0 -> ((MarketingStrategyItemModifyDto)item).setBeginDate(arg_0));
                DateStringDealUtil.validateDateStrAndSet((String)item.getEndDateStr(), (String)"\u65b0\u589e\u65f6\uff0c\u7b56\u7565\u660e\u7ec6\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (boolean)true, (String)"yyyy-MM-dd", arg_0 -> ((MarketingStrategyItemModifyDto)item).setEndDate(arg_0));
                Validate.notBlank((CharSequence)item.getBudgetItemCode(), (String)"\u65b0\u589e\u65f6\uff0c\u7b56\u7565\u9884\u7b97\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            List budgetItemCodeList = dtoList.stream().map(MarketingStrategyItemBase::getBudgetItemCode).distinct().collect(Collectors.toList());
            List budgetItemVos = this.budgetItemService.listByCodes(budgetItemCodeList);
            if (CollectionUtils.isEmpty((Collection)budgetItemVos)) {
                throw new RuntimeException("\u9884\u7b97\u9879\u76ee\u67e5\u8be2\u5931\u8d25\uff01");
            }
            Map budgetItemMap = budgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity()));
            Calendar calendar = Calendar.getInstance();
            for (MarketingStrategyItemModifyDto item : dtoList) {
                String allowAcrossMonth = BooleanEnum.FALSE.getCapital();
                BudgetItemVo budgetItemVo = (BudgetItemVo)budgetItemMap.get(item.getBudgetItemCode());
                if (null == budgetItemVo) {
                    throw new RuntimeException("\u9884\u7b97\u9879\u76ee[" + item.getBudgetItemCode() + "]\u6709\u8bef\uff01");
                }
                if (StringUtils.isNotEmpty((CharSequence)budgetItemVo.getAllowCrossMonth())) {
                    allowAcrossMonth = budgetItemVo.getAllowCrossMonth();
                }
                if (!BooleanEnum.FALSE.getCapital().equals(allowAcrossMonth)) continue;
                int year = Integer.parseInt(item.getStrategyYearMonth().substring(0, 4));
                int month = Integer.parseInt(item.getStrategyYearMonth().substring(5)) - 1;
                calendar.setTime(item.getBeginDate());
                if (calendar.get(1) != year || calendar.get(2) != month) {
                    throw new RuntimeException("\u9884\u7b97\u9879\u76ee[" + item.getBudgetItemCode() + "]\u4e0d\u5141\u8bb8\u8de8\u6708\u4f7f\u7528\uff0c\u8bf7\u4fee\u6539\u7b56\u7565\u5f00\u59cb\u65f6\u95f4\u3001\u7b56\u7565\u7ed3\u675f\u65f6\u95f4\uff01");
                }
                calendar.setTime(item.getEndDate());
                if (calendar.get(1) == year && calendar.get(2) == month) continue;
                throw new RuntimeException("\u9884\u7b97\u9879\u76ee[" + item.getBudgetItemCode() + "]\u4e0d\u5141\u8bb8\u8de8\u6708\u4f7f\u7528\uff0c\u8bf7\u4fee\u6539\u7b56\u7565\u5f00\u59cb\u65f6\u95f4\u3001\u7b56\u7565\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            if (!CollectionUtils.isEmpty((Collection)dto.getAdjustBudgetList())) {
                for (MarketingStrategyModifyAdjustBudgetDto adjustBudgetDto : dto.getAdjustBudgetList()) {
                    Validate.notBlank((CharSequence)adjustBudgetDto.getMonthBudgetCode(), (String)"\u8c03\u5165\u65b9\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notBlank((CharSequence)adjustBudgetDto.getAdjustOutMonthBudgetCode(), (String)"\u8c03\u51fa\u65b9\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.isTrue((!adjustBudgetDto.getMonthBudgetCode().equals(adjustBudgetDto.getAdjustOutMonthBudgetCode()) ? 1 : 0) != 0, (String)"\u8c03\u5165\u65b9\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e0e\u8c03\u51fa\u65b9\u9884\u7b97\u7f16\u7801\u76f8\u540c", (Object[])new Object[0]);
                }
            }
        }
    }

    @Override
    public void createValidate(MarketingStrategyItemModifyDto dto) {
        Validate.notBlank((CharSequence)dto.getActivityTypeCode(), (String)"\u7b56\u7565\u660e\u7ec6\u6d3b\u52a8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getStrategyOrgCode(), (String)"\u7b56\u7565\u660e\u7ec6\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        NumberStringDealUtil.validateNumberStrAndSet((String)dto.getActivityNumberStr(), (String)"\u7b56\u7565\u660e\u7ec6\u6d3b\u52a8\u573a\u6b21", (boolean)false, arg_0 -> ((MarketingStrategyItemModifyDto)dto).setActivityNumber(arg_0), Integer.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)dto.getQuantityStr(), (String)"\u7b56\u7565\u660e\u7ec6\u6570\u91cf", (boolean)false, arg_0 -> ((MarketingStrategyItemModifyDto)dto).setQuantity(arg_0), Integer.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)dto.getFeeAmountStr(), (String)"\u7b56\u7565\u660e\u7ec6\u8d39\u7528\u91d1\u989d", (boolean)true, arg_0 -> ((MarketingStrategyItemModifyDto)dto).setFeeAmount(arg_0), BigDecimal.class);
    }

    @Override
    public void initToModifyList(String cacheKey, MarketingStrategyToModifyDto dto) {
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)dto.getStrategyCode()) && StringUtils.isEmpty((CharSequence)dto.getStrategyItemCode())) {
            Validate.notBlank((CharSequence)dto.getAttrOrgCode(), (String)"\u5f52\u5c5e\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dto.getBudgetItemCode(), (String)"\u9884\u7b97\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dto.getStrategyYearMonth(), (String)"\u7b56\u7565\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getBudgetItemCode())) {
            dto.setBudgetItemCodeList(Arrays.asList(dto.getBudgetItemCode().split(",")));
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getStrategyCode())) {
            dto.setStrategyCodeList(Arrays.asList(dto.getStrategyCode().split(",")));
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getStrategyItemCode())) {
            dto.setStrategyItemCodeList(Arrays.asList(dto.getStrategyItemCode().split(",")));
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getStrategyYearMonth())) {
            dto.setStrategyYearMonthList(Arrays.asList(dto.getStrategyYearMonth().split(",")));
        }
        List<MarketingStrategyItemModifyDto> toModifyList = this.marketingStrategyItemModifyRepository.findToModifyList(dto);
        this.clearCache(cacheKey);
        if (!CollectionUtils.isEmpty(toModifyList)) {
            this.pageCacheHelper.putCache(cacheKey, toModifyList);
        }
    }

    @Override
    public List<MarketingStrategyBudgetSumVo> findBudgetCacheSumList(String cacheKey) {
        List itemList = super.findCacheList(cacheKey);
        HashMap budgetSumVoMap = Maps.newHashMap();
        HashSet feeBudgetCodeSet = Sets.newHashSet();
        for (MarketingStrategyItemModifyDto item2 : itemList) {
            if (StringUtils.isEmpty((CharSequence)item2.getMonthBudgetCode())) continue;
            MarketingStrategyBudgetSumVo budgetSumVo = budgetSumVoMap.computeIfAbsent(item2.getMonthBudgetCode(), key -> new MarketingStrategyBudgetSumVo(){
                {
                    this.setTotalStrategyAmount(BigDecimal.ZERO);
                    this.setInitResolveAmount(BigDecimal.ZERO);
                    this.setUsedStrategyAmount(BigDecimal.ZERO);
                    this.setCanApplyStrategyAmount(BigDecimal.ZERO);
                }
            });
            budgetSumVo.setMonthBudgetCode(item2.getMonthBudgetCode());
            budgetSumVo.setBudgetItemName(item2.getBudgetItemName());
            if (null != item2.getFeeAmount()) {
                budgetSumVo.setTotalStrategyAmount(budgetSumVo.getTotalStrategyAmount().add(item2.getFeeAmount()));
            }
            feeBudgetCodeSet.add(item2.getMonthBudgetCode());
        }
        if (feeBudgetCodeSet.size() > 0) {
            ArrayList feeBudgetCodeList = Lists.newArrayList((Iterable)feeBudgetCodeSet);
            List budgetVos = this.monthBudgetService.findByCodes((List)feeBudgetCodeList, null);
            for (MonthBudgetVo budgetVo : budgetVos) {
                MarketingStrategyBudgetSumVo budgetSumVo = (MarketingStrategyBudgetSumVo)budgetSumVoMap.get(budgetVo.getMonthBudgetCode());
                budgetSumVo.setYearMonthLy(budgetVo.getYearMonthLy());
                budgetSumVo.setBudgetItemCode(budgetVo.getBudgetItemCode());
                budgetSumVo.setBudgetItemName(budgetVo.getBudgetItemName());
                budgetSumVo.setFeeBelongCode(budgetVo.getFeeBelongCode());
                if (null != budgetVo.getInitResolveAmount()) {
                    budgetSumVo.setInitResolveAmount(budgetVo.getInitResolveAmount());
                }
                if (null != budgetVo.getMonthRollingAmount()) {
                    budgetSumVo.setMonthRollingAmount(budgetVo.getMonthRollingAmount());
                }
                if (null != budgetVo.getLastMonthRollingAmount()) {
                    budgetSumVo.setLastMonthRollingAmount(budgetVo.getLastMonthRollingAmount());
                }
                if (null != budgetVo.getAfterFreezeAmount()) {
                    budgetSumVo.setAfterFreezeAmount(budgetVo.getAfterFreezeAmount());
                }
                if (null == budgetVo.getUsedStrategyAmount()) continue;
                budgetSumVo.setUsedStrategyAmount(budgetVo.getUsedStrategyAmount());
            }
        }
        ArrayList<MarketingStrategyBudgetSumVo> budgetSumList = new ArrayList<MarketingStrategyBudgetSumVo>(budgetSumVoMap.values());
        budgetSumList.forEach(item -> item.setCanApplyStrategyAmount(Optional.ofNullable(item.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(item.getUsedStrategyAmount()).orElse(BigDecimal.ZERO))));
        return budgetSumList;
    }

    @Override
    public List<MarketingStrategyModifyFieldValue> findItemModifyLFieldValueListByProcessNo(String processNo) throws IllegalAccessException, InvocationTargetException {
        PageRequest tempPageable = PageRequest.of((int)1, (int)999999);
        List<String> businessNoList = this.findModifyBusinessNoListByProcessNo(processNo);
        MarketingStrategyItemModifyDto marketingStrategyItemModifyDto = new MarketingStrategyItemModifyDto();
        marketingStrategyItemModifyDto.setModifyBusinessCodeList(businessNoList);
        Page<MarketingStrategyItemModifyVo> itemBeforeModifyPage = this.findItemBeforeModifyList((Pageable)tempPageable, marketingStrategyItemModifyDto);
        Page<MarketingStrategyItemModifyVo> itemModifyPage = this.findByConditions((Pageable)tempPageable, marketingStrategyItemModifyDto);
        List itemBeforeModifyList = itemBeforeModifyPage.getRecords();
        List itemModifyList = itemModifyPage.getRecords();
        if (CollectionUtils.isEmpty((Collection)itemBeforeModifyList)) {
            return Lists.newArrayList();
        }
        return this.findItemModifyLFieldValueList(itemModifyList, itemBeforeModifyList);
    }

    private List<String> findModifyBusinessNoListByProcessNo(String processNo) {
        ProcessBusinessMappingDto processBusinessMappingDto = new ProcessBusinessMappingDto();
        processBusinessMappingDto.setProcessNo(processNo);
        List processBusinessMappingVoList = this.processBusinessMappingService.findMultiByByConditions(processBusinessMappingDto);
        if (CollectionUtils.isEmpty((Collection)processBusinessMappingVoList)) {
            throw new RuntimeException("\u6d41\u7a0b\u6570\u636e\u6709\u8bef\uff01");
        }
        return processBusinessMappingVoList.stream().map(ProcessBusinessMappingVo::getBusinessNo).collect(Collectors.toList());
    }

    @Override
    public Page<MarketingStrategyModifyFieldValue> findItemModifyLFieldValueList(Pageable pageable, MarketingStrategyItemModifyDto dto) throws InvocationTargetException, IllegalAccessException {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        page.setTotal(0L);
        page.setRecords((List)Lists.newArrayList());
        PageRequest tempPageable = PageRequest.of((int)1, (int)999999);
        Page<MarketingStrategyItemModifyVo> itemBeforeModifyPage = this.findItemBeforeModifyList((Pageable)tempPageable, dto);
        Page<MarketingStrategyItemModifyVo> itemModifyPage = this.findByConditions((Pageable)tempPageable, dto);
        List itemBeforeModifyList = itemBeforeModifyPage.getRecords();
        List itemModifyList = itemModifyPage.getRecords();
        if (CollectionUtils.isEmpty((Collection)itemBeforeModifyList)) {
            return page;
        }
        List<MarketingStrategyModifyFieldValue> modifyFieldValueList = this.findItemModifyLFieldValueList(itemModifyList, itemBeforeModifyList);
        page.setTotal((long)modifyFieldValueList.size());
        long start = page.offset();
        if (page.getTotal() > start) {
            long end = page.offset() + page.getSize();
            if (page.getTotal() < end) {
                end = page.getTotal();
            }
            List<MarketingStrategyModifyFieldValue> recordList = modifyFieldValueList.subList((int)page.offset(), (int)end);
            page.setRecords(recordList);
        }
        return page;
    }

    public List<MarketingStrategyModifyFieldValue> findItemModifyLFieldValueList(List<MarketingStrategyItemModifyVo> itemModifyList, List<MarketingStrategyItemModifyVo> itemBeforeModifyList) throws InvocationTargetException, IllegalAccessException {
        Map itemModifyMap = itemModifyList.stream().collect(Collectors.toMap(MarketingStrategyItemBase::getStrategyItemCode, Function.identity()));
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(MarketingStrategyItemModifyVo.class);
        Map propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        HashMap modifyFieldMap = Maps.newHashMap();
        modifyFieldMap.put("strategyName", "\u7b56\u7565\u540d\u79f0");
        modifyFieldMap.put("strategyTitle", "\u7b56\u7565\u4e3b\u9898");
        modifyFieldMap.put("strategyDesc", "\u7b56\u7565\u63cf\u8ff0");
        modifyFieldMap.put("strategyOrgCode", "\u533a\u57df\u7f16\u7801");
        modifyFieldMap.put("strategyOrgName", "\u533a\u57df\u540d\u79f0");
        modifyFieldMap.put("beginDateStr", "\u7b56\u7565\u5f00\u59cb\u65f6\u95f4");
        modifyFieldMap.put("endDateStr", "\u7b56\u7565\u7ed3\u675f\u65f6\u95f4");
        modifyFieldMap.put("firstChannelCode", "\u4e00\u7ea7\u7ba1\u7406\u6e20\u9053\u7f16\u7801");
        modifyFieldMap.put("firstChannelName", "\u4e00\u7ea7\u7ba1\u7406\u6e20\u9053\u540d\u79f0");
        modifyFieldMap.put("secondChannelCode", "\u4e8c\u7ea7\u7ba1\u7406\u6e20\u9053\u7f16\u7801");
        modifyFieldMap.put("secondChannelName", "\u4e8c\u7ea7\u7ba1\u7406\u6e20\u9053\u540d\u79f0");
        modifyFieldMap.put("systemCode", "\u7cfb\u7edf/\u96f6\u552e\u5546\u7f16\u7801");
        modifyFieldMap.put("productBrandCode", "\u54c1\u724c\u7f16\u7801");
        modifyFieldMap.put("productBrandName", "\u54c1\u724c\u540d\u79f0");
        modifyFieldMap.put("activityTypeCode", "\u6d3b\u52a8\u7c7b\u578b\u7f16\u7801");
        modifyFieldMap.put("activityTypeName", "\u6d3b\u52a8\u7c7b\u578b\u540d\u79f0");
        modifyFieldMap.put("activityFormCode", "\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801");
        modifyFieldMap.put("activityFormName", "\u6d3b\u52a8\u5f62\u5f0f\u540d\u79f0");
        modifyFieldMap.put("activityIntensity", "\u6d3b\u52a8\u529b\u5ea6");
        modifyFieldMap.put("activityNumber", "\u6d3b\u52a8\u573a\u6b21");
        modifyFieldMap.put("quantity", "\u6570\u91cf");
        modifyFieldMap.put("feeAmount", "\u8d39\u7528\u91d1\u989d\uff08\u5143\uff09");
        modifyFieldMap.put("controlRatio", "\u63a7\u5236\u7cfb\u6570");
        ArrayList modifyFieldValueList = Lists.newArrayList();
        for (MarketingStrategyItemModifyVo itemVo : itemBeforeModifyList) {
            MarketingStrategyItemModifyVo itemModifyVo = (MarketingStrategyItemModifyVo)itemModifyMap.get(itemVo.getStrategyItemCode());
            for (Map.Entry entry : modifyFieldMap.entrySet()) {
                String fieldName = (String)entry.getKey();
                String fieldTitle = (String)entry.getValue();
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)propertyMap.get(fieldName);
                Object beforeFieldValue = propertyDescriptor.getReadMethod().invoke((Object)itemVo, new Object[0]);
                Object fieldValue = propertyDescriptor.getReadMethod().invoke((Object)itemModifyVo, new Object[0]);
                if (null == beforeFieldValue && null == fieldValue) continue;
                MarketingStrategyModifyFieldValue modifyFieldValue = new MarketingStrategyModifyFieldValue();
                modifyFieldValue.setStrategyCode(itemVo.getStrategyCode());
                modifyFieldValue.setStrategyItemCode(itemVo.getStrategyItemCode());
                modifyFieldValue.setFieldName(fieldName);
                modifyFieldValue.setFieldTitle(fieldTitle);
                if (null != beforeFieldValue && null != fieldValue) {
                    BigDecimal fieldValueBigDecimal;
                    BigDecimal beforeFieldValueBigDecimal;
                    Integer fieldValueInt;
                    Integer beforeFieldValueInt;
                    if (beforeFieldValue.equals(fieldValue) || (propertyDescriptor.getPropertyType() == Integer.class ? (beforeFieldValueInt = (Integer)beforeFieldValue).compareTo(fieldValueInt = (Integer)fieldValue) == 0 : propertyDescriptor.getPropertyType() == BigDecimal.class && (beforeFieldValueBigDecimal = (BigDecimal)beforeFieldValue).compareTo(fieldValueBigDecimal = (BigDecimal)fieldValue) == 0)) continue;
                    modifyFieldValue.setBeforeFieldValue(beforeFieldValue.toString());
                    modifyFieldValue.setFieldValue(fieldValue.toString());
                } else if (null != beforeFieldValue) {
                    modifyFieldValue.setBeforeFieldValue(beforeFieldValue.toString());
                } else {
                    modifyFieldValue.setFieldValue(fieldValue.toString());
                }
                modifyFieldValueList.add(modifyFieldValue);
            }
        }
        return modifyFieldValueList;
    }

    @Override
    public List<MarketingStrategyModifyAdjustBudgetVo> findAdjustBudgetVoListByModifyCode(String modifyBusinessCode) {
        return this.marketingStrategyModifyAdjustBudgetRepository.findVoListByModifyCode(modifyBusinessCode);
    }

    @Override
    public List<MarketingStrategyModifyAdjustBudgetVo> findAdjustBudgetVoListByProcessNo(String processNo) {
        List<String> businessNoList = this.findModifyBusinessNoListByProcessNo(processNo);
        if (CollectionUtils.isEmpty(businessNoList)) {
            return Lists.newArrayList();
        }
        return this.marketingStrategyModifyAdjustBudgetRepository.findVoListByModifyCodeList(businessNoList);
    }

    @Override
    public void useMonthBudgetByModifyCode(String modifyCode) {
        List<MarketingStrategyBudgetModifyDto> modifyItemBudgetList = this.marketingStrategyBudgetModifyRepository.listByModifyBusinessCode(modifyCode);
        List<MarketingStrategyModifyAdjustBudgetDto> dtoListByModifyCode = this.marketingStrategyModifyAdjustBudgetRepository.findDtoListByModifyCode(modifyCode);
        this.useMonthBudget(modifyItemBudgetList, dtoListByModifyCode);
    }

    @Override
    public List<OperateMonthBudgetDto> useMonthBudget(List<MarketingStrategyBudgetModifyDto> modifyItemBudgetList, List<MarketingStrategyModifyAdjustBudgetDto> adjustBudgetDtos) {
        return this.useMonthBudget(modifyItemBudgetList, adjustBudgetDtos, true, true);
    }

    @Override
    public List<OperateMonthBudgetDto> useMonthBudget(List<MarketingStrategyBudgetModifyDto> modifyItemBudgetList, List<MarketingStrategyModifyAdjustBudgetDto> adjustBudgetDtos, final boolean doSave, final boolean throwException) {
        Object budgetOperateList;
        List itemCodeList = modifyItemBudgetList.stream().map(MarketingStrategyBudgetBase::getStrategyItemCode).collect(Collectors.toList());
        MarketingStrategyItemDto itemDto = new MarketingStrategyItemDto();
        itemDto.setStrategyItemCodeList(itemCodeList);
        List<MarketingStrategyBudgetDto> originBudgetList = this.marketingStrategyBudgetRepository.listByStrategyItem(itemDto);
        Map<String, BigDecimal> originBudgetMap = originBudgetList.stream().collect(Collectors.toMap(item -> item.getStrategyItemCode() + item.getMonthBudgetCode(), MarketingStrategyBudgetDto::getUseAmount));
        HashMap looseAmountMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(adjustBudgetDtos)) {
            budgetOperateList = Lists.newArrayList();
            for (final MarketingStrategyModifyAdjustBudgetDto adjustBudget : adjustBudgetDtos) {
                OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto(){
                    {
                        this.setBusinessCode(adjustBudget.getModifyBusinessCode());
                        this.setMonthBudgetCode(adjustBudget.getAdjustOutMonthBudgetCode());
                        this.setOperationType(BudgetOperationTypeEnum.ADJUST_OUT.getCode());
                        this.setOperationAmount(adjustBudget.getAdjustAmount());
                        this.setDoSave(doSave);
                        this.setThrowException(throwException);
                    }
                };
                budgetOperateList.add(operateMonthBudgetDto);
                looseAmountMap.put(adjustBudget.getMonthBudgetCode(), adjustBudget.getAdjustAmount());
            }
            this.monthBudgetService.operateBudget((List)budgetOperateList);
        }
        for (MarketingStrategyBudgetModifyDto budgetShareModify : modifyItemBudgetList) {
            if (null == budgetShareModify.getUseAmount() || budgetShareModify.getUseAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal originUseAmount = originBudgetMap.getOrDefault(budgetShareModify.getStrategyItemCode() + budgetShareModify.getMonthBudgetCode(), BigDecimal.ZERO);
            BigDecimal operationAmount = budgetShareModify.getUseAmount().subtract(originUseAmount);
            if (operationAmount.compareTo(BigDecimal.ZERO) > 0) continue;
            String looseAmountKey = budgetShareModify.getMonthBudgetCode();
            looseAmountMap.put(looseAmountKey, looseAmountMap.getOrDefault(looseAmountKey, BigDecimal.ZERO).add(originUseAmount.subtract(budgetShareModify.getUseAmount())));
        }
        budgetOperateList = Lists.newArrayList();
        for (final MarketingStrategyBudgetModifyDto budgetShareModify : modifyItemBudgetList) {
            if (null == budgetShareModify.getUseAmount() || budgetShareModify.getUseAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal originUseAmount = originBudgetMap.getOrDefault(budgetShareModify.getStrategyItemCode() + budgetShareModify.getMonthBudgetCode(), BigDecimal.ZERO);
            BigDecimal operationAmount = budgetShareModify.getUseAmount().subtract(originUseAmount);
            if (operationAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto(){
                {
                    this.setBusinessCode(budgetShareModify.getStrategyItemCode());
                    this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                    this.setDoSave(doSave);
                    this.setThrowException(throwException);
                }
            };
            operateMonthBudgetDto.setOperationAmount(operationAmount);
            budgetOperateList.add(operateMonthBudgetDto);
        }
        if (!CollectionUtils.isEmpty((Collection)budgetOperateList)) {
            this.monthBudgetService.operateBudgetStrategy((List)budgetOperateList, (Map)looseAmountMap);
        }
        return budgetOperateList;
    }

    @Override
    public void returnMonthBudgetByModifyCode(String modifyCode) {
        ArrayList budgetOperateList;
        List<MarketingStrategyItemModify> modifyItemList = this.marketingStrategyItemModifyRepository.findListByModifyCode(modifyCode);
        List<MarketingStrategyBudgetModifyDto> modifyItemBudgetList = this.marketingStrategyBudgetModifyRepository.listByModifyBusinessCode(modifyCode);
        List itemCodeList = modifyItemList.stream().map(MarketingStrategyItemModify::getStrategyItemCode).collect(Collectors.toList());
        MarketingStrategyItemDto itemDto = new MarketingStrategyItemDto();
        itemDto.setStrategyItemCodeList(itemCodeList);
        List<MarketingStrategyBudgetDto> originBudgetList = this.marketingStrategyBudgetRepository.listByStrategyItem(itemDto);
        Map<String, BigDecimal> originBudgetMap = originBudgetList.stream().collect(Collectors.toMap(item -> item.getStrategyItemCode() + item.getMonthBudgetCode(), MarketingStrategyBudgetDto::getUseAmount));
        List<MarketingStrategyModifyAdjustBudgetDto> adjustBudgetDtos = this.marketingStrategyModifyAdjustBudgetRepository.findDtoListByModifyCode(modifyCode);
        if (!CollectionUtils.isEmpty(adjustBudgetDtos)) {
            budgetOperateList = Lists.newArrayList();
            for (final MarketingStrategyModifyAdjustBudgetDto adjustBudget : adjustBudgetDtos) {
                OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto(){
                    {
                        this.setBusinessCode(adjustBudget.getModifyBusinessCode());
                        this.setMonthBudgetCode(adjustBudget.getAdjustOutMonthBudgetCode());
                        this.setOperationType(BudgetOperationTypeEnum.RELEASE.getCode());
                        this.setOperationAmount(adjustBudget.getAdjustAmount());
                    }
                };
                budgetOperateList.add(operateMonthBudgetDto);
            }
            this.monthBudgetService.operateBudget((List)budgetOperateList);
        }
        budgetOperateList = Lists.newArrayList();
        for (final MarketingStrategyBudgetModifyDto budgetShareModify : modifyItemBudgetList) {
            if (null == budgetShareModify.getUseAmount() || budgetShareModify.getUseAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal originUseAmount = originBudgetMap.getOrDefault(budgetShareModify.getStrategyItemCode() + budgetShareModify.getMonthBudgetCode(), BigDecimal.ZERO);
            BigDecimal operationAmount = budgetShareModify.getUseAmount().subtract(originUseAmount);
            if (operationAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto(){
                {
                    this.setBusinessCode(budgetShareModify.getStrategyItemCode());
                    this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                }
            };
            operateMonthBudgetDto.setOperationAmount(operationAmount);
            budgetOperateList.add(operateMonthBudgetDto);
        }
        if (!CollectionUtils.isEmpty((Collection)budgetOperateList)) {
            this.monthBudgetService.operateBudgetStrategy((List)budgetOperateList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void doUpdatePlanData(String modifyCode) {
        List<MarketingStrategyItemModify> modifyItemList = this.marketingStrategyItemModifyRepository.findListByModifyCode(modifyCode);
        if (CollectionUtils.isEmpty(modifyItemList)) {
            return;
        }
        List<MarketingStrategyBudgetModifyDto> modifyItemBudgetList = this.marketingStrategyBudgetModifyRepository.listByModifyBusinessCode(modifyCode);
        List<MarketingStrategyModifyAdjustBudget> adjustBudgets = this.marketingStrategyModifyAdjustBudgetRepository.findListByModifyCode(modifyCode);
        this.passAdjustMonthBudget(adjustBudgets, modifyItemList, modifyItemBudgetList);
        this.passReturnMonthBudgetByModifyCode(modifyItemList, modifyItemBudgetList);
        Map modifyMap = modifyItemList.stream().collect(Collectors.toMap(MarketingStrategyItemModify::getStrategyItemCode, Function.identity()));
        List<String> itemCodeList = modifyItemList.stream().map(MarketingStrategyItemModify::getStrategyItemCode).collect(Collectors.toList());
        MarketingStrategyItemDto itemDto = new MarketingStrategyItemDto();
        itemDto.setStrategyItemCodeList(itemCodeList);
        List<MarketingStrategyItem> itemList = this.marketingStrategyItemRepository.findList(itemDto);
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(TenantFlagOpEntity.class);
        String[] ignoreFieldArr = (String[])Arrays.stream(propertyDescriptors).map(FeatureDescriptor::getName).toArray(String[]::new);
        for (MarketingStrategyItem item2 : itemList) {
            MarketingStrategyItemModify modifyItem = (MarketingStrategyItemModify)((Object)modifyMap.get(item2.getStrategyItemCode()));
            BeanUtils.copyProperties((Object)((Object)modifyItem), (Object)((Object)item2), (String[])ignoreFieldArr);
            item2.setCurrModifyBusinessCode(modifyItem.getModifyBusinessCode());
        }
        this.marketingStrategyItemRepository.updateBatchById(itemList);
        MarketingStrategyItemDto queryBudgetDto = new MarketingStrategyItemDto();
        queryBudgetDto.setStrategyItemCodeList(itemCodeList);
        List<MarketingStrategyBudgetDto> marketingStrategyBudgetDtos = this.marketingStrategyBudgetRepository.listByStrategyItem(queryBudgetDto);
        Map<String, BigDecimal> usedAmountMap = marketingStrategyBudgetDtos.stream().filter(item -> null != item.getUsedAmount()).collect(Collectors.groupingBy(item -> item.getStrategyItemCode() + item.getMonthBudgetCode(), Collectors.reducing(BigDecimal.ZERO, MarketingStrategyBudgetDto::getUsedAmount, BigDecimal::add)));
        this.marketingStrategyBudgetRepository.deleteByStrategyItemCodes(itemCodeList);
        if (!CollectionUtils.isEmpty(modifyItemBudgetList)) {
            Collection budgetShareList = this.nebulaToolkitService.copyCollectionByBlankList(modifyItemBudgetList, MarketingStrategyBudgetModifyDto.class, MarketingStrategyBudget.class, HashSet.class, ArrayList.class, new String[0]);
            Map<String, List<MarketingStrategyBudget>> budgetShareMap = budgetShareList.stream().collect(Collectors.groupingBy(item -> item.getStrategyItemCode() + item.getMonthBudgetCode()));
            for (Map.Entry<String, BigDecimal> entry : usedAmountMap.entrySet()) {
                List<MarketingStrategyBudget> thisBudgetShareList;
                BigDecimal usedAmount = entry.getValue();
                if (usedAmount.compareTo(BigDecimal.ZERO) == 0 || CollectionUtils.isEmpty(thisBudgetShareList = budgetShareMap.get(entry.getKey()))) continue;
                for (MarketingStrategyBudget marketingStrategyBudget : thisBudgetShareList) {
                    if (marketingStrategyBudget.getUseAmount().compareTo(usedAmount) >= 0) {
                        marketingStrategyBudget.setUsedAmount(Optional.ofNullable(marketingStrategyBudget.getUsedAmount()).orElse(BigDecimal.ZERO).add(usedAmount));
                        usedAmount = BigDecimal.ZERO;
                        continue;
                    }
                    marketingStrategyBudget.setUsedAmount(marketingStrategyBudget.getUseAmount());
                    usedAmount = usedAmount.subtract(marketingStrategyBudget.getUseAmount());
                }
                if (usedAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                MarketingStrategyBudget firstBudget = thisBudgetShareList.get(0);
                firstBudget.setUsedAmount(Optional.ofNullable(firstBudget.getUsedAmount()).orElse(BigDecimal.ZERO).add(usedAmount));
            }
            this.marketingStrategyBudgetRepository.saveBatch(budgetShareList);
        }
        List<String> strategyCodeList = modifyItemList.stream().map(MarketingStrategyItemModify::getStrategyCode).distinct().collect(Collectors.toList());
        this.marketingStrategyRepository.updateFeeAmount(strategyCodeList);
    }

    private void passAdjustMonthBudget(List<MarketingStrategyModifyAdjustBudget> adjustBudgets, List<MarketingStrategyItemModify> modifyItemList, List<MarketingStrategyBudgetModifyDto> modifyItemBudgetList) {
        if (CollectionUtils.isEmpty(adjustBudgets)) {
            return;
        }
        ArrayList budgetOperateList = Lists.newArrayList();
        for (final MarketingStrategyModifyAdjustBudget adjustBudget : adjustBudgets) {
            OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto(){
                {
                    this.setBusinessCode(adjustBudget.getModifyBusinessCode());
                    this.setMonthBudgetCode(adjustBudget.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.ADJUST_IN.getCode());
                    this.setOperationAmount(adjustBudget.getAdjustAmount());
                }
            };
            budgetOperateList.add(operateMonthBudgetDto);
        }
        this.monthBudgetService.operateBudget((List)budgetOperateList);
    }

    public void passReturnMonthBudgetByModifyCode(List<MarketingStrategyItemModify> modifyItemList, List<MarketingStrategyBudgetModifyDto> modifyItemBudgetList) {
        List itemCodeList = modifyItemList.stream().map(MarketingStrategyItemModify::getStrategyItemCode).collect(Collectors.toList());
        MarketingStrategyItemDto itemDto = new MarketingStrategyItemDto();
        itemDto.setStrategyItemCodeList(itemCodeList);
        List<MarketingStrategyBudgetDto> originBudgetList = this.marketingStrategyBudgetRepository.listByStrategyItem(itemDto);
        Map<String, BigDecimal> modifyBudgetMap = modifyItemBudgetList.stream().collect(Collectors.toMap(item -> item.getStrategyItemCode() + item.getMonthBudgetCode(), MarketingStrategyBudgetBase::getUseAmount));
        ArrayList budgetOperateList = Lists.newArrayList();
        for (final MarketingStrategyBudgetDto budgetShare : originBudgetList) {
            if (null == budgetShare.getUseAmount() || budgetShare.getUseAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            final BigDecimal modifyUseAmount = modifyBudgetMap.getOrDefault(budgetShare.getStrategyItemCode() + budgetShare.getMonthBudgetCode(), BigDecimal.ZERO);
            if (budgetShare.getUseAmount().compareTo(modifyUseAmount) <= 0) continue;
            OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto(){
                {
                    this.setBusinessCode(budgetShare.getStrategyItemCode());
                    this.setMonthBudgetCode(budgetShare.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                    this.setOperationAmount(budgetShare.getUseAmount().subtract(modifyUseAmount));
                }
            };
            budgetOperateList.add(operateMonthBudgetDto);
        }
        if (!CollectionUtils.isEmpty((Collection)budgetOperateList)) {
            this.monthBudgetService.operateBudgetStrategy((List)budgetOperateList);
        }
    }
}

