/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.marketing.strategy.local.modify.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.NumberStringDealUtil;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.entity.MarketingStrategyModify;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.entity.MarketingStrategyModifyAdjustBudget;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.repository.MarketingStrategyItemModifyRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.repository.MarketingStrategyModifyAdjustBudgetRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.repository.MarketingStrategyModifyRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.service.MarketingStrategyBudgetModifyService;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.service.MarketingStrategyItemModifyService;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.service.MarketingStrategyModifyAdjustBudgetService;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.service.MarketingStrategyModifyService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.log.MarketingStrategyModifyLogEventDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.event.log.MarketingStrategyModifyLogEventListener;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyBudgetModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyItemModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyModifyAdjustBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyModifyApproveSubmitDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.vo.MarketingStrategyModifyAdjustBudgetVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.vo.MarketingStrategyModifyVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.pojo.MarketingStrategyBudgetBase;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MarketingStrategyModifyServiceImpl
implements MarketingStrategyModifyService {
    private static final Logger log = LoggerFactory.getLogger(MarketingStrategyModifyServiceImpl.class);
    @Autowired(required=false)
    private MarketingStrategyModifyRepository marketingStrategyModifyRepository;
    @Autowired(required=false)
    private MarketingStrategyItemModifyRepository marketingStrategyItemModifyRepository;
    @Autowired(required=false)
    private MarketingStrategyModifyAdjustBudgetRepository marketingStrategyModifyAdjustBudgetRepository;
    @Autowired(required=false)
    private MarketingStrategyItemModifyService marketingStrategyItemModifyService;
    @Autowired(required=false)
    private MarketingStrategyBudgetModifyService marketingStrategyBudgetModifyService;
    @Autowired(required=false)
    private MarketingStrategyModifyAdjustBudgetService marketingStrategyModifyAdjustBudgetService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private ProcessBusinessService processBusinessService;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;

    @Override
    public Page<MarketingStrategyModifyVo> findByConditions(Pageable pageable, MarketingStrategyModifyDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new MarketingStrategyModifyDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.marketingStrategyModifyRepository.findByConditions((Page<MarketingStrategyModifyVo>)page, dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<List<MarketingStrategyModifyAdjustBudgetVo>> validateMarketingStrategyModify(MarketingStrategyModifyDto dto, String cacheKey) {
        Object adjustBudgetVos = null;
        List itemList = this.marketingStrategyItemModifyService.findCacheList(cacheKey);
        if (CollectionUtils.isEmpty((Collection)itemList)) {
            return Result.ok(adjustBudgetVos);
        }
        this.marketingStrategyItemModifyService.createValidateList(dto, itemList);
        for (Object item2 : itemList) {
            if (!BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
                MarketingStrategyBudgetModifyDto budgetDto = new MarketingStrategyBudgetModifyDto();
                budgetDto.setMonthBudgetCode(item2.getMonthBudgetCode());
                budgetDto.setStrategyCode(item2.getStrategyCode());
                budgetDto.setStrategyItemCode(item2.getStrategyItemCode());
                budgetDto.setBudgetItemCode(item2.getBudgetItemCode());
                budgetDto.setBudgetItemName(item2.getBudgetItemName());
                budgetDto.setFeeBelongCode(item2.getFeeBelongCode());
                budgetDto.setUseAmountStr(item2.getFeeAmountStr());
                budgetDto.setUseAmount(item2.getFeeAmount());
                item2.setBudgetShares((List)Lists.newArrayList((Object[])new MarketingStrategyBudgetModifyDto[]{budgetDto}));
                continue;
            }
            BigDecimal budgetFeeAmount = BigDecimal.ZERO;
            for (Object budgetShare : item2.getBudgetShares()) {
                NumberStringDealUtil.validateNumberStrAndSet((String)budgetShare.getUseAmountStr(), (String)"\u65b0\u589e\u65f6\uff0c\u7b56\u7565\u660e\u7ec6\u8d39\u7528\u91d1\u989d", (boolean)false, arg_0 -> ((MarketingStrategyBudgetModifyDto)budgetShare).setUseAmount(arg_0), BigDecimal.class);
                if (null == budgetShare.getUseAmount()) continue;
                budgetFeeAmount = budgetFeeAmount.add(budgetShare.getUseAmount());
            }
            BigDecimal feeAmount = Optional.ofNullable(item2.getFeeAmount()).orElse(BigDecimal.ZERO);
            if (feeAmount.compareTo(budgetFeeAmount) == 0) continue;
            throw new RuntimeException("\u8d39\u7528\u91d1\u989d[" + feeAmount + "]\u4e0d\u7b49\u4e8e\u5b9e\u9645\u9884\u7b97\u4f7f\u7528\u91d1\u989d[" + budgetFeeAmount + "]");
        }
        ArrayList budgetDtos = Lists.newArrayList();
        for (Object itemDto : itemList) {
            if (CollectionUtils.isEmpty((Collection)itemDto.getBudgetShares())) continue;
            budgetDtos.addAll(itemDto.getBudgetShares());
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getAdjustBudgetList())) {
            List budgetCodeList = budgetDtos.stream().map(MarketingStrategyBudgetBase::getMonthBudgetCode).distinct().collect(Collectors.toList());
            for (MarketingStrategyModifyAdjustBudgetDto adjustBudgetDto : dto.getAdjustBudgetList()) {
                if (budgetCodeList.contains(adjustBudgetDto.getMonthBudgetCode())) continue;
                throw new RuntimeException("\u9884\u7b97[" + adjustBudgetDto.getMonthBudgetCode() + "]\u4e0d\u5b58\u5728\u4e8e\u672c\u6b21\u8c03\u6574\u6570\u636e\u4e2d");
            }
        }
        List<OperateMonthBudgetDto> operateMonthBudgetDtos = this.marketingStrategyItemModifyService.useMonthBudget(budgetDtos, dto.getAdjustBudgetList(), false, false);
        Map<String, BigDecimal> adjustBudgetAmountMap = operateMonthBudgetDtos.stream().filter(item -> null != item.getGapAmount() && item.getGapAmount().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.groupingBy(OperateMonthBudgetDto::getMonthBudgetCode, Collectors.reducing(BigDecimal.ZERO, OperateMonthBudgetDto::getGapAmount, BigDecimal::add)));
        boolean isSuccess = false;
        if (adjustBudgetAmountMap.size() == 0) {
            isSuccess = true;
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getAdjustBudgetList())) {
            for (MarketingStrategyModifyAdjustBudgetDto adjustBudgetDto : dto.getAdjustBudgetList()) {
                adjustBudgetAmountMap.put(adjustBudgetDto.getMonthBudgetCode(), adjustBudgetAmountMap.getOrDefault(adjustBudgetDto.getMonthBudgetCode(), BigDecimal.ZERO).add(adjustBudgetDto.getAdjustAmount()));
            }
        }
        if (adjustBudgetAmountMap.size() == 0) {
            return Result.ok(adjustBudgetVos);
        }
        List result = adjustBudgetAmountMap.entrySet().stream().map(item -> new MarketingStrategyModifyAdjustBudgetVo((Map.Entry)item){
            final /* synthetic */ Map.Entry val$item;
            {
                this.val$item = entry;
                this.setMonthBudgetCode((String)this.val$item.getKey());
                this.setAdjustAmount((BigDecimal)this.val$item.getValue());
            }
        }).collect(Collectors.toList());
        List monthBudgetCodeList = result.stream().map(MarketingStrategyModifyAdjustBudgetVo::getMonthBudgetCode).collect(Collectors.toList());
        monthBudgetCodeList.add("_");
        List monthBudgetVos = this.monthBudgetService.listByCodes(monthBudgetCodeList);
        Map monthBudgetVoMap = monthBudgetVos.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity()));
        for (MarketingStrategyModifyAdjustBudgetVo adjustBudgetVo : result) {
            MonthBudgetVo monthBudgetVo = (MonthBudgetVo)monthBudgetVoMap.get(adjustBudgetVo.getMonthBudgetCode());
            adjustBudgetVo.setYearMonthLy(monthBudgetVo.getYearMonthLy());
            adjustBudgetVo.setBudgetItemCode(monthBudgetVo.getBudgetItemCode());
            adjustBudgetVo.setBudgetItemName(monthBudgetVo.getBudgetItemName());
            adjustBudgetVo.setFeeBelongCode(monthBudgetVo.getFeeBelongCode());
            adjustBudgetVo.setAfterFreezeAmount(monthBudgetVo.getAfterFreezeAmount());
            adjustBudgetVo.setAccumulatedAvailableBalance(monthBudgetVo.getAccumulatedAvailableBalance());
            adjustBudgetVo.setUsedStrategyAmount(monthBudgetVo.getUsedStrategyAmount());
        }
        Result r = new Result();
        r.setResult(result);
        r.setMessage("\u60a8\u4f7f\u7528\u7684[" + String.join((CharSequence)",", monthBudgetCodeList) + "]\u5f53\u524d\u9884\u7b97\u4e0d\u8db3\uff0c\u662f\u5426\u8981\u540c\u6b65\u8fdb\u884c\u9884\u7b97\u8c03\u6574\uff1f");
        r.setSuccess(isSuccess);
        return r;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveMarketingStrategyModify(MarketingStrategyModifyDto dto, String cacheKey) {
        MarketingStrategyModify entity;
        List itemList = this.marketingStrategyItemModifyService.findCacheList(cacheKey);
        if (CollectionUtils.isEmpty((Collection)itemList)) {
            throw new RuntimeException("\u7b56\u7565\u53d8\u66f4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.createValidate(dto, itemList);
        MarketingStrategyModifyDto oldDto = new MarketingStrategyModifyDto();
        boolean update = !StringUtils.isBlank((CharSequence)dto.getId());
        HashSet<String> budgetItemCodeSet = new HashSet<String>();
        HashSet<String> budgetItemNameSet = new HashSet<String>();
        for (MarketingStrategyItemModifyDto item : itemList) {
            budgetItemCodeSet.add(item.getBudgetItemCode());
            budgetItemNameSet.add(item.getBudgetItemName());
        }
        String attrOrgCode = StringUtils.isNotBlank((CharSequence)dto.getAttrOrgCode()) ? dto.getAttrOrgCode() : ((MarketingStrategyItemModifyDto)itemList.get(0)).getAttrOrgCode();
        String attrOrgName = StringUtils.isNotBlank((CharSequence)dto.getAttrOrgName()) ? dto.getAttrOrgName() : ((MarketingStrategyItemModifyDto)itemList.get(0)).getAttrOrgName();
        String budgetItemCode = StringUtils.isNotBlank((CharSequence)dto.getBudgetItemCode()) ? dto.getBudgetItemCode() : String.join((CharSequence)",", budgetItemCodeSet);
        String budgetItemName = StringUtils.isNotBlank((CharSequence)dto.getBudgetItemName()) ? dto.getBudgetItemName() : String.join((CharSequence)",", budgetItemNameSet);
        dto.setAttrOrgCode(attrOrgCode);
        dto.setAttrOrgName(attrOrgName);
        dto.setBudgetItemCode(budgetItemCode);
        dto.setBudgetItemName(budgetItemName);
        if (!update) {
            entity = (MarketingStrategyModify)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, MarketingStrategyModify.class, HashSet.class, ArrayList.class, new String[0]));
            String code = (String)this.generateCodeService.generateCode("MM", 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
            entity.setModifyBusinessCode(code);
            entity.setProcessStatus(ProcessStatusEnum.PREPARE.getKey());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setTenantCode(TenantContextHolder.getTenantInfo().getTenantCode());
            this.marketingStrategyModifyRepository.save((Object)entity);
        } else {
            MarketingStrategyModify oldEntity = (MarketingStrategyModify)((Object)this.marketingStrategyModifyRepository.getById((Serializable)((Object)dto.getId())));
            dto.setModifyBusinessCode(oldEntity.getModifyBusinessCode());
            dto.setTenantCode(oldEntity.getTenantCode());
            entity = (MarketingStrategyModify)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, MarketingStrategyModify.class, HashSet.class, ArrayList.class, new String[0]));
            this.marketingStrategyModifyRepository.updateById((Object)entity);
            oldDto = (MarketingStrategyModifyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)oldEntity, MarketingStrategyModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
        }
        this.marketingStrategyItemModifyService.saveMarketingStrategyModifyItemList(entity, update, itemList, false);
        this.marketingStrategyBudgetModifyService.saveMarketingStrategyBudgetList(entity, update, itemList);
        this.marketingStrategyModifyAdjustBudgetService.saveMarketingStrategyBudgetList(entity, update, dto.getAdjustBudgetList());
        MarketingStrategyModifyLogEventDto logEventDto = new MarketingStrategyModifyLogEventDto();
        logEventDto.setNewest(dto);
        if (!update) {
            logEventDto.setOriginal(null);
            SerializableBiConsumer & Serializable onCreate = MarketingStrategyModifyLogEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, MarketingStrategyModifyLogEventListener.class, (SerializableBiConsumer)onCreate);
        } else {
            logEventDto.setOriginal(oldDto);
            SerializableBiConsumer & Serializable onUpdate = MarketingStrategyModifyLogEventListener::onUpdate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, MarketingStrategyModifyLogEventListener.class, (SerializableBiConsumer)onUpdate);
        }
    }

    private void createValidate(MarketingStrategyModifyDto dto, List<MarketingStrategyItemModifyDto> itemList) {
        this.marketingStrategyItemModifyService.createValidateList(dto, itemList);
        for (MarketingStrategyItemModifyDto item : itemList) {
            if (!BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
                MarketingStrategyBudgetModifyDto budgetDto = new MarketingStrategyBudgetModifyDto();
                budgetDto.setMonthBudgetCode(item.getMonthBudgetCode());
                budgetDto.setStrategyCode(item.getStrategyCode());
                budgetDto.setStrategyItemCode(item.getStrategyItemCode());
                budgetDto.setBudgetItemCode(item.getBudgetItemCode());
                budgetDto.setBudgetItemName(item.getBudgetItemName());
                budgetDto.setFeeBelongCode(item.getFeeBelongCode());
                budgetDto.setUseAmountStr(item.getFeeAmountStr());
                budgetDto.setUseAmount(item.getFeeAmount());
                item.setBudgetShares((List)Lists.newArrayList((Object[])new MarketingStrategyBudgetModifyDto[]{budgetDto}));
                continue;
            }
            BigDecimal budgetFeeAmount = BigDecimal.ZERO;
            for (MarketingStrategyBudgetModifyDto budgetShare : item.getBudgetShares()) {
                NumberStringDealUtil.validateNumberStrAndSet((String)budgetShare.getUseAmountStr(), (String)"\u65b0\u589e\u65f6\uff0c\u7b56\u7565\u660e\u7ec6\u8d39\u7528\u91d1\u989d", (boolean)false, arg_0 -> ((MarketingStrategyBudgetModifyDto)budgetShare).setUseAmount(arg_0), BigDecimal.class);
                if (null == budgetShare.getUseAmount()) continue;
                budgetFeeAmount = budgetFeeAmount.add(budgetShare.getUseAmount());
            }
            BigDecimal feeAmount = Optional.ofNullable(item.getFeeAmount()).orElse(BigDecimal.ZERO);
            if (feeAmount.compareTo(budgetFeeAmount) == 0) continue;
            throw new RuntimeException("\u8d39\u7528\u91d1\u989d[" + feeAmount + "]\u4e0d\u7b49\u4e8e\u5b9e\u9645\u9884\u7b97\u4f7f\u7528\u91d1\u989d[" + budgetFeeAmount + "]");
        }
        ArrayList budgetDtos = Lists.newArrayList();
        for (MarketingStrategyItemModifyDto itemDto : itemList) {
            if (CollectionUtils.isEmpty((Collection)itemDto.getBudgetShares())) continue;
            budgetDtos.addAll(itemDto.getBudgetShares());
        }
        this.marketingStrategyItemModifyService.useMonthBudget(budgetDtos, dto.getAdjustBudgetList(), false, true);
    }

    @Override
    public MarketingStrategyModifyVo findById(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        MarketingStrategyModify entity = (MarketingStrategyModify)((Object)this.marketingStrategyModifyRepository.getById((Serializable)((Object)id)));
        if (null != entity) {
            MarketingStrategyModifyVo vo = (MarketingStrategyModifyVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, MarketingStrategyModifyVo.class, HashSet.class, ArrayList.class, new String[0]);
            List<MarketingStrategyModifyAdjustBudget> adjustBudgets = this.marketingStrategyModifyAdjustBudgetRepository.findListByModifyCode(vo.getModifyBusinessCode());
            if (!CollectionUtils.isEmpty(adjustBudgets)) {
                List adjustBudgetVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(adjustBudgets, MarketingStrategyModifyAdjustBudget.class, MarketingStrategyModifyAdjustBudgetVo.class, HashSet.class, ArrayList.class, new String[0]);
                vo.setAdjustBudgetList(adjustBudgetVos);
            }
            return vo;
        }
        return null;
    }

    @Override
    public void delete(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List entities = this.marketingStrategyModifyRepository.listByIds(ids);
        for (MarketingStrategyModify entity : entities) {
            Validate.isTrue((ProcessStatusEnum.PREPARE.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.REJECT.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.RECOVER.getKey().equals(entity.getProcessStatus()) ? 1 : 0) != 0, (String)("\u7b56\u7565\u53d8\u66f4[" + entity.getModifyBusinessCode() + "]\u4e0d\u662f\u5f85\u63d0\u4ea4\u3001\u9a73\u56de\u6216\u8ffd\u56de\u72b6\u6001\uff0c\u4e0d\u80fd\u5220\u9664\uff01"), (Object[])new Object[0]);
        }
        this.marketingStrategyModifyRepository.deleteIds(ids);
        List<String> modifyCodes = entities.stream().map(MarketingStrategyModify::getModifyBusinessCode).collect(Collectors.toList());
        this.marketingStrategyItemModifyService.deleteByModifyCodes(modifyCodes);
        this.marketingStrategyBudgetModifyService.deleteByModifyBusinessCodes(modifyCodes);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submit(MarketingStrategyModifyApproveSubmitDto dto) {
        Validate.notNull((Object)dto.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        MarketingStrategyModify entity = (MarketingStrategyModify)((Object)this.marketingStrategyModifyRepository.getById((Serializable)((Object)dto.getId())));
        String modifyBusinessCode = entity.getModifyBusinessCode();
        List<MarketingStrategyItemModifyDto> listByModifyCode = this.marketingStrategyItemModifyRepository.findListByModifyBusinessCode(modifyBusinessCode);
        if (!CollectionUtils.isEmpty(listByModifyCode)) {
            throw new IllegalArgumentException("\u5b58\u5728\u5ba1\u6279\u4e2d\u7684\u6570\u636e");
        }
        Validate.notNull((Object)((Object)entity), (String)"\u5b9e\u4f8b\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01\uff01", (Object[])new Object[0]);
        if (!(ProcessStatusEnum.PREPARE.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.RECOVER.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.REJECT.getKey().equals(entity.getProcessStatus()))) {
            throw new RuntimeException("\u7b56\u7565\u53d8\u66f4[" + entity.getModifyBusinessCode() + "]\u4e0d\u5904\u4e8e\u5f85\u63d0\u4ea4\u3001\u9a73\u56de\u3001\u8ffd\u56de\u72b6\u6001\uff0c\u4e0d\u80fd\u63d0\u4ea4\u5ba1\u6279\uff01");
        }
        dto.setModifyBusinessCode(entity.getModifyBusinessCode());
        this.marketingStrategyItemModifyService.useMonthBudgetByModifyCode(entity.getModifyBusinessCode());
        this.commitProcess(dto);
    }

    private void commitProcess(MarketingStrategyModifyApproveSubmitDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        Validate.notNull((Object)processBusiness, (String)"\u63d0\u4ea4\u5de5\u4f5c\u6d41\u65f6\uff0c\u672a\u4f20\u5de5\u4f5c\u6d41\u5bf9\u8c61\u4fe1\u606f!", (Object[])new Object[0]);
        processBusiness.setBusinessNo(dto.getModifyBusinessCode());
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString((Object)dto));
        processBusiness.setBusinessCode("marketing_strategy_modify");
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        this.marketingStrategyModifyRepository.updateProcessStatusAndProcessNo(dto.getModifyBusinessCode(), ProcessStatusEnum.COMMIT.getKey(), processBusinessVo.getProcessNo());
    }

    @Override
    public void processPass(ProcessStatusDto dto) {
        this.marketingStrategyModifyRepository.updateProcessStatus(dto.getBusinessNo(), dto.getProcessStatus());
    }

    @Override
    public void processRejectAndRecover(ProcessStatusDto dto) {
        this.marketingStrategyItemModifyService.returnMonthBudgetByModifyCode(dto.getBusinessNo());
        this.marketingStrategyModifyRepository.updateProcessStatus(dto.getBusinessNo(), dto.getProcessStatus());
    }
}

