/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.marketing.strategy.local.register;

import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.bizunited.nebula.europa.database.sdk.strategy.ExternalQueryInterceptor;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteContent;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import jodd.util.StringUtil;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MarketingStrategyQueryInterceptor
implements ExternalQueryInterceptor {
    private static final Logger log = LoggerFactory.getLogger(MarketingStrategyQueryInterceptor.class);
    private static final String PARENT_NAME = "parent_org_name";
    private static final String DEPARTMENT_CODE = "attr_org_code";
    @Autowired(required=false)
    private OrgVoService orgVoService;

    public String code() {
        return "tpm_marketing_strategy_data_view_parent_org_name";
    }

    public String name() {
        return "\u8425\u9500\u7b56\u7565-\u4e0a\u7ea7\u90e8\u95e8";
    }

    public List<Object[]> process(EntityManager entityManager, MetaData metaData, EuropaInfoVo europaInfoVo, ExecuteContent executeContent, String ... strings) {
        List results = executeContent.getResults();
        if (CollectionUtils.isEmpty((Collection)results)) {
            return null;
        }
        List orgCodeList = results.stream().filter(Objects::nonNull).map(item -> item.get(DEPARTMENT_CODE)).filter(Objects::nonNull).flatMap(item -> Arrays.stream(String.valueOf(item).split(","))).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(orgCodeList)) {
            return null;
        }
        List orgVos = this.orgVoService.findByOrgCodes(orgCodeList);
        if (CollectionUtils.isEmpty((Collection)orgVos)) {
            return null;
        }
        List parentOrgCodeList = orgVos.stream().map(OrgVo::getParentCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(parentOrgCodeList)) {
            return null;
        }
        List parentOrgVos = this.orgVoService.findByOrgCodes(parentOrgCodeList);
        if (CollectionUtils.isEmpty((Collection)parentOrgVos)) {
            return null;
        }
        Map<String, String> orgParentMap = orgVos.stream().filter(item -> StringUtil.isNotEmpty((CharSequence)item.getParentCode())).collect(Collectors.toMap(OrgVo::getOrgCode, OrgVo::getParentCode, (o, n) -> n));
        Map<String, String> parentNameMap = parentOrgVos.stream().collect(Collectors.toMap(OrgVo::getOrgCode, OrgVo::getOrgName, (o, n) -> n));
        ArrayList contents = Lists.newArrayList();
        for (Map item2 : results) {
            if (null == item2) {
                contents.add(null);
                continue;
            }
            Object departmentCodeObj = item2.get(DEPARTMENT_CODE);
            if (null == departmentCodeObj) {
                contents.add(null);
                continue;
            }
            ArrayList parentOrgNameList = Lists.newArrayList();
            String orgCodes = String.valueOf(departmentCodeObj);
            for (String orgCode : orgCodes.split(",")) {
                String parentOrgName;
                String parentOrgCode = orgParentMap.get(orgCode);
                if (StringUtil.isEmpty((CharSequence)parentOrgCode) || StringUtil.isEmpty((CharSequence)parentOrgCode) || StringUtil.isEmpty((CharSequence)(parentOrgName = parentNameMap.get(parentOrgCode)))) continue;
                parentOrgNameList.add(parentOrgName);
            }
            contents.add(parentOrgNameList.toArray(new Object[0]));
        }
        return contents;
    }
}

