/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.marketing.strategy.local.repository;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategyBudget;
import com.biz.crm.tpm.business.marketing.strategy.local.mapper.MarketingStrategyBudgetMapper;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MarketingStrategyBudgetRepository
extends ServiceImpl<MarketingStrategyBudgetMapper, MarketingStrategyBudget> {
    @Autowired(required=false)
    private MarketingStrategyBudgetMapper marketingStrategyBudgetMapper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public void fillVoListProperties(List<MarketingStrategyBudgetVo> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(MarketingStrategyBudgetVo.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        for (MarketingStrategyBudgetVo item : voList) {
            this.fillVoProperties(item, propertyMap);
        }
    }

    public void fillVoProperties(MarketingStrategyBudgetVo item) {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(MarketingStrategyBudgetVo.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        this.fillVoProperties(item, propertyMap);
    }

    public void fillVoProperties(MarketingStrategyBudgetVo item, Map<String, PropertyDescriptor> propertyMap) {
        if (null == item) {
            return;
        }
        ObjectConvertStringUtil.fillObjectStrProperties((Object)item, MarketingStrategyBudgetVo.class, propertyMap);
        BigDecimal useAmount = Optional.ofNullable(item.getUseAmount()).orElse(BigDecimal.ZERO);
        BigDecimal usedAmount = Optional.ofNullable(item.getUsedAmount()).orElse(BigDecimal.ZERO);
        item.setUsedAmount(usedAmount);
        item.setUsableAmount(useAmount.subtract(usedAmount));
    }

    public List<MarketingStrategyBudgetDto> findDtoListByStrategyCode(String strategyCode) {
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isBlank((CharSequence)strategyCode)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(MarketingStrategyBudget.class).eq(MarketingStrategyBudget::getStrategyCode, (Object)strategyCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        List list = this.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        List dtoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, MarketingStrategyBudget.class, MarketingStrategyBudgetDto.class, HashSet.class, ArrayList.class, new String[0]);
        return dtoList;
    }

    public List<MarketingStrategyBudgetDto> listByStrategyItem(MarketingStrategyItemDto dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getStrategyCode()) && CollectionUtil.isEmpty((Collection)dto.getStrategyCodeList()) && CollectionUtil.isEmpty((Collection)dto.getStrategyItemCodeList())) {
            return Lists.newArrayList();
        }
        return this.marketingStrategyBudgetMapper.listDtoList(dto);
    }

    public List<MarketingStrategyBudgetDto> listByStrategyCode(String strategyCode) {
        if (StringUtils.isEmpty((CharSequence)strategyCode)) {
            return Lists.newArrayList();
        }
        MarketingStrategyItemDto itemDto = new MarketingStrategyItemDto();
        itemDto.setStrategyCode(strategyCode);
        return this.listByStrategyItem(itemDto);
    }

    public List<MarketingStrategyBudget> listByStrategyCodeList(List<String> strategyCodeList) {
        if (CollectionUtils.isEmpty(strategyCodeList)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MarketingStrategyBudget::getStrategyCode, strategyCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<MarketingStrategyBudget> listByStrategyItemCodeList(List<String> strategyItemCodeList) {
        if (CollectionUtils.isEmpty(strategyItemCodeList)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MarketingStrategyBudget::getStrategyItemCode, strategyItemCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void deleteByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(UuidEntity::getId, ids);
        this.update((Wrapper)updateWrapper);
    }

    public void deleteByStrategyCodes(List<String> strategyCodes) {
        if (CollectionUtils.isEmpty(strategyCodes)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(MarketingStrategyBudget::getStrategyCode, strategyCodes);
        updateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        this.update((Wrapper)updateWrapper);
    }

    public void deleteByStrategyItemCodes(List<String> strategyItemCodes) {
        if (CollectionUtils.isEmpty(strategyItemCodes)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(MarketingStrategyBudget::getStrategyItemCode, strategyItemCodes);
        updateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        this.update((Wrapper)updateWrapper);
    }

    public void deletePhysicalByStrategyCode(String strategyCode) {
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isBlank((CharSequence)strategyCode)) {
            return;
        }
        LambdaQueryWrapper updateWrapper = new LambdaQueryWrapper();
        updateWrapper.eq(MarketingStrategyBudget::getStrategyCode, (Object)strategyCode);
        updateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        this.remove((Wrapper)updateWrapper);
    }

    public List<MarketingStrategyBudgetDto> findListByConditions(MarketingStrategyBudgetDto dto) {
        return this.marketingStrategyBudgetMapper.findListByConditions(dto);
    }

    public List<MarketingStrategyBudgetDto> listBudgetInfoByOperateList(List<String> operateCodeList) {
        return this.marketingStrategyBudgetMapper.listBudgetInfoByOperateList(operateCodeList);
    }

    public Page<MarketingStrategyBudgetVo> findByConditions(Pageable pageable, MarketingStrategyBudgetDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<MarketingStrategyBudgetVo> pageList = this.marketingStrategyBudgetMapper.findConditions((Page<MarketingStrategyBudgetVo>)page, dto);
        this.fillVoListProperties(pageList.getRecords());
        return pageList;
    }

    public void updateStrategyUsedAmount(List<String> strategyCodeList) {
        ((MarketingStrategyBudgetMapper)this.baseMapper).updateStrategyUsedAmount(strategyCodeList);
    }

    public void updateHeadStatus(List<String> strategyItemCodeList) {
        if (CollectionUtils.isEmpty(strategyItemCodeList)) {
            return;
        }
        ((MarketingStrategyBudgetMapper)this.baseMapper).updateHeadStatus(strategyItemCodeList);
    }
}

