/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.marketing.strategy.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.util.NumberStringDealUtil;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategyItem;
import com.biz.crm.tpm.business.marketing.strategy.local.mapper.MarketingStrategyItemMapper;
import com.biz.crm.tpm.business.marketing.strategy.local.repository.MarketingStrategyBudgetRepository;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketStrategyItemExportVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class MarketingStrategyItemRepository
extends ServiceImpl<MarketingStrategyItemMapper, MarketingStrategyItem> {
    @Autowired(required=false)
    private MarketingStrategyItemMapper marketingStrategyItemMapper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private MarketingStrategyBudgetRepository marketingStrategyBudgetRepository;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    public Page<MarketingStrategyItemVo> findByConditions(Pageable pageable, MarketingStrategyItemDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<MarketingStrategyItemVo> pageList = this.marketingStrategyItemMapper.findByConditions((Page<MarketingStrategyItemVo>)page, dto);
        this.fillVoListProperties(pageList.getRecords());
        return pageList;
    }

    public List<MarketingStrategyItemDto> findDtoAndAttachListByStrategyCode(String strategyCode) {
        MarketingStrategyItemDto dto = new MarketingStrategyItemDto();
        dto.setStrategyCode(strategyCode);
        return this.findDtoAndAttachList(dto);
    }

    public List<MarketingStrategyItemDto> findDtoAndAttachList(MarketingStrategyItemDto dto) {
        List<MarketingStrategyItemDto> dtoList = this.findDtoList(dto);
        List<MarketingStrategyBudgetDto> budgetList = this.marketingStrategyBudgetRepository.listByStrategyItem(dto);
        if (!org.springframework.util.CollectionUtils.isEmpty(budgetList)) {
            this.convertMonthBudgetProperty(budgetList);
            for (MarketingStrategyBudgetDto budgetDto : budgetList) {
                NumberStringDealUtil.setStringIfNotNull((Object)budgetDto.getUseAmount(), arg_0 -> ((MarketingStrategyBudgetDto)budgetDto).setUseAmountStr(arg_0));
                BigDecimal afterFreezeAmount = Optional.ofNullable(budgetDto.getAfterFreezeAmount()).orElse(BigDecimal.ZERO);
                BigDecimal usedStrategyAmount = Optional.ofNullable(budgetDto.getUsedStrategyAmount()).orElse(BigDecimal.ZERO);
                BigDecimal usableStrategyAmount = afterFreezeAmount.subtract(usedStrategyAmount);
                budgetDto.setUsableStrategyAmount(usableStrategyAmount);
            }
            Map<String, List<MarketingStrategyBudgetDto>> budgetMap = budgetList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getStrategyItemCode())).collect(Collectors.groupingBy(MarketingStrategyBudgetDto::getStrategyItemCode));
            for (MarketingStrategyItemDto marketingStrategyItemDto : dtoList) {
                if (!budgetMap.containsKey(marketingStrategyItemDto.getStrategyItemCode())) continue;
                List<MarketingStrategyBudgetDto> budgetShares = budgetMap.get(marketingStrategyItemDto.getStrategyItemCode());
                marketingStrategyItemDto.setBudgetShares(budgetShares);
                BigDecimal usableAmount = BigDecimal.ZERO;
                if (!org.springframework.util.CollectionUtils.isEmpty(budgetShares)) {
                    for (MarketingStrategyBudgetDto budgetShare : budgetShares) {
                        usableAmount = usableAmount.add(budgetShare.getUseAmount().subtract(Optional.ofNullable(budgetShare.getUsedAmount()).orElse(BigDecimal.ZERO)));
                    }
                }
                marketingStrategyItemDto.setUsableAmount(usableAmount);
            }
        }
        return dtoList;
    }

    public void convertMonthBudgetProperty(List<MarketingStrategyBudgetDto> list) {
        if (org.springframework.util.CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<Object, Object> feeSourceMap = Maps.newHashMap();
        if (null != this.dictDataVoService) {
            try {
                List feeSourceList = this.dictDataVoService.findByDictTypeCode("tpm_fee_belong_us");
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)feeSourceList)) {
                    feeSourceMap = feeSourceList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (o, n) -> o));
                }
            }
            catch (Exception e) {
                this.log.error("\u8d39\u7528\u5f52\u53e3\u6570\u636e\u5b57\u5178\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        for (MarketingStrategyBudgetDto vo : list) {
            if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)vo.getFeeBelongCode())) continue;
            vo.setFeeSourceName(feeSourceMap.getOrDefault(vo.getFeeBelongCode(), vo.getFeeBelongCode()));
        }
    }

    public List<MarketingStrategyItemDto> findDtoListByStrategyCode(String strategyCode) {
        if (StringUtils.isBlank((CharSequence)strategyCode)) {
            return null;
        }
        List<MarketingStrategyItem> list = this.findListByStrategyCode(strategyCode);
        List dtoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, MarketingStrategyItem.class, MarketingStrategyItemDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.fillDtoListProperties(dtoList);
        return dtoList;
    }

    public List<MarketingStrategyItemDto> findDtoList(MarketingStrategyItemDto dto) {
        List<MarketingStrategyItem> list = this.findList(dto);
        List dtoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, MarketingStrategyItem.class, MarketingStrategyItemDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.fillDtoListProperties(dtoList);
        return dtoList;
    }

    public List<MarketingStrategyItem> findListByStrategyCode(String strategyCode) {
        if (StringUtils.isBlank((CharSequence)strategyCode)) {
            return null;
        }
        MarketingStrategyItemDto dto = new MarketingStrategyItemDto();
        dto.setStrategyCode(strategyCode);
        return this.findList(dto);
    }

    public List<MarketingStrategyItem> findList(MarketingStrategyItemDto dto) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(MarketingStrategyItem.class).eq(StringUtils.isNotBlank((CharSequence)dto.getStrategyCode()), MarketingStrategyItem::getStrategyCode, (Object)dto.getStrategyCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)dto.getStrategyCodeList())) {
            wrapper.in(MarketingStrategyItem::getStrategyCode, (Collection)dto.getStrategyCodeList());
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)dto.getStrategyItemCodeList())) {
            wrapper.in(MarketingStrategyItem::getStrategyItemCode, (Collection)dto.getStrategyItemCodeList());
        }
        return this.list((Wrapper)wrapper);
    }

    public List<String> findStrategyCodeListByItemCodeList(List<String> itemCodeList) {
        if (org.springframework.util.CollectionUtils.isEmpty(itemCodeList)) {
            return Lists.newArrayList();
        }
        return this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(MarketingStrategyItem.class).in(MarketingStrategyItem::getStrategyItemCode, itemCodeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).select(new SFunction[]{MarketingStrategyItem::getStrategyCode})).stream().map(MarketingStrategyItem::getStrategyCode).distinct().collect(Collectors.toList());
    }

    public void deleteByIds(ArrayList<String> ids) {
        if (org.springframework.util.CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(UuidEntity::getId, ids);
        updateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        this.update((Wrapper)updateWrapper);
    }

    public void deleteByStrategyCodes(List<String> strategyCodes) {
        if (org.springframework.util.CollectionUtils.isEmpty(strategyCodes)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(MarketingStrategyItem::getStrategyCode, strategyCodes);
        updateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        this.update((Wrapper)updateWrapper);
    }

    public List<String> listBudgetCodeListByStrategyCodeList(List<String> strategyCodes) {
        if (CollectionUtils.isEmpty(strategyCodes)) {
            return null;
        }
        List list = ((QueryChainWrapper)((QueryChainWrapper)((QueryChainWrapper)this.query().in((Object)"plan_code", strategyCodes)).eq((Object)"del_flag", (Object)DelFlagStatusEnum.NORMAL.getCode())).isNotNull((Object)"month_budget_code")).select(new String[]{"distinct month_budget_code"}).list();
        return list.stream().map(MarketingStrategyItem::getMonthBudgetCode).collect(Collectors.toList());
    }

    public void fillVoListProperties(List<MarketingStrategyItemVo> voList) {
        if (org.springframework.util.CollectionUtils.isEmpty(voList)) {
            return;
        }
        for (MarketingStrategyItemVo item : voList) {
            this.fillVoProperties(item);
        }
    }

    public void fillVoProperties(MarketingStrategyItemVo item) {
        if (null == item) {
            return;
        }
        ObjectConvertStringUtil.fillObjectStrProperties((Object)item, MarketingStrategyItemVo.class);
        item.setActivityType(item.getActivityTypeCode());
        item.setActivityForm(item.getActivityFormCode());
        BigDecimal feeAmount = Optional.ofNullable(item.getFeeAmount()).orElse(BigDecimal.ZERO);
        BigDecimal usedAmount = Optional.ofNullable(item.getUsedAmount()).orElse(BigDecimal.ZERO);
        item.setUsedAmount(usedAmount);
        item.setUsableAmount(feeAmount.subtract(usedAmount));
    }

    public void fillDtoListProperties(List<? extends MarketingStrategyItemDto> dtoList) {
        if (org.springframework.util.CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        for (MarketingStrategyItemDto marketingStrategyItemDto : dtoList) {
            this.fillDtoProperties(marketingStrategyItemDto);
        }
    }

    public void fillDtoProperties(MarketingStrategyItemDto item) {
        if (null == item) {
            return;
        }
        ObjectConvertStringUtil.fillObjectStrProperties((Object)item, MarketingStrategyItemDto.class);
        item.setActivityType(item.getActivityTypeCode());
        item.setActivityForm(item.getActivityFormCode());
    }

    public List<MarketingStrategyItemVo> findByCodes(List<String> itemCodes) {
        return ((MarketingStrategyItemMapper)this.baseMapper).findByCodes(itemCodes);
    }

    public Integer itemExportGetTotal(MarketingStrategyItemDto dto) {
        return ((MarketingStrategyItemMapper)this.baseMapper).itemExportGetTotal(dto);
    }

    public Page<MarketStrategyItemExportVo> itemExportGetDate(Page<MarketStrategyItemExportVo> page, MarketingStrategyItemDto dto) {
        return ((MarketingStrategyItemMapper)this.baseMapper).itemExportGetDate(page, dto);
    }

    public void updateCloseStatus(List<String> strategyItemCodeList) {
        if (org.springframework.util.CollectionUtils.isEmpty(strategyItemCodeList)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(MarketingStrategyItem::getIsClose, (Object)BooleanEnum.TRUE.getCapital());
        updateWrapper.in(MarketingStrategyItem::getStrategyItemCode, strategyItemCodeList);
        updateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        this.update((Wrapper)updateWrapper);
        this.marketingStrategyBudgetRepository.updateHeadStatus(strategyItemCodeList);
    }
}

