/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.marketing.strategy.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.util.NumberStringDealUtil;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategy;
import com.biz.crm.tpm.business.marketing.strategy.local.mapper.MarketingStrategyMapper;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MarketingStrategyRepository
extends ServiceImpl<MarketingStrategyMapper, MarketingStrategy> {
    @Autowired(required=false)
    private MarketingStrategyMapper marketingStrategyMapper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public void deleteByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(UuidEntity::getId, ids);
        this.update((Wrapper)updateWrapper);
    }

    public Page<MarketingStrategyVo> findByConditions(Pageable pageable, MarketingStrategyDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<MarketingStrategyVo> pageList = this.marketingStrategyMapper.findByConditions((Page<MarketingStrategyVo>)page, dto);
        this.fillVoListProperties(pageList.getRecords());
        return pageList;
    }

    public final List<MarketingStrategy> findList(MarketingStrategyDto dto) {
        return this.findList(dto, null);
    }

    @SafeVarargs
    public final List<MarketingStrategy> findList(MarketingStrategyDto dto, SFunction<MarketingStrategy, ?> ... columns) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(MarketingStrategy.class);
        wrapper.eq(StringUtils.isNotBlank((CharSequence)dto.getStrategyCode()), MarketingStrategy::getStrategyCode, (Object)dto.getStrategyCode());
        wrapper.eq(StringUtils.isNotBlank((CharSequence)dto.getBusinessFormatCode()), MarketingStrategy::getBusinessFormatCode, (Object)dto.getBusinessFormatCode());
        wrapper.eq(StringUtils.isNotBlank((CharSequence)dto.getBusinessUnitCode()), MarketingStrategy::getBusinessUnitCode, (Object)dto.getBusinessUnitCode());
        wrapper.eq(StringUtils.isNotBlank((CharSequence)dto.getAttrOrgCode()), MarketingStrategy::getAttrOrgCode, (Object)dto.getAttrOrgCode());
        wrapper.eq(StringUtils.isNotBlank((CharSequence)dto.getStrategyType()), MarketingStrategy::getStrategyType, (Object)dto.getStrategyType());
        wrapper.eq(StringUtils.isNotBlank((CharSequence)dto.getStrategyYear()), MarketingStrategy::getStrategyYear, (Object)dto.getStrategyYear());
        wrapper.eq(StringUtils.isNotBlank((CharSequence)dto.getCreateAccount()), UuidOpEntity::getCreateAccount, (Object)dto.getCreateAccount());
        wrapper.eq(StringUtils.isNotBlank((CharSequence)dto.getProcessStatus()), MarketingStrategy::getProcessStatus, (Object)dto.getProcessStatus());
        wrapper.eq(MarketingStrategy::getIsValidate, (Object)BooleanEnum.TRUE.getCapital());
        if (!CollectionUtils.isEmpty((Collection)dto.getStrategyCodeList())) {
            wrapper.in(MarketingStrategy::getStrategyCode, (Collection)dto.getStrategyCodeList());
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getProcessStatusList())) {
            wrapper.in(MarketingStrategy::getProcessStatus, (Collection)dto.getProcessStatusList());
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getStrategyCodeList())) {
            wrapper.in(MarketingStrategy::getStrategyCode, (Collection)dto.getStrategyCodeList());
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getAttrOrgCodeList())) {
            wrapper.in(MarketingStrategy::getAttrOrgCode, (Collection)dto.getAttrOrgCodeList());
        }
        ((LambdaQueryWrapper)wrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        if (null != columns && columns.length > 0) {
            wrapper.select(columns);
        }
        return this.list((Wrapper)wrapper);
    }

    public List<String> findCodeList(MarketingStrategyDto dto) {
        return this.findList(dto, MarketingStrategy::getStrategyCode).stream().map(MarketingStrategy::getStrategyCode).collect(Collectors.toList());
    }

    public void updateProcessStatus(List<String> codeList, String processStatus) {
        if (CollectionUtils.isEmpty(codeList)) {
            return;
        }
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(MarketingStrategy.class).set(MarketingStrategy::getProcessStatus, (Object)processStatus)).in(MarketingStrategy::getStrategyCode, codeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode()));
    }

    public void updateProcessStatusAndProcessNo(List<String> codeList, String processStatus, String processNo) {
        if (CollectionUtils.isEmpty(codeList)) {
            return;
        }
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(MarketingStrategy.class).set(MarketingStrategy::getProcessStatus, (Object)processStatus)).set(MarketingStrategy::getProcessNo, (Object)processNo)).in(MarketingStrategy::getStrategyCode, codeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode()));
    }

    public MarketingStrategyVo getVoById(String id) {
        MarketingStrategy entity = (MarketingStrategy)((Object)this.getById((Serializable)((Object)id)));
        if (null == entity) {
            return null;
        }
        MarketingStrategyVo vo = (MarketingStrategyVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, MarketingStrategyVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.fillVoProperties(vo);
        return vo;
    }

    public void fillVoListProperties(List<MarketingStrategyVo> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        for (MarketingStrategyVo item : voList) {
            this.fillVoProperties(item);
        }
    }

    public void fillVoProperties(MarketingStrategyVo item) {
        if (null == item) {
            return;
        }
        NumberStringDealUtil.setStringIfNotNull((Object)item.getStrategySign(), arg_0 -> ((MarketingStrategyVo)item).setStrategySignStr(arg_0));
        NumberStringDealUtil.setStringIfNotNull((Object)item.getFeeAmount(), arg_0 -> ((MarketingStrategyVo)item).setFeeAmountStr(arg_0));
        BigDecimal feeAmount = Optional.ofNullable(item.getFeeAmount()).orElse(BigDecimal.ZERO);
        BigDecimal usedAmount = Optional.ofNullable(item.getUsedAmount()).orElse(BigDecimal.ZERO);
        BigDecimal closeAmount = Optional.ofNullable(item.getCloseAmount()).orElse(BigDecimal.ZERO);
        item.setUsedAmount(usedAmount);
        item.setUsableAmount(feeAmount.subtract(usedAmount).subtract(closeAmount));
    }

    public void updateFeeAmount(List<String> strategyCodeList) {
        this.marketingStrategyMapper.updateFeeAmount(strategyCodeList);
    }
}

