/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.marketing.strategy.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategy;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategyBudget;
import com.biz.crm.tpm.business.marketing.strategy.local.repository.MarketingStrategyBudgetRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.repository.MarketingStrategyItemRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.repository.MarketingStrategyRepository;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.OperateMarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.service.MarketingStrategyBudgetSdkService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyBudgetVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDetailDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MarketingStrategyBudgetSdkServiceImpl
implements MarketingStrategyBudgetSdkService {
    @Autowired(required=false)
    private MarketingStrategyBudgetRepository marketingStrategyBudgetRepository;
    @Autowired(required=false)
    private MarketingStrategyItemRepository marketingStrategyItemRepository;
    @Autowired(required=false)
    private MarketingStrategyRepository marketingStrategyRepository;
    @Autowired(required=false)
    private MarketingStrategyBudgetSdkServiceImpl marketingStrategyBudgetSdkService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private MonthBudgetLockService monthBudgetLockService;

    public List<MarketingStrategyBudgetDto> findListByConditions(MarketingStrategyBudgetDto dto) {
        return this.marketingStrategyBudgetRepository.findListByConditions(dto);
    }

    public List<String> listBudgetCodeListByStrategyCodeList(List<String> strategyCodes) {
        return this.marketingStrategyItemRepository.listBudgetCodeListByStrategyCodeList(strategyCodes);
    }

    public Page<MarketingStrategyBudgetVo> findByConditions(Pageable pageable, MarketingStrategyBudgetDto dto) {
        return this.marketingStrategyBudgetRepository.findByConditions(pageable, dto);
    }

    public void operateAmount(List<OperateMarketingStrategyBudgetDto> operateList) {
        if (CollectionUtils.isEmpty(operateList)) {
            return;
        }
        Set monthBudgetCodeSet = operateList.stream().map(OperateMonthBudgetDto::getMonthBudgetCode).filter(Objects::nonNull).collect(Collectors.toSet());
        try {
            Validate.isTrue((boolean)this.monthBudgetLockService.lock(new ArrayList(monthBudgetCodeSet), TimeUnit.SECONDS, 1200), (String)"\u9884\u7b97\u52a0\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
            this.operateAmount(operateList, Maps.newHashMap());
        }
        finally {
            this.monthBudgetLockService.unLock(new ArrayList(monthBudgetCodeSet));
        }
    }

    public void operateAmount(List<OperateMarketingStrategyBudgetDto> operateList, Map<String, BigDecimal> looseAmountMap) {
        operateList.forEach(dto -> {
            if (!this.redisLockService.isLock("month_budget:lock:" + dto.getMonthBudgetCode())) {
                throw new RuntimeException("\u9884\u7b97\u64cd\u4f5c\u5931\u8d25\uff0c\u6708\u5ea6\u9884\u7b97" + dto.getMonthBudgetCode() + "\u672a\u52a0\u9501\uff01");
            }
        });
        List<MarketingStrategyBudgetDto> budgetDtos = this.validateOperateBudget(operateList);
        Map budgetEntityMap = budgetDtos.stream().collect(Collectors.toMap(item -> item.getStrategyItemCode() + item.getMonthBudgetCode(), Function.identity()));
        List strategyCodeList = budgetDtos.stream().map(MarketingStrategyBudgetDto::getStrategyCode).distinct().collect(Collectors.toList());
        MarketingStrategyDto marketingStrategyDto = new MarketingStrategyDto();
        marketingStrategyDto.setStrategyCodeList(strategyCodeList);
        List<MarketingStrategy> entityList = this.marketingStrategyRepository.findList(marketingStrategyDto);
        Map strategyMap = entityList.stream().collect(Collectors.toMap(MarketingStrategy::getStrategyCode, Function.identity()));
        ArrayList detailList = Lists.newArrayList();
        for (OperateMarketingStrategyBudgetDto operateMonthBudgetDto : operateList) {
            String budgetKey = operateMonthBudgetDto.getStrategyItemCode() + operateMonthBudgetDto.getMonthBudgetCode();
            MarketingStrategyBudgetDto monthBudgetEntity = (MarketingStrategyBudgetDto)budgetEntityMap.get(budgetKey);
            String operationType = operateMonthBudgetDto.getOperationType();
            BigDecimal operationAmount = operateMonthBudgetDto.getOperationAmount();
            BigDecimal looseAmount = looseAmountMap.getOrDefault(budgetKey, BigDecimal.ZERO);
            MarketingStrategy marketingStrategy = (MarketingStrategy)((Object)strategyMap.get(monthBudgetEntity.getStrategyCode()));
            BigDecimal strategyUsedAmount = Optional.ofNullable(marketingStrategy.getUsedAmount()).orElse(BigDecimal.ZERO);
            BigDecimal closeAmount = Optional.ofNullable(marketingStrategy.getCloseAmount()).orElse(BigDecimal.ZERO);
            BigDecimal usableAmount = Optional.ofNullable(marketingStrategy.getFeeAmount()).orElse(BigDecimal.ZERO).subtract(strategyUsedAmount).subtract(closeAmount).add(looseAmount);
            if (BudgetOperationTypeEnum.USE.getCode().equals(operationType)) {
                Validate.isTrue((usableAmount.compareTo(operationAmount) >= 0 ? 1 : 0) != 0, (String)("[" + operateMonthBudgetDto.getBusinessCode() + "]\u4f7f\u7528\u91d1\u989d[" + operationAmount + "]\u5927\u4e8e\u5f53\u524d\u7b56\u7565\u53ef\u7528\u91d1\u989d" + usableAmount + "\uff0c\u8bf7\u68c0\u67e5\uff01"), (Object[])new Object[0]);
                monthBudgetEntity.setUsedAmount(monthBudgetEntity.getUsedAmount().add(operationAmount));
                marketingStrategy.setUsedAmount(strategyUsedAmount.add(operationAmount));
                continue;
            }
            if (BudgetOperationTypeEnum.RETURN.getCode().equals(operationType)) {
                monthBudgetEntity.setUsedAmount(monthBudgetEntity.getUsedAmount().subtract(operationAmount));
                marketingStrategy.setUsedAmount(strategyUsedAmount.subtract(operationAmount));
                continue;
            }
            throw new RuntimeException("\u7b56\u7565\u9884\u7b97\u64cd\u4f5c\u7c7b\u578b\u6709\u8bef\uff01");
        }
        Boolean doSave = operateList.get(0).getDoSave();
        if (null == doSave || doSave.booleanValue()) {
            this.marketingStrategyBudgetSdkService.updateOperateBudget(budgetEntityMap.values(), detailList);
        }
    }

    public List<MarketingStrategyBudgetDto> validateOperateBudget(List<OperateMarketingStrategyBudgetDto> operateList) {
        for (OperateMarketingStrategyBudgetDto operateMonthBudgetDto : operateList) {
            Validate.notEmpty((CharSequence)operateMonthBudgetDto.getMonthBudgetCode(), (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)operateMonthBudgetDto.getOperationAmount(), (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)operateMonthBudgetDto.getOperationType(), (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)operateMonthBudgetDto.getStrategyItemCode(), (String)"\u64cd\u4f5c\u7b56\u7565\u9884\u7b97\u65f6\uff0c\u7b56\u7565\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
        List<String> operateCodeList = operateList.stream().map(item -> item.getStrategyItemCode() + item.getMonthBudgetCode()).distinct().collect(Collectors.toList());
        List<MarketingStrategyBudgetDto> budgetEntityList = this.marketingStrategyBudgetRepository.listBudgetInfoByOperateList(operateCodeList);
        if (budgetEntityList.size() < operateCodeList.size()) {
            List existsCodes = budgetEntityList.stream().map(item -> item.getStrategyItemCode() + item.getMonthBudgetCode()).collect(Collectors.toList());
            String notExistsJoinCodesStr = operateCodeList.stream().filter(item -> !existsCodes.contains(item)).collect(Collectors.joining(","));
            throw new RuntimeException("\u7b56\u7565\u9884\u7b97\u5360\u7528\u64cd\u4f5c\u5931\u8d25\uff0c\u7b56\u7565\u660e\u7ec6[" + notExistsJoinCodesStr + "]\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7b56\u7565\u662f\u5426\u542f\u7528\u6216\u662f\u5426\u5b58\u5728\uff01\uff01");
        }
        for (MarketingStrategyBudgetDto marketingStrategyBudgetDto : budgetEntityList) {
            if (BooleanEnum.TRUE.getCapital().equals(marketingStrategyBudgetDto.getIsClose())) {
                throw new RuntimeException("\u5173\u8054\u7b56\u7565\u660e\u7ec6[" + marketingStrategyBudgetDto.getStrategyItemCode() + "]\u5df2\u88ab\u5173\u95ed\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u53ef\u7528\u7b56\u7565\u660e\u7ec6");
            }
            if (null == marketingStrategyBudgetDto.getUseAmount()) {
                marketingStrategyBudgetDto.setUseAmount(BigDecimal.ZERO);
            }
            if (null != marketingStrategyBudgetDto.getUsedAmount()) continue;
            marketingStrategyBudgetDto.setUsedAmount(BigDecimal.ZERO);
        }
        return budgetEntityList;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateOperateBudget(Collection<MarketingStrategyBudgetDto> budgetList, List<MonthBudgetDetailDto> detailList) {
        if (!CollectionUtils.isEmpty(budgetList)) {
            Collection marketingStrategyBudgets = this.nebulaToolkitService.copyCollectionByWhiteList(budgetList, MarketingStrategyBudgetDto.class, MarketingStrategyBudget.class, HashSet.class, ArrayList.class, new String[0]);
            this.marketingStrategyBudgetRepository.updateBatchById(marketingStrategyBudgets);
            List<String> strategyCodeList = budgetList.stream().map(MarketingStrategyBudgetDto::getStrategyCode).distinct().collect(Collectors.toList());
            this.marketingStrategyBudgetRepository.updateStrategyUsedAmount(strategyCodeList);
        }
    }
}

