/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.marketing.strategy.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategy;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategyBudget;
import com.biz.crm.tpm.business.marketing.strategy.local.repository.MarketingStrategyBudgetRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.repository.MarketingStrategyRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.service.MarketingStrategyBudgetService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.service.MarketingStrategyLockSdkService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyBudgetVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.year.budget.sdk.dto.OperateYearBudgetDto;
import com.biz.crm.tpm.business.year.budget.sdk.service.YearBudgetSdkService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class MarketingStrategyBudgetServiceImpl
implements MarketingStrategyBudgetService {
    @Autowired(required=false)
    private MarketingStrategyBudgetRepository activityDetailPlanBudgetRepository;
    @Autowired(required=false)
    private MarketingStrategyRepository marketingStrategyRepository;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private YearBudgetSdkService yearBudgetSdkService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private MarketingStrategyLockSdkService marketingStrategyLockSdkService;

    @Override
    public Page<MarketingStrategyBudgetVo> findByConditions(Pageable pageable, MarketingStrategyBudgetDto dto) {
        return this.activityDetailPlanBudgetRepository.findByConditions(pageable, dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveMarketingStrategyBudgetList(MarketingStrategy entity, boolean update, List<MarketingStrategyItemDto> itemDtoList) {
        HashMap oldMap = Maps.newHashMap();
        if (update) {
            this.activityDetailPlanBudgetRepository.deletePhysicalByStrategyCode(entity.getStrategyCode());
        }
        ArrayList list = Lists.newArrayList();
        for (MarketingStrategyItemDto itemDto : itemDtoList) {
            ArrayList budgetList = Lists.newArrayList();
            List budgetShares = itemDto.getBudgetShares();
            if (!CollectionUtils.isEmpty((Collection)budgetShares)) {
                Collection budgetShareEntityList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)budgetShares, MarketingStrategyBudgetDto.class, MarketingStrategyBudget.class, HashSet.class, ArrayList.class, new String[0]);
                for (MarketingStrategyBudget monthBudget : budgetShareEntityList) {
                    monthBudget.setStrategyCode(itemDto.getStrategyCode());
                    monthBudget.setStrategyItemCode(itemDto.getStrategyItemCode());
                }
                budgetList.addAll(budgetShareEntityList);
            }
            list.addAll(budgetList);
        }
        ArrayList saveList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        for (MarketingStrategyBudget item : list) {
            item.setStrategyCode(entity.getStrategyCode());
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item.setTenantCode(entity.getTenantCode());
            item.setId(null);
            saveList.add(item);
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            this.activityDetailPlanBudgetRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty((Collection)updateList)) {
            this.activityDetailPlanBudgetRepository.updateBatchById(updateList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void useMonthBudgetByCodeList(List<String> codeList) {
        if (CollectionUtil.isEmpty(codeList)) {
            return;
        }
        this.useMonthBudgetByCodeList(codeList, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void useMonthBudgetByCodeList(List<String> codeList, boolean doSave) {
        List<MarketingStrategyBudget> budgets = this.activityDetailPlanBudgetRepository.listByStrategyCodeList(codeList);
        if (CollectionUtils.isEmpty(budgets)) {
            return;
        }
        List budgetDtos = (List)this.nebulaToolkitService.copyCollectionByBlankList(budgets, MarketingStrategyBudget.class, MarketingStrategyBudgetDto.class, HashSet.class, ArrayList.class, new String[0]);
        MarketingStrategyDto marketingStrategyDto = new MarketingStrategyDto();
        marketingStrategyDto.setStrategyCodeList(codeList);
        List<MarketingStrategy> strategyList = this.marketingStrategyRepository.findList(marketingStrategyDto);
        String businessUnitCode = strategyList.get(0).getBusinessUnitCode();
        for (MarketingStrategyBudgetDto budgetDto : budgetDtos) {
            budgetDto.setBusinessUnitCode(businessUnitCode);
        }
        this.useMonthBudget(budgetDtos, doSave);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void useMonthBudget(List<MarketingStrategyBudgetDto> budgetList, boolean doSave) {
        if (CollectionUtils.isEmpty(budgetList)) {
            return;
        }
        String businessUnitCode = budgetList.get(0).getBusinessUnitCode();
        if (!BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)) {
            List planBudgetOperateList = budgetList.stream().filter(item -> null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0).map(item -> new OperateMonthBudgetDto((MarketingStrategyBudgetDto)item, doSave){
                final /* synthetic */ MarketingStrategyBudgetDto val$item;
                final /* synthetic */ boolean val$doSave;
                {
                    this.val$item = marketingStrategyBudgetDto;
                    this.val$doSave = bl;
                    this.setBusinessCode(this.val$item.getStrategyItemCode());
                    this.setMonthBudgetCode(this.val$item.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                    this.setOperationAmount(this.val$item.getUseAmount());
                    this.setDoSave(this.val$doSave);
                }
            }).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(planBudgetOperateList)) {
                this.monthBudgetService.operateBudgetStrategy(planBudgetOperateList);
            }
        } else {
            List planBudgetOperateList = budgetList.stream().filter(item -> null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0).map(item -> new OperateYearBudgetDto((MarketingStrategyBudgetDto)item, doSave){
                final /* synthetic */ MarketingStrategyBudgetDto val$item;
                final /* synthetic */ boolean val$doSave;
                {
                    this.val$item = marketingStrategyBudgetDto;
                    this.val$doSave = bl;
                    this.setBusinessCode(this.val$item.getStrategyItemCode());
                    this.setYearBudgetCode(this.val$item.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                    this.setOperationAmount(this.val$item.getUseAmount());
                    this.setDoSave(this.val$doSave);
                }
            }).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(planBudgetOperateList)) {
                this.yearBudgetSdkService.operateBudgetStrategy(planBudgetOperateList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByStrategyCodes(List<String> strategyCodes) {
        this.activityDetailPlanBudgetRepository.deleteByStrategyCodes(strategyCodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void returnMonthBudgetByCodeList(List<String> codeList) {
        if (CollectionUtil.isEmpty(codeList)) {
            return;
        }
        boolean lockSuccess = this.marketingStrategyLockSdkService.lock(codeList, TimeUnit.MINUTES, 3);
        Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
        try {
            List<MarketingStrategyBudget> budgetList = this.activityDetailPlanBudgetRepository.listByStrategyCodeList(codeList);
            if (!CollectionUtils.isEmpty(budgetList)) {
                List budgetDtos = (List)this.nebulaToolkitService.copyCollectionByBlankList(budgetList, MarketingStrategyBudget.class, MarketingStrategyBudgetDto.class, HashSet.class, ArrayList.class, new String[0]);
                MarketingStrategyDto marketingStrategyDto = new MarketingStrategyDto();
                marketingStrategyDto.setStrategyCode(codeList.get(0));
                List<MarketingStrategy> strategyList = this.marketingStrategyRepository.findList(marketingStrategyDto);
                ((MarketingStrategyBudgetDto)budgetDtos.get(0)).setBusinessUnitCode(strategyList.get(0).getBusinessUnitCode());
                this.returnMonthBudget(budgetDtos);
            }
        }
        finally {
            this.marketingStrategyLockSdkService.unlock(codeList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void returnMonthBudget(List<MarketingStrategyBudgetDto> budgetList) {
        if (CollectionUtils.isEmpty(budgetList)) {
            return;
        }
        String businessUnitCode = budgetList.get(0).getBusinessUnitCode();
        if (!BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)) {
            List planBudgetOperateList = budgetList.stream().filter(item -> null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0).map(item -> new OperateMonthBudgetDto((MarketingStrategyBudgetDto)item){
                final /* synthetic */ MarketingStrategyBudgetDto val$item;
                {
                    this.val$item = marketingStrategyBudgetDto;
                    this.setBusinessCode(this.val$item.getStrategyItemCode());
                    this.setMonthBudgetCode(this.val$item.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                    this.setOperationAmount(this.val$item.getUseAmount());
                }
            }).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(planBudgetOperateList)) {
                this.monthBudgetService.operateBudgetStrategy(planBudgetOperateList);
            }
        } else {
            List planBudgetOperateList = budgetList.stream().filter(item -> null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0).map(item -> new OperateYearBudgetDto((MarketingStrategyBudgetDto)item){
                final /* synthetic */ MarketingStrategyBudgetDto val$item;
                {
                    this.val$item = marketingStrategyBudgetDto;
                    this.setBusinessCode(this.val$item.getStrategyItemCode());
                    this.setYearBudgetCode(this.val$item.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                    this.setOperationAmount(this.val$item.getUseAmount());
                }
            }).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(planBudgetOperateList)) {
                this.yearBudgetSdkService.operateBudgetStrategy(planBudgetOperateList);
            }
        }
    }
}

