/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.marketing.strategy.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.tpm.business.marketing.strategy.local.service.MarketingStrategyItemService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.service.MarketingStrategyItemSdkService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyItemVo;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class MarketingStrategyItemSdkServiceImpl
implements MarketingStrategyItemSdkService {
    @Autowired(required=false)
    private MarketingStrategyItemService marketingStrategyItemService;
    @Autowired(required=false)
    private OrgVoService orgVoService;

    public Page<MarketingStrategyItemVo> findByConditions(Pageable pageable, MarketingStrategyItemDto dto) {
        if (!StringUtils.isEmpty((Object)dto.getAttrOrgCode())) {
            List<String> attrOrgCodeList = Arrays.asList(dto.getAttrOrgCode().split(","));
            List childOrgList = this.orgVoService.findAllChildrenByOrgCodes(attrOrgCodeList);
            if (!CollectionUtils.isEmpty((Collection)childOrgList)) {
                dto.setAttrOrgCodeList(childOrgList.stream().map(OrgVo::getOrgCode).collect(Collectors.toList()));
            } else {
                dto.setAttrOrgCodeList(attrOrgCodeList);
            }
        }
        return this.marketingStrategyItemService.findByConditions(pageable, dto);
    }

    public List<MarketingStrategyItemVo> findByItemCodes(List<String> itemCodes) {
        return this.marketingStrategyItemService.findByCodes(itemCodes);
    }
}

