/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.marketing.strategy.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateStringDealUtil;
import com.biz.crm.mn.common.base.util.NumberStringDealUtil;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormSelectDto;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.type.sdk.dto.ActivityTypeSelectDto;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategy;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategyBudget;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategyItem;
import com.biz.crm.tpm.business.marketing.strategy.local.repository.MarketingStrategyBudgetRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.repository.MarketingStrategyItemRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.repository.MarketingStrategyRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.service.MarketingStrategyBudgetService;
import com.biz.crm.tpm.business.marketing.strategy.local.service.MarketingStrategyItemService;
import com.biz.crm.tpm.business.marketing.strategy.local.vo.MarketingStrategyBudgetSumVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyQueryActivityPlanDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.enums.MarketingStrategyBudgetShareRuleEnum;
import com.biz.crm.tpm.business.marketing.strategy.sdk.event.MarketingStrategyQueryActivityPlanListener;
import com.biz.crm.tpm.business.marketing.strategy.sdk.pojo.MarketingStrategyItemBase;
import com.biz.crm.tpm.business.marketing.strategy.sdk.pojo.MarketingStrategyItemScope;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketStrategyItemExportVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyItemVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyQueryActivityPlanResponse;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.StrategyActivityPlanItemVo;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.biz.crm.tpm.business.year.budget.sdk.service.YearBudgetSdkService;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="marketingStrategyItemService")
public class MarketingStrategyItemServiceImpl
extends MnPageCacheServiceImpl<MarketingStrategyItemVo, MarketingStrategyItemDto>
implements MarketingStrategyItemService {
    @Autowired(required=false)
    private MarketingStrategyItemRepository marketingStrategyItemRepository;
    @Autowired(required=false)
    private MarketingStrategyRepository marketingStrategyRepository;
    @Autowired(required=false)
    private MarketingStrategyBudgetRepository marketingStrategyBudgetRepository;
    @Autowired(required=false)
    private MarketingStrategyBudgetService marketingStrategyBudgetService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private ActivityTypeService activityTypeService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private YearBudgetSdkService yearBudgetSdkService;
    @Autowired(required=false)
    private SalesGoalService salesGoalService;
    @Autowired(required=false)
    private BudgetItemService budgetItemService;

    @Override
    public Page<MarketingStrategyItemVo> findByConditions(Pageable pageable, MarketingStrategyItemDto dto) {
        return this.marketingStrategyItemRepository.findByConditions(pageable, dto);
    }

    @Override
    public List<MarketingStrategyBudgetSumVo> findMarketingStrategyBudgetCacheSumList(String businessUnitCode, String cacheKey) {
        if (BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)) {
            return this.findVerticalMarketingStrategyBudgetCacheSumList(businessUnitCode, cacheKey);
        }
        List<MarketingStrategyItemDto> itemList = this.findCacheList(cacheKey);
        HashMap budgetSumVoMap = Maps.newHashMap();
        HashSet feeBudgetCodeSet = Sets.newHashSet();
        for (MarketingStrategyItemDto item2 : itemList) {
            if (StringUtils.isEmpty((CharSequence)item2.getMonthBudgetCode())) continue;
            MarketingStrategyBudgetSumVo budgetSumVo = budgetSumVoMap.computeIfAbsent(item2.getMonthBudgetCode(), key -> new MarketingStrategyBudgetSumVo(){
                {
                    this.setTotalStrategyAmount(BigDecimal.ZERO);
                    this.setInitResolveAmount(BigDecimal.ZERO);
                    this.setUsedStrategyAmount(BigDecimal.ZERO);
                    this.setCanApplyStrategyAmount(BigDecimal.ZERO);
                }
            });
            budgetSumVo.setMonthBudgetCode(item2.getMonthBudgetCode());
            budgetSumVo.setBudgetItemName(item2.getBudgetItemName());
            if (StringUtils.isNotEmpty((CharSequence)item2.getFeeAmountStr())) {
                try {
                    budgetSumVo.setTotalStrategyAmount(budgetSumVo.getTotalStrategyAmount().add(new BigDecimal(item2.getFeeAmountStr())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            feeBudgetCodeSet.add(item2.getMonthBudgetCode());
        }
        if (feeBudgetCodeSet.size() > 0) {
            ArrayList feeBudgetCodeList = Lists.newArrayList((Iterable)feeBudgetCodeSet);
            List budgetVos = this.monthBudgetService.findByCodes((List)feeBudgetCodeList, null);
            for (MonthBudgetVo budgetVo : budgetVos) {
                MarketingStrategyBudgetSumVo budgetSumVo = (MarketingStrategyBudgetSumVo)budgetSumVoMap.get(budgetVo.getMonthBudgetCode());
                budgetSumVo.setYearMonthLy(budgetVo.getYearMonthLy());
                budgetSumVo.setBudgetItemCode(budgetVo.getBudgetItemCode());
                budgetSumVo.setBudgetItemName(budgetVo.getBudgetItemName());
                budgetSumVo.setFeeBelongCode(budgetVo.getFeeBelongCode());
                if (null != budgetVo.getInitResolveAmount()) {
                    budgetSumVo.setInitResolveAmount(budgetVo.getInitResolveAmount());
                }
                if (null != budgetVo.getMonthRollingAmount()) {
                    budgetSumVo.setMonthRollingAmount(budgetVo.getMonthRollingAmount());
                }
                if (null != budgetVo.getLastMonthRollingAmount()) {
                    budgetSumVo.setLastMonthRollingAmount(budgetVo.getLastMonthRollingAmount());
                }
                if (null != budgetVo.getAfterFreezeAmount()) {
                    budgetSumVo.setAfterFreezeAmount(budgetVo.getAfterFreezeAmount());
                }
                if (null == budgetVo.getUsedStrategyAmount()) continue;
                budgetSumVo.setUsedStrategyAmount(budgetVo.getUsedStrategyAmount());
            }
        }
        ArrayList<MarketingStrategyBudgetSumVo> budgetSumList = new ArrayList<MarketingStrategyBudgetSumVo>(budgetSumVoMap.values());
        budgetSumList.forEach(item -> item.setCanApplyStrategyAmount(item.getAfterFreezeAmount().subtract(item.getUsedStrategyAmount())));
        return budgetSumList;
    }

    public List<MarketingStrategyBudgetSumVo> findVerticalMarketingStrategyBudgetCacheSumList(String businessUnitCode, String cacheKey) {
        List<MarketingStrategyItemDto> itemList = this.findCacheList(cacheKey);
        HashMap budgetSumVoMap = Maps.newHashMap();
        HashSet feeBudgetCodeSet = Sets.newHashSet();
        for (MarketingStrategyItemDto item2 : itemList) {
            List budgetShares = item2.getBudgetShares();
            if (CollectionUtils.isEmpty((Collection)budgetShares)) continue;
            for (MarketingStrategyBudgetDto budgetShare : budgetShares) {
                if (StringUtils.isBlank((CharSequence)budgetShare.getMonthBudgetCode())) continue;
                MarketingStrategyBudgetSumVo budgetSumVo = budgetSumVoMap.computeIfAbsent(budgetShare.getMonthBudgetCode(), key -> new MarketingStrategyBudgetSumVo(){
                    {
                        this.setTotalStrategyAmount(BigDecimal.ZERO);
                        this.setInitResolveAmount(BigDecimal.ZERO);
                        this.setUsedStrategyAmount(BigDecimal.ZERO);
                        this.setCanApplyStrategyAmount(BigDecimal.ZERO);
                    }
                });
                budgetSumVo.setMonthBudgetCode(budgetShare.getMonthBudgetCode());
                budgetSumVo.setBudgetItemName(budgetShare.getBudgetItemName());
                if (StringUtils.isNotEmpty((CharSequence)budgetShare.getUseAmountStr())) {
                    try {
                        budgetSumVo.setTotalStrategyAmount(budgetSumVo.getTotalStrategyAmount().add(new BigDecimal(budgetShare.getUseAmountStr())));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                feeBudgetCodeSet.add(budgetShare.getMonthBudgetCode());
            }
        }
        if (feeBudgetCodeSet.size() > 0) {
            ArrayList feeBudgetCodeList = Lists.newArrayList((Iterable)feeBudgetCodeSet);
            List budgetVos = this.yearBudgetSdkService.findByYearBudgetCodes((List)feeBudgetCodeList);
            for (YearBudgetVo budgetVo : budgetVos) {
                MarketingStrategyBudgetSumVo budgetSumVo = (MarketingStrategyBudgetSumVo)budgetSumVoMap.get(budgetVo.getYearBudgetCode());
                budgetSumVo.setYearMonthLy(budgetVo.getYearLy());
                budgetSumVo.setBudgetItemCode(budgetVo.getBudgetItemCode());
                budgetSumVo.setBudgetItemName(budgetVo.getBudgetItemName());
                budgetSumVo.setFeeBelongCode(budgetVo.getFeeBelongCode());
                if (null != budgetVo.getBudgetTotalAmount()) {
                    budgetSumVo.setAfterFreezeAmount(budgetVo.getBudgetTotalAmount());
                }
                if (null == budgetVo.getUsedStrategyAmount()) continue;
                budgetSumVo.setUsedStrategyAmount(budgetVo.getUsedStrategyAmount());
            }
        }
        ArrayList<MarketingStrategyBudgetSumVo> budgetSumList = new ArrayList<MarketingStrategyBudgetSumVo>(budgetSumVoMap.values());
        budgetSumList.forEach(item -> item.setCanApplyStrategyAmount(item.getAfterFreezeAmount().subtract(item.getUsedStrategyAmount())));
        return budgetSumList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveMarketingStrategyItemList(MarketingStrategy entity, boolean update, List<MarketingStrategyItemDto> itemCacheList) {
        this.saveMarketingStrategyItemList(entity, update, itemCacheList, true, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveMarketingStrategyItemList(MarketingStrategy entity, boolean update, List<MarketingStrategyItemDto> itemCacheList, boolean createValidate, boolean tempSave) {
        MarketingStrategyDto dto;
        if (createValidate && !tempSave) {
            dto = (MarketingStrategyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, MarketingStrategyDto.class, HashSet.class, ArrayList.class, new String[0]);
            this.createValidateList(dto, itemCacheList);
        } else if (tempSave) {
            dto = (MarketingStrategyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, MarketingStrategyDto.class, HashSet.class, ArrayList.class, new String[0]);
            this.tempSaveCreateValidateList(dto, itemCacheList);
        }
        Map<Object, Object> oldMap = Maps.newHashMap();
        if (update) {
            List<MarketingStrategyItem> oldList = this.marketingStrategyItemRepository.findListByStrategyCode(entity.getStrategyCode());
            oldMap = oldList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
        }
        ArrayList saveList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        HashMap dtoMap = Maps.newHashMap();
        for (MarketingStrategyItemDto item : itemCacheList) {
            dtoMap.put(item.getId(), item);
            item.setStrategyCode(entity.getStrategyCode());
            if (oldMap.containsKey(item.getId())) {
                MarketingStrategyItem oldItemEntity = (MarketingStrategyItem)((Object)oldMap.get(item.getId()));
                item.setStrategyItemCode(oldItemEntity.getStrategyItemCode());
                MarketingStrategyItem itemEntity = (MarketingStrategyItem)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, MarketingStrategyItem.class, HashSet.class, ArrayList.class, new String[0]));
                updateList.add(itemEntity);
                oldMap.remove(item.getId());
                continue;
            }
            MarketingStrategyItem itemEntity = (MarketingStrategyItem)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, MarketingStrategyItem.class, HashSet.class, ArrayList.class, new String[0]));
            saveList.add(itemEntity);
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            String yyyyMMdd = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
            List codeList = this.generateCodeService.generateCode("MX", saveList.size(), Integer.valueOf(6), 2L, TimeUnit.DAYS);
            Iterator codeIterator = codeList.iterator();
            for (MarketingStrategyItem item : saveList) {
                item.setStrategyItemCode((String)codeIterator.next());
                MarketingStrategyItemDto dto2 = (MarketingStrategyItemDto)dtoMap.get(item.getId());
                dto2.setStrategyItemCode(item.getStrategyItemCode());
                item.setStrategyCode(entity.getStrategyCode());
                item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                item.setTenantCode(entity.getTenantCode());
                item.setId(null);
            }
            this.marketingStrategyItemRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty((Collection)updateList)) {
            this.marketingStrategyItemRepository.updateBatchById(updateList);
        }
        if (oldMap.size() > 0) {
            this.marketingStrategyItemRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }
    }

    public List<MarketingStrategyItemDto> findCacheList(String cacheKey) {
        List itemList = super.findCacheList(cacheKey);
        ArrayList newList = Lists.newArrayList();
        for (MarketingStrategyItemDto dto : itemList) {
            List scopeList = dto.getScopeList();
            if (!CollectionUtils.isEmpty((Collection)scopeList)) {
                dto.setScopeList(null);
                for (int i = 0; i < scopeList.size(); ++i) {
                    MarketingStrategyItemScope scopeVo = (MarketingStrategyItemScope)scopeList.get(i);
                    MarketingStrategyItemDto newDto = (MarketingStrategyItemDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, MarketingStrategyItemDto.class, HashSet.class, ArrayList.class, new String[0]);
                    if (i > 0) {
                        newDto.setId(null);
                    }
                    newDto.setStrategyOrgCode(scopeVo.getScopeCode());
                    newDto.setStrategyOrgName(scopeVo.getScopeName());
                    newDto.setFeeAmountStr(scopeVo.getSureAmount());
                    newDto.setControlRatio(scopeVo.getControlRatio());
                    newDto.setBudgetShares(dto.getBudgetShares());
                    newList.add(newDto);
                }
                continue;
            }
            newList.add(dto);
        }
        return newList;
    }

    @Override
    public void createValidateList(MarketingStrategyDto dto, List<MarketingStrategyItemDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        for (MarketingStrategyItemDto item : dtoList) {
            this.createValidate(item);
        }
        ObjectConvertStringUtil.convertObjectListStrProperties(dtoList, MarketingStrategyItemDto.class, (boolean)true, null);
        this.createValidateListHeadQuarters(dto, dtoList);
        this.createValidateListVertical(dto, dtoList);
    }

    public void createValidateListHeadQuarters(MarketingStrategyDto dto, List<MarketingStrategyItemDto> dtoList) {
        if (!BusinessUnitEnum.isDefaultBusinessUnit((String)dto.getBusinessUnitCode())) {
            return;
        }
        List budgetItemCodeList = dtoList.stream().map(MarketingStrategyItemBase::getBudgetItemCode).distinct().collect(Collectors.toList());
        List budgetItemVos = this.budgetItemService.listByCodes(budgetItemCodeList);
        if (CollectionUtils.isEmpty((Collection)budgetItemVos)) {
            throw new RuntimeException("\u9884\u7b97\u9879\u76ee\u67e5\u8be2\u5931\u8d25\uff01");
        }
        Map budgetItemMap = budgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity()));
        Calendar calendar = Calendar.getInstance();
        for (MarketingStrategyItemDto item : dtoList) {
            DateStringDealUtil.validateDateStrAndSet((String)item.getBeginDateStr(), (String)"\u65b0\u589e\u65f6\uff0c\u7b56\u7565\u660e\u7ec6\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (boolean)true, (String)"yyyy-MM-dd", arg_0 -> ((MarketingStrategyItemDto)item).setBeginDate(arg_0));
            DateStringDealUtil.validateDateStrAndSet((String)item.getEndDateStr(), (String)"\u65b0\u589e\u65f6\uff0c\u7b56\u7565\u660e\u7ec6\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (boolean)true, (String)"yyyy-MM-dd", arg_0 -> ((MarketingStrategyItemDto)item).setEndDate(arg_0));
            Validate.notBlank((CharSequence)item.getBudgetItemCode(), (String)"\u65b0\u589e\u65f6\uff0c\u7b56\u7565\u9884\u7b97\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            String allowAcrossMonth = BooleanEnum.FALSE.getCapital();
            BudgetItemVo budgetItemVo = (BudgetItemVo)budgetItemMap.get(item.getBudgetItemCode());
            if (null == budgetItemVo) {
                throw new RuntimeException("\u9884\u7b97\u9879\u76ee[" + item.getBudgetItemCode() + "]\u6709\u8bef\uff01");
            }
            if (StringUtils.isNotEmpty((CharSequence)budgetItemVo.getAllowCrossMonth())) {
                allowAcrossMonth = budgetItemVo.getAllowCrossMonth();
            }
            if (!BooleanEnum.FALSE.getCapital().equals(allowAcrossMonth)) continue;
            int year = Integer.parseInt(item.getStrategyYearMonth().substring(0, 4));
            int month = Integer.parseInt(item.getStrategyYearMonth().substring(5)) - 1;
            calendar.setTime(item.getBeginDate());
            if (calendar.get(1) != year || calendar.get(2) != month) {
                throw new RuntimeException("\u9884\u7b97\u9879\u76ee[" + item.getBudgetItemCode() + "]\u4e0d\u5141\u8bb8\u8de8\u6708\u4f7f\u7528\uff0c\u8bf7\u4fee\u6539\u7b56\u7565\u5f00\u59cb\u65f6\u95f4\u3001\u7b56\u7565\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            calendar.setTime(item.getEndDate());
            if (calendar.get(1) == year && calendar.get(2) == month) continue;
            throw new RuntimeException("\u9884\u7b97\u9879\u76ee[" + item.getBudgetItemCode() + "]\u4e0d\u5141\u8bb8\u8de8\u6708\u4f7f\u7528\uff0c\u8bf7\u4fee\u6539\u7b56\u7565\u5f00\u59cb\u65f6\u95f4\u3001\u7b56\u7565\u7ed3\u675f\u65f6\u95f4\uff01");
        }
    }

    public void createValidateListVertical(MarketingStrategyDto dto, List<MarketingStrategyItemDto> dtoList) {
        if (!BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
            return;
        }
        for (MarketingStrategyItemDto itemDto : dtoList) {
            BigDecimal costEffectivenessRatio = BigDecimal.ZERO;
            if (null != itemDto.getSalesGoalAmount() && BigDecimal.ZERO.compareTo(itemDto.getSalesGoalAmount()) != 0) {
                costEffectivenessRatio = Optional.ofNullable(itemDto.getFeeAmount()).orElse(BigDecimal.ZERO).divide(itemDto.getSalesGoalAmount(), 4, RoundingMode.HALF_UP);
            }
            itemDto.setCostEffectivenessRatio(costEffectivenessRatio);
        }
    }

    @Override
    public void tempSaveCreateValidateList(MarketingStrategyDto dto, List<MarketingStrategyItemDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        for (MarketingStrategyItemDto item : dtoList) {
            if (!StringUtils.isBlank((CharSequence)item.getStrategySignStr())) {
                NumberStringDealUtil.validateNumberStrAndSet((String)item.getStrategySignStr(), (String)"\u65b0\u589e\u65f6\uff0c\u7b56\u7565\u660e\u7ec6\u7b56\u7565\u6807\u8bc6", (boolean)true, arg_0 -> ((MarketingStrategyDto)dto).setStrategySign(arg_0), Integer.class);
            }
            if (StringUtils.isBlank((CharSequence)item.getFeeAmountStr())) continue;
            NumberStringDealUtil.validateNumberStrAndSet((String)item.getFeeAmountStr(), (String)"\u65b0\u589e\u65f6\uff0c\u7b56\u7565\u660e\u7ec6\u8d39\u7528\u91d1\u989d", (boolean)true, arg_0 -> ((MarketingStrategyDto)dto).setFeeAmount(arg_0), BigDecimal.class);
        }
        if (!BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
            for (MarketingStrategyItemDto item : dtoList) {
                if (!StringUtils.isBlank((CharSequence)item.getBeginDateStr())) {
                    DateStringDealUtil.validateDateStrAndSet((String)item.getBeginDateStr(), (String)"\u65b0\u589e\u65f6\uff0c\u7b56\u7565\u660e\u7ec6\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (boolean)true, (String)"yyyy-MM-dd", arg_0 -> ((MarketingStrategyItemDto)item).setBeginDate(arg_0));
                }
                if (StringUtils.isBlank((CharSequence)item.getEndDateStr())) continue;
                DateStringDealUtil.validateDateStrAndSet((String)item.getEndDateStr(), (String)"\u65b0\u589e\u65f6\uff0c\u7b56\u7565\u660e\u7ec6\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (boolean)true, (String)"yyyy-MM-dd", arg_0 -> ((MarketingStrategyItemDto)item).setEndDate(arg_0));
            }
        }
        ObjectConvertStringUtil.convertObjectListStrProperties(dtoList, MarketingStrategyItemDto.class, (boolean)true, null);
    }

    @Override
    public void createValidate(MarketingStrategyItemDto dto) {
        NumberStringDealUtil.validateNumberStrAndSet((String)dto.getStrategySignStr(), (String)"\u65b0\u589e\u65f6\uff0c\u7b56\u7565\u660e\u7ec6\u7b56\u7565\u6807\u8bc6", (boolean)true, arg_0 -> ((MarketingStrategyItemDto)dto).setStrategySign(arg_0), Integer.class);
        if (CollectionUtils.isEmpty((Collection)dto.getBudgetShares()) && StringUtils.isEmpty((CharSequence)dto.getMonthBudgetCode())) {
            throw new RuntimeException("\u65b0\u589e\u65f6\uff0c\u7b56\u7565\u660e\u7ec6\u9884\u7b97\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Validate.notBlank((CharSequence)dto.getActivityTypeCode(), (String)"\u65b0\u589e\u65f6\uff0c\u7b56\u7565\u660e\u7ec6\u6d3b\u52a8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getStrategyYearMonth(), (String)"\u65b0\u589e\u65f6\uff0c\u7b56\u7565\u660e\u7ec6\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        NumberStringDealUtil.validateNumberStrAndSet((String)dto.getFeeAmountStr(), (String)"\u65b0\u589e\u65f6\uff0c\u7b56\u7565\u660e\u7ec6\u8d39\u7528\u91d1\u989d", (boolean)true, arg_0 -> ((MarketingStrategyItemDto)dto).setFeeAmount(arg_0), BigDecimal.class);
        dto.setIsClose(BooleanEnum.FALSE.getCapital());
    }

    @Override
    public List<CommonSelectVo> findActivityTypeSelectList(ActivityTypeSelectDto dto) {
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return this.activityTypeService.findActivityTypeSelectList(dto);
    }

    @Override
    public List<CommonSelectVo> findActivityFormSelectList(ActivityFormSelectDto dto) {
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.isNotBlank((CharSequence)dto.getActivityTypeCode()) || StringUtils.isNotBlank((CharSequence)dto.getActivityTypeCodes()) ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)dto.getActivityTypeCodes())) {
            dto.setActivityTypeCodeList(Arrays.asList(dto.getActivityTypeCodes().split(",")));
        }
        return this.activityFormService.findActivityFormSelectList(dto);
    }

    @Override
    public List<MarketingStrategyItemScope> findShareScopeList(MarketingStrategyItemDto dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getBudgetShareRule())) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u5206\u644a\u89c4\u5219\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)dto.getFeeAmountStr())) {
            throw new RuntimeException("\u8d39\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BigDecimal feeAmount = null;
        try {
            feeAmount = new BigDecimal(dto.getFeeAmountStr());
        }
        catch (Exception e) {
            throw new RuntimeException("\u8d39\u7528\u91d1\u989d\u683c\u5f0f\u6709\u8bef\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)dto.getStrategyOrgCode())) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u8303\u56f4\uff01");
        }
        ArrayList result = Lists.newArrayList();
        Object[] orgCodeArr = dto.getStrategyOrgCode().split(",");
        String[] orgNameArr = new String[]{};
        if (StringUtils.isNotEmpty((CharSequence)dto.getStrategyOrgName())) {
            orgNameArr = dto.getStrategyOrgName().split(",");
        }
        for (int i = 0; i < orgCodeArr.length; ++i) {
            MarketingStrategyItemScope scopeVo = new MarketingStrategyItemScope();
            scopeVo.setScopeCode(orgCodeArr[i]);
            scopeVo.setScopeName(orgNameArr.length > i ? orgNameArr[i] : null);
            scopeVo.setAdjustAmount("0");
            scopeVo.setSystemShareAmount("0");
            scopeVo.setSureAmount("0");
            result.add(scopeVo);
        }
        BigDecimal leaveAmount = feeAmount;
        if (MarketingStrategyBudgetShareRuleEnum.ONE.getCode().equals(dto.getBudgetShareRule())) {
            BigDecimal average = feeAmount.divide(new BigDecimal(orgCodeArr.length), 6, RoundingMode.HALF_DOWN);
            String averageStr = average.toString();
            for (MarketingStrategyItemScope scopeVo : result) {
                scopeVo.setSystemShareAmount(averageStr);
                scopeVo.setSureAmount(averageStr);
                leaveAmount = leaveAmount.subtract(average);
            }
        } else if (MarketingStrategyBudgetShareRuleEnum.TWO.getCode().equals(dto.getBudgetShareRule())) {
            ArrayList regionCodeList = Lists.newArrayList((Object[])orgCodeArr);
            SalesGoalDto salesGoalDto = new SalesGoalDto();
            salesGoalDto.setRegionCodeList((List)regionCodeList);
            salesGoalDto.setProductBrandCode(dto.getProductBrandCode());
            salesGoalDto.setProductCode(dto.getProductCode());
            List salesGoalList = this.salesGoalService.findListGroupByRegion(salesGoalDto);
            if (CollectionUtils.isEmpty((Collection)salesGoalList)) {
                throw new RuntimeException("\u672a\u83b7\u53d6\u5230\u9500\u91cf\u4efb\u52a1\u6570\u636e\uff01");
            }
            BigDecimal totalSalesGoalQuantity = salesGoalList.stream().map(SalesGoalVo::getTaskQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            Map<String, BigDecimal> salesGoalMap = salesGoalList.stream().collect(Collectors.toMap(SalesGoalVo::getRegionCode, SalesGoalVo::getTaskQuantity));
            for (MarketingStrategyItemScope scopeVo : result) {
                BigDecimal regionTaskQuantity;
                if (!salesGoalMap.containsKey(scopeVo.getScopeCode()) || (regionTaskQuantity = salesGoalMap.get(scopeVo.getScopeCode())).compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal amount = feeAmount.multiply(regionTaskQuantity).divide(totalSalesGoalQuantity, 6, RoundingMode.HALF_DOWN);
                scopeVo.setSystemShareAmount(amount.toString());
                scopeVo.setSureAmount(scopeVo.getSystemShareAmount());
            }
        }
        if (leaveAmount.compareTo(BigDecimal.ZERO) != 0) {
            MarketingStrategyItemScope lastVo = (MarketingStrategyItemScope)result.get(result.size() - 1);
            lastVo.setSystemShareAmount(new BigDecimal(lastVo.getSureAmount()).add(leaveAmount).toString());
            lastVo.setSureAmount(lastVo.getSystemShareAmount());
        }
        return result;
    }

    @Override
    public Integer getTotal(String cacheKey) {
        String redisCacheKey = "marketing_strategy:item_cache:id:" + cacheKey;
        return this.redisService.lSize(redisCacheKey).intValue();
    }

    @Override
    public List<MarketingStrategyItemVo> findByCodes(List<String> itemCodes) {
        if (CollectionUtils.isEmpty(itemCodes)) {
            return Lists.newArrayList();
        }
        List<MarketingStrategyItemVo> list = this.marketingStrategyItemRepository.findByCodes(itemCodes);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    @Override
    public Integer itemExportGetTotal(MarketingStrategyItemDto dto) {
        if (Objects.isNull(dto)) {
            return 0;
        }
        dto = Optional.ofNullable(dto).orElse(new MarketingStrategyItemDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        return this.marketingStrategyItemRepository.itemExportGetTotal(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Page<MarketStrategyItemExportVo> itemExportGetDate(Pageable pageable, MarketingStrategyItemDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new MarketingStrategyItemDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.marketingStrategyItemRepository.itemExportGetDate((Page<MarketStrategyItemExportVo>)page, dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void closeMarketingStrategyItem(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List itemList = this.marketingStrategyItemRepository.listByIds(ids);
        if (CollectionUtils.isEmpty((Collection)itemList)) {
            return;
        }
        for (MarketingStrategyItem marketingStrategyItem : itemList) {
            if (!BooleanEnum.TRUE.getCapital().equals(marketingStrategyItem.getIsClose())) continue;
            throw new RuntimeException("\u7b56\u7565\u660e\u7ec6[" + marketingStrategyItem.getStrategyItemCode() + "]\u5df2\u5173\u95ed\uff01");
        }
        List strategyCodeList = itemList.stream().map(MarketingStrategyItem::getStrategyCode).distinct().collect(Collectors.toList());
        List<String> strategyItemCodeList = itemList.stream().map(MarketingStrategyItem::getStrategyItemCode).collect(Collectors.toList());
        MarketingStrategyDto marketingStrategyDto = new MarketingStrategyDto();
        marketingStrategyDto.setStrategyCodeList(strategyCodeList);
        List<MarketingStrategy> strategyList = this.marketingStrategyRepository.findList(marketingStrategyDto);
        String businessUnitCode = null;
        for (MarketingStrategy strategy : strategyList) {
            if (!ProcessStatusEnum.PASS.getDictCode().equals(strategy.getProcessStatus())) {
                throw new RuntimeException("\u7b56\u7565[" + strategy.getStrategyCode() + "]\u672a\u5ba1\u6279\u901a\u8fc7\uff01");
            }
            businessUnitCode = strategy.getBusinessUnitCode();
        }
        MarketingStrategyQueryActivityPlanDto queryActivityPlanDto = new MarketingStrategyQueryActivityPlanDto();
        queryActivityPlanDto.setStrategyItemCodeList(strategyItemCodeList);
        SerializableBiConsumer & Serializable queryActivityPlan = MarketingStrategyQueryActivityPlanListener::findActivityPlanList;
        MarketingStrategyQueryActivityPlanResponse queryActivityPlanResponse = (MarketingStrategyQueryActivityPlanResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)queryActivityPlanDto, MarketingStrategyQueryActivityPlanListener.class, (SerializableBiConsumer)queryActivityPlan);
        if (null != queryActivityPlanResponse && !CollectionUtils.isEmpty((Collection)queryActivityPlanResponse.getPlanList())) {
            StringBuilder builder = new StringBuilder();
            for (StrategyActivityPlanItemVo strategyActivityPlanItemVo : queryActivityPlanResponse.getPlanList()) {
                if (BooleanEnum.TRUE.getCapital().equals(strategyActivityPlanItemVo.getIsClose())) continue;
                builder.append("\u7b56\u7565\u660e\u7ec6[").append(strategyActivityPlanItemVo.getRelateStrategyItemCode()).append("]\u5df2\u88ab\u6d3b\u52a8\u65b9\u6848[").append(strategyActivityPlanItemVo.getPlanCode()).append("]\u5173\u8054\uff0c\u65e0\u6cd5\u5173\u95ed,");
            }
            if (StringUtils.isNotEmpty((CharSequence)builder)) {
                throw new RuntimeException(builder.toString());
            }
        }
        this.marketingStrategyItemRepository.updateCloseStatus(strategyItemCodeList);
        List<MarketingStrategyBudget> budgetList = this.marketingStrategyBudgetRepository.listByStrategyItemCodeList(strategyItemCodeList);
        List marketingStrategyBudgetDtos = (List)this.nebulaToolkitService.copyCollectionByBlankList(budgetList, MarketingStrategyBudget.class, MarketingStrategyBudgetDto.class, HashSet.class, ArrayList.class, new String[0]);
        for (MarketingStrategyBudgetDto marketingStrategyBudgetDto : marketingStrategyBudgetDtos) {
            marketingStrategyBudgetDto.setBusinessUnitCode(businessUnitCode);
        }
        this.marketingStrategyBudgetService.returnMonthBudget(marketingStrategyBudgetDtos);
    }
}

