/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.marketing.strategy.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.service.MarketingStrategyLockSdkService;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class MarketingStrategyLockSdkServiceImpl
implements MarketingStrategyLockSdkService {
    @Autowired(required=false)
    private RedisLockService redisLockService;

    public boolean lock(String code, TimeUnit timeUnit, int time) {
        Assert.hasLength((String)code, (String)"\u8425\u9500\u7b56\u7565\u52a0\u9501\u5931\u8d25\uff0c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        return this.lock(Collections.singletonList(code), timeUnit, time);
    }

    public boolean lock(List<String> codeList, TimeUnit timeUnit, int time) {
        Assert.notEmpty(codeList, (String)"\u8425\u9500\u7b56\u7565\u52a0\u9501\u5931\u8d25\uff0c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        if (Objects.isNull((Object)timeUnit)) {
            timeUnit = TimeUnit.MINUTES;
        }
        if (time < 1) {
            time = 3;
        }
        return this.redisLockService.batchLock("tpm:marketing_strategy:lock:", codeList, timeUnit, time);
    }

    public void unlock(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return;
        }
        this.unlock(Collections.singletonList(code));
    }

    public void unlock(List<String> codeList) {
        if (CollectionUtil.isEmpty(codeList)) {
            return;
        }
        this.redisLockService.batchUnLock("tpm:marketing_strategy:lock:", codeList);
    }
}

