/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.marketing.strategy.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.NumberStringDealUtil;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.marketing.strategy.local.repository.MarketingStrategyItemRepository;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.pojo.MarketingStrategyItemBase;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class MarketingStrategyPageCacheHelper
extends MnPageCacheHelper<MarketingStrategyItemVo, MarketingStrategyItemDto> {
    @Autowired(required=false)
    private MarketingStrategyItemRepository marketingStrategyItemRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public String getCacheKeyPrefix() {
        return "marketing_strategy:item_cache:";
    }

    public Class<MarketingStrategyItemDto> getDtoClass() {
        return MarketingStrategyItemDto.class;
    }

    public Class<MarketingStrategyItemVo> getVoClass() {
        return MarketingStrategyItemVo.class;
    }

    public List<MarketingStrategyItemDto> findDtoListFromRepository(MarketingStrategyItemDto dto, String cacheKey) {
        if (StringUtils.isEmpty((CharSequence)dto.getStrategyCode())) {
            return Lists.newArrayList();
        }
        List<MarketingStrategyItemDto> dtoList = this.marketingStrategyItemRepository.findDtoAndAttachListByStrategyCode(dto.getStrategyCode());
        dtoList.sort(Comparator.comparing(MarketingStrategyItemBase::getStrategyItemCode));
        return dtoList;
    }

    public List<MarketingStrategyItemDto> newItem(String cacheKey, List<MarketingStrategyItemDto> itemList) {
        MarketingStrategyItemDto newItem = new MarketingStrategyItemDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return Lists.newArrayList((Object[])new MarketingStrategyItemDto[]{newItem});
    }

    public List<MarketingStrategyItemDto> copyItem(String cacheKey, List<MarketingStrategyItemDto> itemList) {
        List newItemList = (List)this.nebulaToolkitService.copyCollectionByBlankList(itemList, MarketingStrategyItemDto.class, MarketingStrategyItemDto.class, HashSet.class, ArrayList.class, new String[0]);
        for (MarketingStrategyItemDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setStrategyItemCode(null);
        }
        return newItemList;
    }

    public void updateItem(String cacheKey, List<MarketingStrategyItemDto> itemList) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (null == requestAttributes) {
            return;
        }
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
        String businessUnitCode = servletRequestAttributes.getRequest().getParameter("businessUnitCode");
        if (BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)) {
            for (MarketingStrategyItemDto itemDto : itemList) {
                if (CollectionUtils.isEmpty((Collection)itemDto.getBudgetShares())) continue;
                BigDecimal feeAmount = BigDecimal.ZERO;
                HashSet monthBudgetCodeSet = Sets.newHashSet();
                HashSet budgetItemCodeSet = Sets.newHashSet();
                HashSet budgetItemNameSet = Sets.newHashSet();
                for (MarketingStrategyBudgetDto budgetDto : itemDto.getBudgetShares()) {
                    if (StringUtils.isEmpty((CharSequence)budgetDto.getFeeBelongCode())) continue;
                    if (StringUtils.isNotEmpty((CharSequence)budgetDto.getUseAmountStr())) {
                        NumberStringDealUtil.validateNumberStrAndSet((String)budgetDto.getUseAmountStr(), (String)"\u672c\u6b21\u4f7f\u7528\u9884\u7b97\u91d1\u989d", (boolean)false, arg_0 -> ((MarketingStrategyBudgetDto)budgetDto).setUseAmount(arg_0), BigDecimal.class);
                        feeAmount = feeAmount.add(budgetDto.getUseAmount());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)budgetDto.getMonthBudgetCode())) {
                        monthBudgetCodeSet.add(budgetDto.getMonthBudgetCode());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)budgetDto.getBudgetItemCode())) {
                        budgetItemCodeSet.add(budgetDto.getBudgetItemCode());
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)budgetDto.getBudgetItemName())) continue;
                    budgetItemNameSet.add(budgetDto.getBudgetItemName());
                }
                itemDto.setFeeAmount(feeAmount);
                itemDto.setFeeAmountStr(feeAmount.toString());
                itemDto.setMonthBudgetCode(String.join((CharSequence)",", monthBudgetCodeSet));
                itemDto.setBudgetItemCode(String.join((CharSequence)",", budgetItemCodeSet));
                itemDto.setBudgetItemName(String.join((CharSequence)",", budgetItemNameSet));
                BigDecimal costEffectivenessRatio = BigDecimal.ZERO;
                if (StringUtils.isNotEmpty((CharSequence)itemDto.getFeeAmountStr())) {
                    feeAmount = new BigDecimal(itemDto.getFeeAmountStr());
                }
                if (null != itemDto.getSalesGoalAmount() && BigDecimal.ZERO.compareTo(itemDto.getSalesGoalAmount()) != 0) {
                    costEffectivenessRatio = feeAmount.divide(itemDto.getSalesGoalAmount(), 4, RoundingMode.HALF_UP);
                }
                itemDto.setCostEffectivenessRatio(costEffectivenessRatio);
            }
        }
    }

    public Object getDtoKey(MarketingStrategyItemDto marketingStrategyItemDto) {
        return marketingStrategyItemDto.getId();
    }

    public String getCheckedStatus(MarketingStrategyItemDto marketingStrategyItemDto) {
        return marketingStrategyItemDto.getChecked();
    }
}

